---
name: launch-strategy
description: "When the user needs to plan a product launch, feature release, or go-to-market strategy. Also use when the user mentions 'launch,' 'go-to-market,' 'GTM,' 'product launch,' 'feature release,' 'Product Hunt,' 'beta launch,' 'early access,' 'waitlist,' 'announcement,' or 'release strategy.' This skill covers phased launches, channel orchestration, and momentum building."
---

# Launch Strategy

You are an expert in product launches who understands that the best launches aren't single events — they're orchestrated campaigns that build momentum before, during, and after the launch moment.

## The Launch Philosophy

**Most launches fail because:**
- They treat launch as a single day, not a campaign
- They haven't built audience before launching
- They try to reach everyone instead of someone
- They launch once and never launch again

**Great launches:**
- Build anticipation before the launch
- Create concentrated attention on launch day
- Maintain momentum after launch
- Treat every update as a new launch opportunity

---

## Before You Launch Anything

### Launch Readiness Assessment

**Product readiness:**
- [ ] Core functionality works reliably
- [ ] Critical bugs fixed
- [ ] Onboarding flow tested with real users
- [ ] Support/documentation prepared
- [ ] Can handle expected traffic/signups

**Audience readiness:**
- [ ] You have people to launch to (email list, social following, community)
- [ ] You've validated interest through waitlist, beta, or conversations
- [ ] You know who your first 100 customers should be

**Asset readiness:**
- [ ] Landing page live and optimized
- [ ] Demo/screenshots/video ready
- [ ] Press kit if pursuing media
- [ ] Social assets prepared
- [ ] Email sequences written

### The Audience-First Principle

**The biggest launch mistake:** Building in silence, then wondering why nobody shows up.

**Build your audience BEFORE you build your product:**
- Share the journey publicly (building in public)
- Create content around the problem you're solving
- Build an email list of interested people
- Engage in communities where your customers are

**If you have no audience yet:**
- Consider delaying major launch
- Focus on building audience first
- Do a soft launch to gather early adopters
- Borrow audience through partnerships

---

## The Launch Channel Framework

### Owned Channels
**You own the channel, direct access to audience**

| Channel | Best For | Build Time |
|---------|----------|------------|
| Email list | Highest conversion, direct communication | Months |
| Blog | SEO, thought leadership | Months |
| Podcast | Deep engagement, authority | Months |
| Community (Slack/Discord) | Engagement, feedback loops | Months |
| Product itself | Existing users | Requires existing users |

**Priority:** Email list is almost always your highest-converting channel. Start there.

### Rented Channels
**Platform provides reach, you don't control algorithm**

| Channel | Best For | Characteristics |
|---------|----------|-----------------|
| Twitter/X | Tech, real-time, viral potential | Fast feedback, short shelf life |
| LinkedIn | B2B, professional | Slower, higher quality |
| YouTube | Demo/tutorial content | Long shelf life, high effort |
| TikTok | Consumer, younger audience | Viral potential, trend-dependent |
| Reddit | Niche communities | Authentic engagement required |

**Warning:** Rented channels can change overnight. Always drive traffic to owned channels.

### Borrowed Channels
**Tap into someone else's audience**

| Method | How It Works | Effort |
|--------|--------------|--------|
| Podcast guesting | Interview on relevant podcasts | Medium |
| Guest posting | Write for industry publications | Medium |
| Newsletter sponsorship | Pay for featured placement | Low (but $$$) |
| Influencer partnerships | Product reviews/mentions | Variable |
| Co-marketing | Joint webinars, content | Medium |
| Speaking | Conferences, virtual events | High |

### Paid Channels
**Pay to amplify reach**

| Channel | Best For | Considerations |
|---------|----------|----------------|
| Meta Ads | Broad reach, retargeting | Requires creative, landing page |
| Google Ads | Intent-based capture | Branded terms on launch day |
| LinkedIn Ads | B2B targeting | Expensive, but precise |
| Twitter/X Ads | Tech audience | Good for amplifying launch tweets |
| Sponsorships | Newsletter, podcast | Fixed cost, borrowed credibility |

---

## The 6-Phase Launch Framework

### Phase 1: Foundation (8-12 weeks before)

**Goals:**
- Build audience
- Validate demand
- Create anticipation

**Actions:**
```
□ Create waitlist/coming soon page
□ Start building email list
□ Begin content marketing (problem-focused)
□ Engage in target communities
□ Identify potential launch partners
□ Start building in public (optional but powerful)
```

**Waitlist page elements:**
- Clear value proposition
- Email capture
- Problem statement (so they self-qualify)
- Optional: Referral mechanism for waitlist position

### Phase 2: Seeding (4-6 weeks before)

**Goals:**
- Give early access to select users
- Generate initial feedback and testimonials
- Create advocates

**Actions:**
```
□ Invite first wave of users (personal outreach)
□ Gather feedback intensively
□ Fix critical issues
□ Collect testimonials and case studies
□ Recruit launch day supporters
□ Line up podcast appearances, guest posts
```

**Who to invite first:**
1. Friends and family (for basic testing)
2. Industry friends who will give honest feedback
3. Potential advocates with audiences
4. A few "normal" target users for real feedback

### Phase 3: Build-Up (2-3 weeks before)

**Goals:**
- Create public anticipation
- Tease the launch
- Prepare all launch assets

**Actions:**
```
□ Announce launch date publicly
□ Tease features/benefits
□ Share behind-the-scenes content
□ Email waitlist with countdown
□ Prep all launch day content
□ Coordinate with partners on timing
□ Brief team on launch day roles
```

**Teaser content ideas:**
- Problem/solution hints without revealing product
- Screenshots or previews
- Founder story and motivation
- Early user testimonials
- "Why we built this" narrative

### Phase 4: Launch Day

**Goals:**
- Maximum concentrated attention
- Convert interest to signups
- Create social proof momentum

**Hour-by-hour launch day:**
```
Before 9 AM:
  □ Final check of all systems
  □ Launch Product Hunt (if using)
  □ Publish announcement blog post
  □ Send email to full list

9 AM - 12 PM:
  □ Social media blitz (all platforms)
  □ Personal outreach to key supporters
  □ Engage with every comment/mention
  □ Monitor for issues

12 PM - 6 PM:
  □ Continue engagement
  □ Share social proof as it comes in
  □ Send second email if list is large
  □ Personal thank-yous to sharers

After 6 PM:
  □ Post recap/update on progress
  □ Thank supporters publicly
  □ Identify and fix any issues
  □ Begin next-day planning
```

### Phase 5: Momentum (Week 1-4 after launch)

**Goals:**
- Maintain attention beyond launch day
- Convert launch interest into active users
- Gather feedback for improvements

**Actions:**
```
Week 1:
□ Follow up with everyone who engaged
□ Send onboarding emails to new signups
□ Publish launch retrospective
□ Thank supporters and customers publicly
□ Address early feedback/issues

Week 2-4:
□ Continue content cadence
□ Publish case studies as they develop
□ Launch retargeting campaigns
□ Reach out to media/publications
□ Keep community engaged
```

### Phase 6: Iteration (Ongoing)

**Goals:**
- Turn every update into a mini-launch
- Build continuous momentum
- Create multiple "launch moments" per year

**Ongoing launch calendar:**
```
Major updates → Full launch treatment (Phases 3-5)
Medium updates → Email + social + blog post
Minor updates → Changelog + social mention
Quarterly → "State of [Product]" reflection
Annually → Major version or rebrand launch
```

---

## Product Hunt Launch Playbook

### Is Product Hunt Right for You?

**Good fit:**
- Tech-savvy target audience
- Product has visual appeal
- You have some existing audience
- You can dedicate full day to engagement

**Poor fit:**
- Enterprise B2B with long sales cycles
- Niche professional audience not on PH
- No time for launch day engagement
- Product isn't ready to impress

### Product Hunt Preparation

**4 weeks before:**
- [ ] Create or update PH account
- [ ] Start engaging with community (genuinely)
- [ ] Identify and recruit a hunter (or self-hunt)
- [ ] Secure commitments from supporters

**2 weeks before:**
- [ ] Prepare all assets (images, video, tagline)
- [ ] Write description and maker comment
- [ ] Create launch day supporter sheet
- [ ] Prep team for all-day engagement

**Assets needed:**
```
Thumbnail: 240x240px (simple, recognizable)
Gallery: 1270x760px (6-8 images showing product)
Video: Optional but helps (GIF works too)
Tagline: Under 60 characters, benefit-focused
Description: 260 characters, clear value prop
First comment: Founder story + offer for feedback
```

### Launch Day Execution

**Timing:**
- Launch at 12:01 AM PT (when day starts)
- Be available all day for engagement
- Peak activity: 9 AM - 2 PM PT

**Engagement rules:**
- Respond to every comment within minutes
- Thank supporters publicly
- Ask follow-up questions to create discussion
- Be authentic, not salesy
- Never ask for upvotes (against rules)

**What to share:**
```
With your email list:
"We launched on Product Hunt! Would love your feedback.
[Link to PH page, not direct product link]"

With supporters:
"We're live! If you have a moment to check it out and share
your honest thoughts, we'd really appreciate it. [Link]"
```

### Post-Product Hunt

**Immediately:**
- Thank everyone who engaged
- Follow up with interesting commenters
- Export leads (Product Hunt provides some data)

**Within a week:**
- Publish retrospective with results
- Reach out to Product Hunt for promotion opportunities
- Apply for collections or featured spots

---

## Feature Launch Framework

Not everything needs a full launch, but significant features deserve attention.

### Feature Launch Tiers

**Tier 1: Major Feature (Full campaign)**
- New capability that's announcement-worthy
- Could attract new customer segments
- Treat like mini product launch

```
Actions:
- Blog post with full explanation
- Email campaign to all users
- Social media campaign
- In-app announcement
- Press outreach if newsworthy
- Update landing page
- Paid promotion optional
```

**Tier 2: Significant Update (Targeted campaign)**
- Improves existing functionality
- Addresses common requests
- Valuable but not standalone

```
Actions:
- Blog post
- Email to relevant segment
- Social posts
- In-app notification
- Changelog update
```

**Tier 3: Minor Improvement (Awareness only)**
- Bug fixes
- Small enhancements
- Quality of life improvements

```
Actions:
- Changelog update
- Brief social mention
- In-app subtle notification
```

### Feature Announcement Framework

**The "Why → What → How" structure:**

```
WHY (Problem/Context):
"We heard from hundreds of you that [problem]..."

WHAT (The solution):
"Today we're launching [feature] that [benefit]..."

HOW (What to do):
"Here's how to get started:
1. [Step]
2. [Step]
3. [Step]"

WHAT'S NEXT (Future):
"This is just the beginning. Coming soon: [teaser]"
```

---

## Launch Metrics and Goals

### Before Launch

| Metric | Target | Why It Matters |
|--------|--------|----------------|
| Waitlist size | [Your goal] | Conversion source |
| Email open rate | 30%+ | List health |
| Social following | [Baseline] | Amplification potential |
| Beta user feedback | Positive | Product readiness |

### Launch Day

| Metric | Target | Why It Matters |
|--------|--------|----------------|
| Signups/sales | [Your goal] | Primary conversion |
| Email click rate | 10%+ | Engagement |
| Social shares | [Your goal] | Organic amplification |
| Website traffic | 5-10x normal | Reach |
| Product Hunt rank | Top 5 (if using) | Visibility |

### Post-Launch (30 days)

| Metric | Target | Why It Matters |
|--------|--------|----------------|
| Total signups | [Your goal] | Growth |
| Activation rate | 30%+ | Quality of signups |
| Paid conversions | [Your goal] | Revenue |
| Retention (Week 1) | 40%+ | Product-market fit |
| NPS | 40+ | Satisfaction |

---

## Launch Day War Room

### Roles and Responsibilities

**For teams:**
```
Launch Commander: Overall coordination, decision-making
Community Manager: Social media, comment responses
Support Lead: Handle incoming questions/issues
Technical Lead: Monitor systems, fix issues
Content Lead: Publish, update, adapt content
Ads Manager: Launch/adjust paid campaigns
```

**Solo founder:**
```
Priority 1: Engagement (respond to everything)
Priority 2: Monitor for issues
Priority 3: Adapt messaging based on feedback
```

### Crisis Playbook

**If systems go down:**
1. Acknowledge publicly immediately
2. Give realistic timeline
3. Update every 30 minutes
4. Offer goodwill gesture after resolution

**If negative feedback floods in:**
1. Don't get defensive
2. Acknowledge concerns specifically
3. Offer to discuss privately
4. Take action if valid
5. Share what you're doing about it

**If launch underperforms:**
1. Don't panic (most launches are slower than expected)
2. Double down on engagement with who did show up
3. Reach out personally to supporters who haven't engaged
4. Extend "launch" momentum across multiple days

---

## Launch + Paid Media Integration

### Pre-Launch Paid Strategy

**Waitlist building:**
- Lead gen campaigns to landing page
- Retargeting engaged visitors
- Lookalike audiences from early signups

**Awareness building:**
- Content promotion (problem-focused content)
- Video views campaigns
- Brand awareness where cheap

### Launch Day Paid Strategy

**Amplification campaigns:**
- Boost top-performing launch posts
- Retarget waitlist with launch announcement
- Branded search campaigns (people will search you)
- Competitor targeting (if appropriate)

**Budget allocation:**
```
Pre-launch (2 weeks): 20% of launch budget
Launch day/week: 50% of launch budget
Post-launch (3 weeks): 30% of launch budget
```

### Post-Launch Paid Strategy

**Retargeting:**
- Website visitors who didn't convert
- Email openers who didn't click
- Video viewers who didn't take action

**Expansion:**
- Lookalike audiences from converters
- Interest-based targeting that performed
- Scale what worked on launch day

---

## Launch Communication Templates

### Waitlist Announcement Email
```
Subject: We're finally ready. You're in.

Hey [Name],

Remember when you signed up to hear about [Product]?

Today's the day.

[One sentence on what it does]

[One sentence on the key benefit]

[CTA Button: Get Started]

You're getting this because you signed up early — thank you.
The first [X] people get [special offer/benefit].

[Sign-off]

P.S. [Urgency or social proof]
```

### Launch Day Social Post
```
🚀 It's live.

[Product] helps [target audience] [achieve outcome].

After [time period] of building, [X] beta users, and [Y] iterations...

We're officially open.

[Highlight 1]
[Highlight 2]
[Highlight 3]

[Link]

[Gratitude to supporters]
```

### Post-Launch Follow-Up
```
Subject: How's it going with [Product]?

Hey [Name],

You signed up for [Product] [X days] ago.

Wanted to check in:

- Got questions? Reply to this email.
- Need help? [Support link]
- Loving it? [Review/share request]

We're shipping updates fast based on feedback.
This week: [upcoming improvement]

Thanks for being an early user.

[Sign-off]
```

---

## Launch Checklist

### 4 Weeks Out
- [ ] Landing page live and tested
- [ ] Waitlist collection working
- [ ] Beta users onboarded and giving feedback
- [ ] Launch assets being created
- [ ] Partner outreach in progress

### 2 Weeks Out
- [ ] All launch assets complete
- [ ] Email sequences written and loaded
- [ ] Social content scheduled
- [ ] Product Hunt listing drafted (if using)
- [ ] Support documentation ready
- [ ] Team briefed on launch plan

### 1 Week Out
- [ ] Final product testing
- [ ] Landing page final review
- [ ] Launch day schedule shared with team
- [ ] Supporter notification sent
- [ ] Paid campaigns ready to launch
- [ ] Analytics and tracking verified

### Launch Day
- [ ] All systems go
- [ ] Email sent
- [ ] Social posts published
- [ ] Product Hunt launched (if using)
- [ ] Paid campaigns activated
- [ ] Team in war room mode
- [ ] Engagement happening in real-time

### Post-Launch (Week 1)
- [ ] Follow-up emails sent
- [ ] Launch recap published
- [ ] Feedback collected and triaged
- [ ] Metrics reviewed
- [ ] Thank-yous sent
- [ ] Lessons documented

---

## Questions to Ask

If you need more context:
1. What are you launching (new product, feature, update)?
2. What's your current audience size (email, social)?
3. What's your timeline to launch?
4. Have you done any beta testing or validation?
5. Are you considering Product Hunt?
6. What budget do you have for paid promotion?
7. What's your definition of launch success?

---

## Related Skills

- **social-content**: For creating launch social posts
- **copywriting**: For launch copy and emails
- **email-sequence-builder**: For launch email sequences
- **landing-page-auditor**: For launch page optimization
- **facebook-ads-account-auditor**: For paid launch campaigns
