---
name: ugc-brief-generator
description: Creates detailed UGC creator briefs based on winning ad patterns, ensuring new content replicates what actually converts.
---

# UGC Brief Generator

## Purpose

Transform performance data and winning patterns into actionable creator briefs that:
- Replicate elements proven to convert
- Provide clear direction without over-scripting
- Enable creators to bring authenticity while hitting key points
- Reduce production waste from ineffective content

**Core Philosophy:** The best UGC briefs are built from data, not assumptions. Every brief element should trace back to something that worked.

---

## When to Use This Skill

- After identifying winning creative patterns (via meta-ads-creative-ranker)
- Before onboarding new UGC creators
- When refreshing content for fatigued creatives
- When scaling content production
- When current UGC isn't converting

---

## Required Context

| Data Point | Required | Notes |
|------------|----------|-------|
| Winning creative analysis | Yes | From meta-ads-creative-ranker or similar |
| Top performing hooks | Yes | What grabs attention |
| Top performing CTAs | Yes | What drives action |
| Product/offer details | Yes | What we're selling |
| Target audience profile | Yes | Who we're talking to |
| Brand guidelines | Helpful | Tone, restrictions |
| Previous UGC performance | Helpful | What worked/didn't |
| Platform requirements | Yes | TikTok vs. Meta vs. YouTube |

---

## Brief Structure Framework

Every UGC brief should contain these sections:

### 1. Creative Overview
### 2. Hook Prescription
### 3. Content Body Guidelines
### 4. CTA Direction
### 5. Technical Requirements
### 6. Do's and Don'ts
### 7. Reference Examples

---

## Section 1: Creative Overview

### Template

```
CREATIVE OVERVIEW

Brief Name: [Descriptive name]
Brief ID: [UGC-XXX]
Due Date: [Date]

OBJECTIVE:
[One sentence describing what this content should achieve]

PERFORMANCE BENCHMARK:
This brief is based on [Creative Name] which achieved:
- CPA: $XX (XX% better than average)
- CTR: X.X%
- Hook Rate: XX%
- Key winning element: [What made it work]

CREATOR REQUIREMENTS:
- Demographics: [Age, gender if relevant]
- Vibe: [Energy level, personality type]
- Setting: [Where they should film]
- Product interaction: [How they should use/show product]
```

### Overview Types by Objective

| Objective | Brief Focus | Key Metric |
|-----------|-------------|------------|
| **Awareness** | Attention-grabbing, memorable | Hook rate, watch time |
| **Consideration** | Educational, trust-building | Hold rate, clicks |
| **Conversion** | Action-driving, urgent | CPA, ROAS |
| **Retargeting** | Objection-handling, social proof | Conversion rate |

---

## Section 2: Hook Prescription

The first 3 seconds determine everything. Be specific.

### Hook Types with Templates

| Hook Type | When to Use | Template | Example |
|-----------|-------------|----------|---------|
| **Problem-Agitate** | Pain point is clear and relatable | "I was so [frustrated/tired/sick of] [problem]..." | "I was so tired of protein powders that tasted like chalk..." |
| **Bold Claim** | Strong differentiator exists | "This is the only [product] that [unique benefit]" | "This is the only pre-workout that doesn't make me jittery" |
| **Transformation** | Before/after is compelling | "[Show before state] → [Show after state]" | *Shows messy desk* → *Shows organized desk* |
| **Social Proof** | Numbers are impressive | "[Number] people [action/result]" | "100,000 people have already switched to this" |
| **Direct Address** | Targeting specific audience | "If you're a [specific person] who [specific behavior]..." | "If you're a busy mom who can't get to the gym..." |
| **Demonstration** | Product benefit is visual | *[Immediate product demo with wow factor]* | *Stain disappears instantly* |
| **Curiosity** | Product has surprising element | "Wait until you see what happens when..." | "Wait until you see what this does to your skin" |
| **Unboxing** | Packaging/reveal is exciting | *[Genuine reaction to opening product]* | *Eyes widen* "Okay this packaging is actually insane" |

### Hook Prescription Template

```
HOOK (First 3 Seconds)

TYPE: [Hook type from above]

MUST INCLUDE:
- [Specific element 1]
- [Specific element 2]

EXACT OPENING OPTIONS (choose one or improvise within pattern):
Option A: "[Scripted line]"
Option B: "[Scripted line]"
Option C: "[Scripted line]"

VISUAL REQUIREMENT:
[What should be on screen during hook]

DO NOT:
- [Common hook mistake to avoid]
- [Another mistake]

WHY THIS HOOK:
[Reference to data: "This hook style performed XX% better than alternatives in testing"]
```

---

## Section 3: Content Body Guidelines

The middle section maintains interest and builds toward the CTA.

### Body Structure Options

| Structure | Duration | Flow | Best For |
|-----------|----------|------|----------|
| **Problem-Solution-Proof** | 15-30s | Pain → Product → Result | Conversion campaigns |
| **Story Arc** | 30-60s | Setup → Conflict → Resolution | Consideration/awareness |
| **Feature Stack** | 15-30s | Benefit 1 → Benefit 2 → Benefit 3 | Product launches |
| **Day-in-the-Life** | 30-60s | Morning → [Product use] → Results | Lifestyle products |
| **Comparison** | 15-30s | Old way → New way (our product) | Switching campaigns |
| **Tutorial** | 30-60s | Step 1 → Step 2 → Step 3 → Result | Complex products |

### Content Body Template

```
CONTENT BODY (After Hook)

STRUCTURE: [Structure type from above]

KEY MESSAGES (Must Include):
1. [Primary benefit/message]
2. [Secondary benefit/message]
3. [Proof point or social validation]

TALKING POINTS:
- "[Specific line or concept to cover]"
- "[Specific line or concept to cover]"
- "[Specific line or concept to cover]"

PRODUCT SHOWCASE MOMENTS:
- At [X seconds]: [Show product doing Y]
- At [X seconds]: [Show result/benefit Z]

TONE GUIDANCE:
[Specific tone: conversational, excited, matter-of-fact, relatable, aspirational]

AUTHENTICITY NOTES:
[What should feel genuine vs. what's required]
```

### Talking Points by Pain Point

| Pain Point | What to Say | What NOT to Say |
|------------|-------------|-----------------|
| **Price concern** | "I was skeptical about the price but..." | "It's so cheap!" |
| **Skepticism** | "I didn't believe it either until..." | "This changed my life!" |
| **Complexity** | "It's actually so simple..." | "Anyone can do it!" |
| **Time concern** | "I only had to spend [X minutes]..." | "It's instant!" |

---

## Section 4: CTA Direction

The ending drives action. Match CTA to funnel stage.

### CTA Types with Scripts

| CTA Type | Best For | Script Options |
|----------|----------|----------------|
| **Urgency** | Limited offers | "Click the link before it's gone" / "Sale ends [day]" |
| **Value** | Free trials, discounts | "Click below to get [X]% off" / "Try it free for [X] days" |
| **Social** | Social proof heavy | "Join [X] others who..." / "See why everyone's switching" |
| **Curiosity** | Consideration stage | "Click to learn more" / "See how it works" |
| **Direct** | Retargeting | "Click to order yours" / "Get yours now" |

### CTA Prescription Template

```
CTA (Final 3-5 Seconds)

TYPE: [CTA type from above]

VERBAL CTA:
Primary option: "[Exact script]"
Alternative: "[Exact script]"

VISUAL CTA:
[What should be on screen - product, pointing gesture, text overlay, etc.]

ENERGY:
[Excited, calm, urgent, friendly - match to overall tone]

OFFER TO MENTION:
[Specific offer: "20% off with code X" or "Free shipping" etc.]

DO NOT:
- Sound scripted or salesy
- Rush through the CTA
- Forget to mention [specific offer detail]
```

---

## Section 5: Technical Requirements

Platform-specific specs and requirements.

### Technical Specs by Platform

| Platform | Aspect Ratio | Duration | Sound | Captions |
|----------|-------------|----------|-------|----------|
| **Meta Feed** | 1:1 or 4:5 | 15-60s sweet spot | On by default | Required |
| **Meta Stories/Reels** | 9:16 | 15-30s optimal | On by default | Required |
| **TikTok** | 9:16 | 15-60s (21-34s optimal) | Essential | Strongly recommended |
| **YouTube Shorts** | 9:16 | <60s required | On by default | Recommended |
| **Pinterest** | 2:3 or 9:16 | 6-15s optimal | Often muted | Required |

### Technical Requirements Template

```
TECHNICAL REQUIREMENTS

PLATFORM(S): [Platform list]
ASPECT RATIO: [X:X]
DURATION: [X-X seconds]

FILMING:
- Orientation: [Vertical/Horizontal]
- Lighting: [Natural preferred / Ring light OK / etc.]
- Background: [Specific or guidelines]
- Audio: [Built-in OK / External mic preferred]

DELIVERY:
- Format: [MP4, MOV]
- Resolution: [Minimum 1080p, prefer 4K]
- No watermarks or logos
- Raw footage required: [Yes/No]

VERSIONS NEEDED:
- [ ] Full version ([X]s)
- [ ] Cut-down version ([X]s)
- [ ] Hook variations ([X] options)
- [ ] Aspect ratio variations ([list])
```

---

## Section 6: Do's and Don'ts

Clear guardrails without over-restricting creativity.

### Universal Do's

| Category | Do's |
|----------|------|
| **Authenticity** | Speak naturally, show genuine reactions, be yourself |
| **Energy** | Match energy to platform (TikTok = higher, Meta = varies) |
| **Product** | Show product clearly, demonstrate actual use |
| **Lighting** | Film in good natural light or well-lit space |
| **Audio** | Speak clearly, minimize background noise |
| **Engagement** | Look at camera, maintain eye contact |

### Universal Don'ts

| Category | Don'ts |
|----------|--------|
| **Claims** | No medical claims, no guaranteed results, no competitor bashing |
| **Quality** | No blurry footage, no poor audio, no distracting backgrounds |
| **Compliance** | No copyrighted music, no brand logos visible, no paid actor disclosure issues |
| **Authenticity** | Don't read from script obviously, don't oversell, don't fake enthusiasm |

### Brand-Specific Template

```
DO'S AND DON'TS

DO:
- [Brand-specific do #1]
- [Brand-specific do #2]
- [Brand-specific do #3]

DON'T:
- [Brand-specific don't #1]
- [Brand-specific don't #2]
- [Brand-specific don't #3]

COMPLIANCE NOTES:
- [Required disclosures]
- [Claim restrictions]
- [Platform-specific rules]
```

---

## Section 7: Reference Examples

Show, don't just tell.

### Reference Template

```
REFERENCE EXAMPLES

TOP PERFORMER TO EMULATE:
Link: [URL or attached file]
Why it works: [Specific elements to copy]
- Hook: [What makes it grab attention]
- Body: [What keeps viewers engaged]
- CTA: [What drives action]

ELEMENTS TO BORROW:
- Energy/tone from: [Reference]
- Hook style from: [Reference]
- Product showcase from: [Reference]

WHAT TO AVOID (with examples):
Link: [URL or attached file]
What went wrong: [Specific issues]
```

---

## Complete Brief Template

```
═══════════════════════════════════════════════════════════════
                    UGC CREATOR BRIEF
═══════════════════════════════════════════════════════════════

Brief ID: [UGC-XXX]
Brand: [Brand Name]
Product: [Product Name]
Due Date: [Date]
Creator: [Name if assigned]

───────────────────────────────────────────────────────────────
                    1. CREATIVE OVERVIEW
───────────────────────────────────────────────────────────────

OBJECTIVE:
[One sentence]

THIS BRIEF IS BASED ON:
[Reference to winning creative and its performance]

CREATOR REQUIREMENTS:
• Demographics: [Details]
• Vibe: [Energy/personality]
• Setting: [Where to film]
• Product interaction: [How to use/show]

───────────────────────────────────────────────────────────────
                    2. HOOK (First 3 Seconds)
───────────────────────────────────────────────────────────────

HOOK TYPE: [Type]

OPENING OPTIONS:
A) "[Script option 1]"
B) "[Script option 2]"
C) "[Script option 3]"

VISUAL: [What's on screen]

WHY: [Data backing this hook choice]

───────────────────────────────────────────────────────────────
                    3. CONTENT BODY
───────────────────────────────────────────────────────────────

STRUCTURE: [Type]
DURATION: [X seconds]

KEY MESSAGES:
1. [Message 1]
2. [Message 2]
3. [Message 3]

TALKING POINTS:
• [Point 1]
• [Point 2]
• [Point 3]

PRODUCT MOMENTS:
• [Timestamp]: [What to show]
• [Timestamp]: [What to show]

TONE: [Guidance]

───────────────────────────────────────────────────────────────
                    4. CTA (Final 3-5 Seconds)
───────────────────────────────────────────────────────────────

CTA TYPE: [Type]

VERBAL:
"[Script]"

VISUAL: [What's on screen]

OFFER: [Specific offer to mention]

───────────────────────────────────────────────────────────────
                    5. TECHNICAL REQUIREMENTS
───────────────────────────────────────────────────────────────

PLATFORM(S): [List]
ASPECT RATIO: [X:X]
DURATION: [X-X seconds]
RESOLUTION: [Minimum]
FORMAT: [File type]

VERSIONS NEEDED:
☐ Full version
☐ Cut-down version
☐ Hook variations
☐ Aspect ratios

───────────────────────────────────────────────────────────────
                    6. DO'S AND DON'TS
───────────────────────────────────────────────────────────────

DO:
✓ [Do 1]
✓ [Do 2]
✓ [Do 3]

DON'T:
✗ [Don't 1]
✗ [Don't 2]
✗ [Don't 3]

COMPLIANCE:
• [Required disclosures]
• [Claim restrictions]

───────────────────────────────────────────────────────────────
                    7. REFERENCES
───────────────────────────────────────────────────────────────

TOP PERFORMER TO EMULATE:
[Link/attachment]
Key elements: [What to copy]

AVOID:
[Link/attachment]
Issues: [What went wrong]

═══════════════════════════════════════════════════════════════
```

---

## Output Deliverables

### 1. Complete Brief Document
Full brief using template above

### 2. Quick Reference Card (for creator)
One-page summary with essentials only:
- Hook options
- Key messages
- CTA script
- Technical specs
- Top reference

### 3. Feedback Rubric
Checklist for reviewing submitted content:
- [ ] Hook matches prescribed type
- [ ] All key messages included
- [ ] CTA delivered correctly
- [ ] Technical specs met
- [ ] Brand guidelines followed

---

## Brief Quality Checklist

Before sending brief to creator:

- [ ] Hook prescription tied to performance data
- [ ] Key messages are specific (not generic)
- [ ] CTA matches campaign objective
- [ ] Technical specs correct for platform
- [ ] Reference examples provided
- [ ] Do's and Don'ts are actionable
- [ ] Brief is clear enough for creator to execute independently
- [ ] Brief allows enough creative freedom for authenticity
- [ ] Compliance requirements included
- [ ] Payment terms and timeline clear

---

## Integration with Other Skills

| From Skill | Input to Brief |
|------------|----------------|
| meta-ads-creative-ranker | Winning hooks, formats, patterns |
| creative-fatigue-detector | Elements to refresh vs. keep |
| audience-overlap-mapper | Audience-specific messaging needs |

---

## Limitations

- Cannot guarantee creator execution quality
- Performance data may not transfer to new creator/style
- Brief is only as good as the input analysis
- Cannot control creator authenticity
- Platform algorithms may favor different styles over time
