# How to Use: Marketing Orchestrator

## Quick Start

Describe your marketing challenge or goal, and the Orchestrator will diagnose what you need and recommend the right sequence of skills.

## When to Use This

- You're not sure where to start
- You have a complex marketing challenge
- Multiple skills might apply
- You want to ensure you're doing things in the right order
- You feel overwhelmed by options

## Minimum Input

```
What I'm trying to accomplish: [Your goal]
What I currently have: [Assets, content, etc.]
My biggest constraint: [Time/Budget/Knowledge]
```

## Best Results Input

```
GOAL:
What I want: [Specific outcome]
Timeline: [When do you need results]
Success metric: [How you'll measure it]

CURRENT STATE:
- Brand voice defined: [Yes/No/Partially]
- Target audience clear: [Yes/No/Partially]
- Positioning/USP set: [Yes/No/Partially]
- Existing assets: [List what you have]

CONSTRAINTS:
- Biggest limitation: [Time/Budget/Skills/Content]
- What I've already tried: [Previous attempts]
- What worked/didn't work: [Learnings]

CONTEXT:
- Business type: [B2B/B2C/E-commerce/SaaS/etc.]
- Stage: [New/Growing/Established]
- Team: [Solo/Small team/Agency]
```

## Example Prompts

**Vague request:**
> "I need better marketing."

**Specific challenge:**
> "Our Facebook ads get clicks but no one converts on the landing page."

**Starting from scratch:**
> "We're launching in 6 weeks and have nothing ready."

**Optimization:**
> "We're getting traffic but not enough leads. Help me figure out what to fix."

## Output You'll Get

1. **Diagnosis** (what you actually need vs. what you asked for)
2. **Layer Check** (Foundation → Strategy → Execution → Distribution)
3. **Recommended Sequence** (which skills in what order)
4. **Dependencies** (what each step needs from previous steps)
5. **Quick Win Option** (if you need fast results)
6. **Clarifying Questions** (if needed before proceeding)

## After Diagnosis

Once you get your sequence:

1. Say "Start with [skill name]" to begin the first skill
2. Complete that skill's output
3. Move to the next skill in sequence
4. Return to Orchestrator if you get stuck or change direction

## Tips

- Be honest about current state—the Orchestrator catches anti-patterns
- Foundation problems often masquerade as execution problems
- If you skip to execution without strategy, you'll likely come back
- The "quick win" isn't always the right first step—but it's useful if you need momentum
- Re-diagnose after major milestones or if priorities change
