# How to Use This Skill

Hey Claude—I just added the "meta-ads-performance-analyzer" skill. Can you analyze my Meta Ads performance and tell me what's working?

## Example Invocations

**Example 1: Full Performance Analysis**
Hey Claude—I just added the "meta-ads-performance-analyzer" skill. Here's my Meta Ads data from the last 30 days. Tell me what's working, what's broken, and what I should do.

**Example 2: Diagnose Performance Drop**
Hey Claude—I just added the "meta-ads-performance-analyzer" skill. My CPA jumped from $25 to $45 in the last 2 weeks. Help me figure out why and how to fix it.

**Example 3: Creative Analysis**
Hey Claude—I just added the "meta-ads-performance-analyzer" skill. I want to understand which of my creatives are winning and which are fatigued. Here's my ad-level performance data.

**Example 4: Audience Optimization**
Hey Claude—I just added the "meta-ads-performance-analyzer" skill. I'm running 8 different audiences and want to know which ones to scale and which to cut.

**Example 5: Compare Periods**
Hey Claude—I just added the "meta-ads-performance-analyzer" skill. Compare my November vs December performance and explain the differences.

## What to Provide

**Required:**
- Campaign names and objectives
- Spend by campaign (or ad set)
- Results (conversions, leads, purchases)
- Cost per result (CPA/CPL)
- Time period being analyzed

**Recommended:**
- Ad-level performance (creative breakdown)
- Audience/ad set breakdown
- Placement breakdown
- Funnel metrics (CPM, CTR, CPC, conversion rate)
- Frequency data

**Optional:**
- Week-over-week or month-over-month comparison
- Creative thumbnails or descriptions
- Audience sizes and overlap data
- Attribution window being used
- Industry/vertical context

## What You'll Get

1. **Health Dashboard** - Traffic light status on all key metrics
2. **Campaign Tiering** - Winners, performers, borderline, losers
3. **Creative Analysis** - Top/bottom performers, fatigue detection
4. **Audience Analysis** - What's working, overlap issues
5. **Placement Breakdown** - Where your money is going
6. **Root Cause Diagnosis** - Why performance is what it is
7. **Prioritized Actions** - What to do immediately, this week, this month

## Pro Tips

- Export data from Ads Manager → Reports → Create Custom Report
- Include at least 7 days of data (14-30 is better for trends)
- Don't panic about daily fluctuations—look at 7-day trends
- Compare apples to apples: same attribution window, same time period
- Creative performance data is the most valuable—always include it if possible
