# How to Use This Skill

Hey Claude—I just added the "attribution-model-auditor" skill. Can you help me understand why my conversion numbers don't match across platforms?

## Example Invocations

**Example 1: Full Attribution Audit**
Hey Claude—I just added the "attribution-model-auditor" skill. Here's my tracking setup across Google, Meta, and TikTok plus my CRM data. Audit my attribution and tell me what's broken.

**Example 2: Platform Discrepancy**
Hey Claude—I just added the "attribution-model-auditor" skill. Google shows 200 conversions, Meta shows 180, but my CRM only has 250 total. Why is this happening?

**Example 3: Attribution Window Review**
Hey Claude—I just added the "attribution-model-auditor" skill. I'm not sure if my attribution windows are set correctly. Here's what I have—should I change them?

**Example 4: iOS 14 Impact Assessment**
Hey Claude—I just added the "attribution-model-auditor" skill. I think I'm missing conversions on Meta since iOS 14. How do I know and what should I do?

**Example 5: Model Selection**
Hey Claude—I just added the "attribution-model-auditor" skill. I'm using last-click attribution but not sure if that's right for my business. Here's my setup—what model should I use?

## What to Provide

**Required:**
- Platforms you're running ads on
- Attribution windows currently set
- Conversion tracking method (pixel, CAPI, etc.)
- Reported conversions by platform
- Actual conversions from CRM/backend

**Highly Recommended:**
- Technical setup details (CAPI status, Enhanced Conversions, etc.)
- Sales cycle length
- Business model (e-commerce, lead gen, SaaS)
- GA4 setup status

**Optional:**
- Historical tracking changes
- iOS impact observations
- Multi-touch path data
- Any known discrepancies

## What You'll Get

1. **Technical Setup Audit** - Is your tracking properly implemented?
2. **Window Analysis** - Are your attribution windows appropriate?
3. **Cross-Platform Comparison** - How much are platforms double-counting?
4. **Data Loss Assessment** - How much signal are you losing (iOS, etc.)?
5. **Model Recommendation** - Which attribution model fits your business?
6. **Discrepancy Explanation** - Why numbers don't match and what to do
7. **Action Plan** - Prioritized fixes

## Pro Tips

- Export same-period data from all platforms for fair comparison
- Your CRM is the source of truth, not platform data
- Platforms over-report because they want credit—that's normal
- CAPI/server-side tracking is essential post-iOS 14
- Standardize windows across platforms for comparison
- Perfect attribution doesn't exist—aim for consistent, not perfect
