---
name: usp-extractor
description: Extracts and crafts unique selling propositions from product/service information. Triggers when user asks "what makes us different?", "how do I position against competitors?", or wants to define their USP. Analyzes features, benefits, audience, and competitive landscape to generate differentiated value propositions and messaging angles.
---

# USP Extractor

Find your competitive edge and articulate it compellingly.

## Core Philosophy

**Different is better than better.** You don't need to be objectively "best"—you need to be uniquely valuable to a specific audience in a specific way.

**The Goal:** Extract the one thing you can claim that matters to customers and competitors can't easily copy.

**The Principle:** Great USPs sit at the intersection of what you do well, what customers care about, and what competitors don't offer.

---

## Required Context

### Must Have

**1. Your Product/Service**
- What you sell/offer
- Key features and capabilities
- How it works (high-level)

**2. Your Customers**
- Who you serve
- Their primary problem/need
- Why they choose you (if known)

### Strongly Recommended

**3. Competitive Context**
- Main competitors (names or descriptions)
- What competitors claim/emphasize
- Where you differ from them

**4. Business Reality**
- Your actual strengths (be honest)
- Your weaknesses (important to know)
- What you can credibly claim

### Nice to Have

- Customer testimonials/reviews
- Win/loss reasons from sales
- Competitor reviews (especially negative ones)
- Industry trends affecting positioning
- Company origin story or founder background

---

## USP Extraction Framework

### The USP Intersection Model

```
                    WHAT YOU DO WELL
                          │
                          │
            ┌─────────────┼─────────────┐
            │             │             │
            │      ★ USP SWEET SPOT ★   │
            │             │             │
    ────────┼─────────────┼─────────────┼────────
    WHAT    │             │             │    WHAT
    CUSTOMERS│            │             │    COMPETITORS
    CARE    │             │             │    DON'T OFFER
    ABOUT   │             │             │
            │             │             │
            └─────────────┼─────────────┘
                          │
```

**All three must be present:**
1. **You do it well** — Credible, sustainable capability
2. **Customers care** — Solves real problem or desire
3. **Competitors don't offer** — Or don't emphasize it

---

### Step 1: Capability Inventory

**Feature-Benefit-Proof Matrix:**

| Feature | Benefit | Who Cares | Proof |
|---------|---------|-----------|-------|
| [Feature 1] | [What it enables] | [Which segment] | [Evidence] |
| [Feature 2] | [What it enables] | [Which segment] | [Evidence] |
| [Feature 3] | [What it enables] | [Which segment] | [Evidence] |

**Capability Categories:**

| Category | Your Capabilities |
|----------|-------------------|
| Product/Technical | [List] |
| Service/Support | [List] |
| Expertise/Knowledge | [List] |
| Process/Methodology | [List] |
| Speed/Efficiency | [List] |
| Price/Value | [List] |
| Experience/UX | [List] |
| Trust/Credibility | [List] |

**Unique Asset Identification:**

| Asset Type | What You Have | Replicable? |
|------------|---------------|-------------|
| Proprietary technology | [Description] | Y/N |
| Unique data | [Description] | Y/N |
| Special expertise | [Description] | Y/N |
| Exclusive partnerships | [Description] | Y/N |
| Process innovation | [Description] | Y/N |
| Brand/reputation | [Description] | Y/N |
| Customer base network | [Description] | Y/N |

---

### Step 2: Customer Value Mapping

**Jobs-to-be-Done Analysis:**

| Job Type | Customer Job | Importance |
|----------|--------------|------------|
| Functional | [What they need to accomplish] | High/Med/Low |
| Emotional | [How they want to feel] | High/Med/Low |
| Social | [How they want to be perceived] | High/Med/Low |

**Pain Point Inventory:**

| Pain | Severity | Frequency | Current Solutions |
|------|----------|-----------|-------------------|
| [Pain 1] | High/Med/Low | Daily/Weekly/Monthly | [How addressed now] |
| [Pain 2] | High/Med/Low | Daily/Weekly/Monthly | [How addressed now] |
| [Pain 3] | High/Med/Low | Daily/Weekly/Monthly | [How addressed now] |

**Desired Outcome Ranking:**

| Outcome | Priority | Your Ability to Deliver |
|---------|----------|-------------------------|
| [Outcome 1] | 1 | Strong/Moderate/Weak |
| [Outcome 2] | 2 | Strong/Moderate/Weak |
| [Outcome 3] | 3 | Strong/Moderate/Weak |

---

### Step 3: Competitive Differentiation Analysis

**Competitor Positioning Map:**

| Competitor | Their USP/Claim | Their Weakness |
|------------|-----------------|----------------|
| [Competitor 1] | [What they emphasize] | [Where they're weak] |
| [Competitor 2] | [What they emphasize] | [Where they're weak] |
| [Competitor 3] | [What they emphasize] | [Where they're weak] |

**Competitive Claims Analysis:**

| Claim | Who Makes It | Credible? | You Too? |
|-------|--------------|-----------|----------|
| "Fastest" | [Who] | Y/N | Y/N |
| "Easiest" | [Who] | Y/N | Y/N |
| "Cheapest" | [Who] | Y/N | Y/N |
| "Most powerful" | [Who] | Y/N | Y/N |
| "Best support" | [Who] | Y/N | Y/N |

**White Space Identification:**

| Potential Angle | Claimed By | Available? |
|-----------------|------------|------------|
| [Angle 1] | Nobody/Weakly claimed | Y/N |
| [Angle 2] | Nobody/Weakly claimed | Y/N |
| [Angle 3] | Nobody/Weakly claimed | Y/N |

---

### Step 4: USP Synthesis

**USP Candidates:**

Generate 3-5 potential USPs based on analysis:

| USP Candidate | Capability | Customer Value | Competitive Gap |
|---------------|------------|----------------|-----------------|
| [USP 1] | [Your strength] | [Why care] | [Why unique] |
| [USP 2] | [Your strength] | [Why care] | [Why unique] |
| [USP 3] | [Your strength] | [Why care] | [Why unique] |

**USP Evaluation Criteria:**

| Criterion | USP 1 | USP 2 | USP 3 |
|-----------|-------|-------|-------|
| Credible (can you prove it?) | 1-5 | 1-5 | 1-5 |
| Relevant (do customers care?) | 1-5 | 1-5 | 1-5 |
| Unique (competitors can't claim?) | 1-5 | 1-5 | 1-5 |
| Sustainable (hard to copy?) | 1-5 | 1-5 | 1-5 |
| Memorable (easy to understand?) | 1-5 | 1-5 | 1-5 |
| **TOTAL** | /25 | /25 | /25 |

---

### Step 5: USP Articulation

**USP Statement Formulas:**

**Formula 1: Only Statement**
```
[Product] is the only [category] that [unique capability/benefit].
```

**Formula 2: For-Who-That Statement**
```
For [target audience] who [need/want], [product] is the [category] that [key benefit] because [reason to believe].
```

**Formula 3: Unlike Statement**
```
Unlike [alternative/competitor], [product] [unique difference] so you can [outcome].
```

**Formula 4: What-How-Why Statement**
```
We help [audience] [achieve outcome] by [unique method] so they can [ultimate benefit].
```

---

## Output Format

### Executive Summary

```
USP CLARITY SCORE: XX/100

Your Product: [Name]
Category: [Category]
Target Audience: [Who]

RECOMMENDED USP:
"[Primary USP statement]"

DIFFERENTIATION TYPE: [Only/Best/First/Specialist/etc.]
CONFIDENCE: High/Medium/Low
```

---

### USP Analysis Results

**The Intersection Analysis:**

```
WHAT YOU DO WELL:
✓ [Strength 1]
✓ [Strength 2]
✓ [Strength 3]

WHAT CUSTOMERS CARE ABOUT:
★ [Priority 1]
★ [Priority 2]
★ [Priority 3]

WHAT COMPETITORS DON'T OFFER/EMPHASIZE:
○ [Gap 1]
○ [Gap 2]
○ [Gap 3]

USP SWEET SPOT:
→ [Where these three intersect]
```

---

### Primary USP Recommendation

**USP Statement:**
> "[The recommended USP in quotable form]"

**Why This USP:**
- **Capability:** [What makes this credible]
- **Relevance:** [Why customers care]
- **Uniqueness:** [Why competitors can't claim this]
- **Proof:** [Evidence you can point to]

**Supporting Proof Points:**
1. [Proof point 1]
2. [Proof point 2]
3. [Proof point 3]

---

### Alternative USP Options

**Option 2: [USP Name]**
> "[USP statement]"

- Best for: [When/who to use this with]
- Trade-off: [What you sacrifice vs. primary]
- Score: XX/25

---

**Option 3: [USP Name]**
> "[USP statement]"

- Best for: [When/who to use this with]
- Trade-off: [What you sacrifice vs. primary]
- Score: XX/25

---

### Messaging Applications

**Headline Variations:**

| Context | Headline |
|---------|----------|
| Homepage | "[Headline]" |
| Google Ad | "[Headline]" |
| LinkedIn Ad | "[Headline]" |
| Cold Email | "[Headline]" |
| Sales Deck | "[Headline]" |

**Tagline Options:**
1. "[Tagline 1]"
2. "[Tagline 2]"
3. "[Tagline 3]"

**Elevator Pitch:**
> "[30-second pitch incorporating USP]"

---

### Competitive Positioning Statement

**Against [Competitor 1]:**
> "Unlike [Competitor], we [key difference]. This means you get [benefit they can't deliver]."

**Against [Competitor 2]:**
> "Unlike [Competitor], we [key difference]. This means you get [benefit they can't deliver]."

**Generic Alternative Positioning:**
> "Unlike [generic alternative], we [key difference]. This means you get [benefit they can't deliver]."

---

### USP Validation Checklist

Before committing to this USP:

- [ ] Can you prove this claim? (testimonials, data, demos)
- [ ] Would customers agree this matters to them?
- [ ] Would competitors struggle to make this claim?
- [ ] Can you sustain this advantage for 2+ years?
- [ ] Does your team believe this is true?
- [ ] Is it simple enough to remember?
- [ ] Does it translate across all marketing?

---

### What You Should NOT Claim

**Avoid These (Not Differentiated):**
| Claim | Why Not |
|-------|---------|
| [Claim 1] | [Everyone claims this / Not provable] |
| [Claim 2] | [Everyone claims this / Not provable] |

**These Are Table Stakes (Not USPs):**
- [Feature/benefit everyone has]
- [Feature/benefit everyone has]

---

## USP Type Reference

### Types of USPs

| Type | Description | Example |
|------|-------------|---------|
| **Only** | You're the only one who does X | "Only CRM with built-in video" |
| **First** | You invented or pioneered X | "The original project management tool" |
| **Best** | You do X better than anyone | "Highest customer satisfaction in industry" |
| **Fastest** | You do X quicker | "Results in 24 hours, not weeks" |
| **Easiest** | Lowest friction/learning curve | "Set up in 5 minutes" |
| **Specialist** | You focus exclusively on Y | "Built exclusively for accountants" |
| **Integrated** | You combine X and Y uniquely | "Marketing + Sales in one platform" |
| **Methodology** | You have a unique approach | "The only 5-step system for X" |
| **Guarantee** | You promise something competitors won't | "Double your results or money back" |
| **Relationship** | You deliver superior experience | "Personal account manager for every client" |

---

## Limitations

**I can help with:**
- Synthesizing inputs into USP candidates
- Evaluating USP strength and uniqueness
- Articulating USPs in multiple formats
- Competitive positioning statements
- Messaging applications

**I cannot provide:**
- Customer research (need real interviews/surveys)
- Competitive intelligence (need market research)
- Validation that customers actually care
- Proof points (you must have these)
- Guarantee the USP will work

**For complete USP development, also conduct:**
- Customer interviews (why did you buy?)
- Win/loss analysis (why did we win/lose?)
- Competitor customer reviews (what do they complain about?)
- Sales team input (what objections do you hear?)
- Market research (what's trending?)

---

## Quality Checklist

Before delivering USP:
- [ ] Three circles (capability, customer value, competitive gap) all addressed
- [ ] Multiple USP options provided
- [ ] Primary USP clearly recommended with rationale
- [ ] Proof points identified
- [ ] Messaging applications provided
- [ ] Competitive positioning included
- [ ] Validation checklist provided
- [ ] What NOT to claim is clear
- [ ] Limitations acknowledged
