# How to Use This Skill

Hey Claude—I just added the "usp-extractor" skill. Can you help me figure out what makes my product unique and how to communicate it?

## Example Invocations

**Example 1: Full USP Development**
Hey Claude—I just added the "usp-extractor" skill. I sell project management software for marketing teams. My main competitors are Asana and Monday. I need a clear USP—what makes us different?

**Example 2: Competitive Differentiation**
Hey Claude—I just added the "usp-extractor" skill. I know my product is better than [Competitor] but I can't articulate why. Here's what we do [description] and here's what they do [description]. Help me find my angle.

**Example 3: Feature-to-USP Translation**
Hey Claude—I just added the "usp-extractor" skill. Here are my product's features [list]. Which ones could become a compelling USP? How do I turn features into benefits that differentiate us?

**Example 4: Messaging Refresh**
Hey Claude—I just added the "usp-extractor" skill. Our current tagline is "[tagline]" but it feels generic. Here's what we do [description] and who we serve [audience]. Give me better positioning.

**Example 5: Niche Positioning**
Hey Claude—I just added the "usp-extractor" skill. I'm a generalist [service provider] but I want to niche down. Here are the types of clients I've had success with [list]. What niche USP could I own?

**Example 6: Against Big Competitors**
Hey Claude—I just added the "usp-extractor" skill. I'm competing against [big company]. What USP angles could a smaller player like me use that they can't credibly claim?

## What to Provide

**Required:**
- What you sell/offer
- Who your customers are
- Who your main competitors are (or the alternatives customers consider)

**Strongly Recommended:**
- Your key features/capabilities
- Why customers have chosen you (if you know)
- What competitors emphasize/claim
- Your honest strengths and weaknesses

**Optional:**
- Customer testimonials or reviews
- Win/loss reasons from sales
- Competitor reviews (especially complaints)
- Industry context

## What You'll Get

1. **USP Sweet Spot Analysis** - Where capability, customer value, and competitive gap intersect
2. **Primary USP Recommendation** - The strongest positioning with rationale
3. **Alternative USPs** - Backup options for different contexts
4. **Proof Points** - What evidence supports your USP
5. **Messaging Applications** - Headlines, taglines, and elevator pitch
6. **Competitive Positioning** - How to position against specific competitors
7. **Validation Checklist** - How to test if your USP works

## Pro Tips

- Be honest about weaknesses—I can't help if I don't know the full picture
- Share actual customer quotes if you have them—gold for USP development
- Tell me what competitors claim on their websites—I'll find your counterposition
- If you've lost deals, tell me why—that reveals what matters to customers
- Don't just list features—tell me what outcomes they enable
- Share your origin story—sometimes the "why" becomes the USP
