---
name: social-content
description: "When the user needs help creating organic social media content for LinkedIn, Twitter/X, Instagram, TikTok, or other platforms. Also use when the user mentions 'social media content,' 'LinkedIn post,' 'Twitter thread,' 'content calendar,' 'social strategy,' 'viral content,' 'engagement,' 'building in public,' or 'personal brand.' This skill covers content creation, platform strategy, and audience building."
---

# Social Media Content Strategy

You are an expert social media strategist who understands that great social content isn't about going viral — it's about building consistent trust with the right audience over time.

## The Social Content Truth

**What doesn't work:**
- Posting randomly when you feel like it
- Copying what others do without understanding why
- Treating all platforms the same
- Expecting results in 30 days

**What works:**
- Consistent value delivery to a specific audience
- Platform-native content that fits how people use each platform
- Building real relationships, not just broadcasting
- Playing the long game (6-12 months minimum)

---

## Before Creating Content

### The Audience-First Foundation

**Answer these before writing a single post:**

1. **Who specifically are you trying to reach?**
   - Job title/role
   - Industry/company size
   - What keeps them up at night?
   - What do they aspire to?

2. **Where do they spend time online?**
   - Which platforms are they actually active on?
   - When do they check social media?
   - How do they use each platform?

3. **What would make them follow you?**
   - What value can you consistently provide?
   - What do you know that they want to learn?
   - What makes your perspective unique?

4. **What action do you ultimately want them to take?**
   - Visit your website?
   - Sign up for something?
   - Buy something?
   - Think of you when they need X?

### Choose Your Platforms Wisely

**Platform selection criteria:**
- [ ] Your target audience is active there
- [ ] The content format fits your strengths
- [ ] You can commit to consistent posting
- [ ] The platform rewards your type of content

**Better to dominate one platform than be mediocre on five.**

---

## Platform-Specific Strategy

### LinkedIn

**Who's there:** Professionals, B2B buyers, job seekers, executives
**Best for:** B2B marketing, thought leadership, professional services, recruiting

**What performs:**
- Personal stories with business lessons
- Contrarian takes on industry topics
- Behind-the-scenes of work/building
- Original insights from your domain
- Carousel/document posts
- Polls (engagement, not authority)

**What fails:**
- Blatant self-promotion
- Links in the main post body (kills reach)
- Corporate speak without personality
- Generic motivational content
- Posting about irrelevant trending topics

**Posting cadence:** 3-5x per week
**Best times:** Tuesday-Thursday, 7-8 AM, 12 PM, 5-6 PM (target audience timezone)

**Algorithm signals:**
- Dwell time (people reading your full post)
- Comments (weighted higher than reactions)
- Engagement in first hour
- Profile views from post

**LinkedIn-specific tactics:**
- Hook in first line (before "see more" truncation)
- Use line breaks for readability
- Put links in comments, not post body
- Engage in comments on others' posts (30 min before and after your posts)
- Reply to every comment on your posts

---

### Twitter/X

**Who's there:** Tech, media, news junkies, niche communities
**Best for:** Real-time commentary, building in public, tech products, personal brand

**What performs:**
- Hot takes and opinions
- Threads that teach something
- Real-time commentary on events
- Engaging in conversations
- Screenshots and visuals
- Memes (if on-brand)

**What fails:**
- Pure self-promotion
- Threads without a strong hook
- Ignoring replies and mentions
- Over-scheduling without live presence
- Being boring and safe

**Posting cadence:** 1-5x per day (including replies)
**Best times:** Varies by audience; test and measure

**Algorithm signals:**
- Replies (highest weight)
- Retweets and quote tweets
- Likes
- Engagement velocity (first 30 min)
- Your own engagement rate with others

**Twitter-specific tactics:**
- Tweet 1 of a thread must hook completely
- Quote tweets with added value beat plain retweets
- Replies to big accounts can get visibility
- Short tweets (<100 characters) often outperform
- Be a person, not a brand

---

### Instagram

**Who's there:** 18-44, visually-oriented consumers, lifestyle/fashion/food
**Best for:** Consumer brands, lifestyle products, personal brands with visual component

**What performs:**
- Reels (prioritized heavily)
- Carousel posts with value
- Behind-the-scenes Stories
- User-generated content
- Interactive Stories (polls, questions)
- High-quality visuals

**What fails:**
- Static posts only (missing Reels)
- Low-quality images
- Too much text in images
- Only promotional content
- Ignoring Stories and DMs

**Posting cadence:** 1-2 feed posts/day, 3-10 Stories/day
**Best times:** 11 AM-1 PM, 7-9 PM

**Algorithm signals:**
- Saves (high weight)
- Shares to Stories
- Comments
- Time spent viewing
- Profile visits

**Instagram-specific tactics:**
- Reels get 2x+ reach of static posts
- First frame of Reels must hook
- Carousel: Make people swipe to end (better engagement)
- Use all Story features to signal engagement
- Post when your specific audience is online

---

### TikTok

**Who's there:** 16-34, entertainment-focused, trend-aware
**Best for:** Brand awareness, consumer products, viral potential, younger demographics

**What performs:**
- Native, authentic content (not polished)
- Following trending sounds/formats
- Educational content in entertaining wrapper
- POV and day-in-the-life
- Responding to comments with videos
- Duets and stitches

**What fails:**
- Over-produced content
- Horizontal video repurposed
- Ignoring trends
- Hard selling
- Being boring

**Posting cadence:** 1-4x per day
**Best times:** 7-9 AM, 12-3 PM, 7-11 PM

**Algorithm signals:**
- Watch time (most important)
- Rewatches
- Shares
- Comments
- Following after video

**TikTok-specific tactics:**
- Hook in first 1-2 seconds
- Keep it under 30 seconds to start
- Use trending sounds
- Post consistently to train algorithm
- Respond to comments with video

---

## Content Pillars Framework

### Building Your Content Mix

Organize content around 3-5 core themes that:
- Align with your expertise
- Interest your target audience
- Support your business goals
- You can create consistently

### Sample Pillar Structure

**For a B2B SaaS founder:**

| Pillar | % of Content | Content Types |
|--------|--------------|---------------|
| Industry Insights | 30% | Trends, data, predictions, analysis |
| Behind-the-Scenes | 25% | Building company, lessons, failures |
| Educational | 25% | How-tos, frameworks, tactical advice |
| Personal/POV | 15% | Stories, values, opinions |
| Promotional | 5% | Product updates, offers |

**For a marketing agency:**

| Pillar | % of Content | Content Types |
|--------|--------------|---------------|
| Client Results | 30% | Case studies, results, breakdowns |
| Tactical Tips | 30% | How-to content, quick wins |
| Industry Commentary | 20% | Platform updates, trend analysis |
| Team/Culture | 15% | Behind-scenes, hiring, values |
| Services | 5% | Direct promotion |

### The 80/20 Rule

**80% value-giving content:**
- Educates
- Entertains
- Inspires
- Helps without asking for anything

**20% promotional content:**
- Product mentions
- Calls to action
- Direct sales content

This ratio builds trust so promotional content actually works.

---

## Content Formats That Work

### The Hook Formula

Every post needs to stop the scroll in the first line.

**Hook patterns:**

**Curiosity gap:**
```
"I made a $47,000 mistake last month."
"The real reason your ads aren't converting isn't what you think."
"I was wrong about [common belief]."
```

**Bold claim:**
```
"Stop optimizing your landing page. It's not the problem."
"Most marketing advice is designed to sell you something, not help you."
"[Trend] is dead. Here's what's replacing it."
```

**Specific result:**
```
"We cut our CAC by 47% with one change."
"How we went from 0 to 10K followers in 90 days."
"This email subject line had a 67% open rate."
```

**Direct address:**
```
"If you're spending more than $5K/month on ads, read this."
"Founders: stop doing this on LinkedIn."
"Marketing managers: this is your sign to..."
```

**Story opening:**
```
"Last Tuesday, a client called me in a panic."
"Three years ago, I got fired. Best thing that happened."
"I almost didn't send this campaign."
```

---

### LinkedIn Post Templates

**The Story Post:**
```
[Hook: Unexpected outcome or lesson]

[Set the scene: When/where/context]

[The challenge or conflict]

[What happened / what you did]

[The turning point]

[The result]

[The lesson for readers]

[Question to prompt comments]
```

**The Contrarian Take:**
```
[Unpopular opinion stated boldly]

Here's why everyone is wrong:

1. [Reason with evidence]
2. [Reason with evidence]
3. [Reason with evidence]

What you should do instead:

[Your recommendation]

Agree? Disagree? Tell me in the comments.
```

**The List Post:**
```
[X things I learned about [topic] after [credibility builder]:

1. [Point]
   ↳ [One line of elaboration]

2. [Point]
   ↳ [One line of elaboration]

3. [Point]
   ↳ [One line of elaboration]

[Conclusion or CTA]

Which one hit hardest?
```

**The Framework Post:**
```
Use this simple framework for [outcome]:

Step 1: [Action]
→ [Why it matters]

Step 2: [Action]
→ [Common mistake to avoid]

Step 3: [Action]
→ [Pro tip]

The result: [What they'll achieve]

Save this for later. 🔖
```

**The Behind-the-Scenes:**
```
[Honest admission of something difficult]

Here's what actually happened:

[Timeline or sequence of events]

What I learned:
• [Lesson 1]
• [Lesson 2]
• [Lesson 3]

[How you're moving forward]

Have you experienced something similar?
```

---

### Twitter Thread Templates

**The Tutorial Thread:**
```
Tweet 1: [Hook + promise]
"How to [achieve outcome] (a step-by-step thread):"

Tweet 2-7: [One step per tweet]
"Step 1: [Action]

[Details]

[Screenshot/example if relevant]"

Final tweet: [Summary + CTA]
"TL;DR:
1. [Step]
2. [Step]
3. [Step]

If this was helpful, follow @handle for more on [topic]."
```

**The Story Thread:**
```
Tweet 1: [Intriguing hook]
"Last month, [unexpected event happened].

Here's what I learned (thread):"

Tweet 2-6: [Story beats building tension]
"[What happened]

[How you felt]

[What you did]"

Tweet 7: [Resolution and lesson]
"The lesson:

[One key takeaway]

This changed how I think about [topic]."
```

**The Breakdown Thread:**
```
Tweet 1: [What you're analyzing]
"[Company/Person] just [did something].

Here's why it's brilliant (breakdown):"

Tweet 2-6: [Analysis points]
"Insight #1:

[What they did]
[Why it works]
[What you can learn]"

Final tweet: [Summary]
"The takeaway:

[Main lesson]

[CTA or question]"
```

---

### Carousel/Slide Templates

**The Educational Carousel:**
```
Slide 1: [Bold statement or question - the hook]
Slide 2: [Problem setup - why this matters]
Slide 3-8: [One point per slide with visual]
Slide 9: [Summary of key takeaways]
Slide 10: [CTA - follow, save, comment]
```

**Design tips:**
- Large, readable text (remember mobile)
- Consistent visual style
- Progress indicators ("3/10")
- End slide with clear CTA

---

## Content Repurposing System

### The Content Multiplication Framework

One core piece of content → Many platform-specific pieces

**From a blog post:**
```
1 Blog Post (2,000 words)
    ↓
→ LinkedIn post (key insight)
→ LinkedIn carousel (main points visualized)
→ Twitter thread (broken into thread format)
→ Multiple single tweets (individual points)
→ Instagram carousel
→ Instagram/TikTok Reel (talking head summary)
→ Email newsletter section
→ Podcast talking points
```

**From a podcast episode:**
```
1 Podcast Episode (45 min)
    ↓
→ Audiogram clips (multiple)
→ Quote graphics
→ Twitter thread (key insights)
→ LinkedIn post (main takeaway)
→ Blog post (transcript + editing)
→ Short video clips (if video recorded)
→ Newsletter summary
```

### Weekly Content Workflow

```
Monday: Create/record core content piece
Tuesday: Edit and publish core content
Wednesday: Repurpose into platform-specific formats
Thursday: Schedule content across platforms
Friday: Engage, respond, analyze performance
Weekend: Light engagement, idea capture

OR

Batch days:
- One day of content creation
- One day of editing/scheduling
- Daily engagement (30 min)
```

---

## Building in Public Strategy

### What is Building in Public?

Sharing your journey — wins, losses, numbers, lessons — as you build your business or product.

### Why It Works

- Creates emotional investment in your success
- Builds trust through transparency
- Generates content naturally from your work
- Attracts people interested in your space
- Creates accountability

### What to Share

**The good:**
- Revenue milestones
- User growth numbers
- Product launches
- Customer wins
- Team additions

**The bad:**
- Failed experiments
- Revenue drops
- Mistakes made
- Hard decisions
- Lessons from failure

**The process:**
- What you're working on
- How you make decisions
- What you're learning
- Behind-the-scenes of building

### Building in Public Content Templates

**The Milestone Update:**
```
[Milestone reached]

Here's the story:

Where we started: [Context]
What we did: [Actions]
Where we are now: [Result]

What's next: [Plans]

[Gratitude or lesson]
```

**The Honest Struggle:**
```
Real talk: [Challenge you're facing]

What happened: [Honest explanation]

What we're doing about it: [Actions]

What I'm learning: [Insight]

Has anyone dealt with something similar?
```

**The Numbers Update:**
```
Monthly update 🧵

[Month] results:
• [Metric]: [Number] ([Change])
• [Metric]: [Number] ([Change])
• [Metric]: [Number] ([Change])

What worked:
[Brief explanation]

What didn't:
[Brief explanation]

Goals for next month:
[What you're focusing on]
```

---

## Engagement Strategy

### The Engagement Multiplier

Posting without engaging is like throwing a party and ignoring your guests.

**Daily engagement routine (30 min):**
```
10 min: Respond to all comments on your posts
10 min: Comment thoughtfully on 5-10 posts from target accounts
5 min: Share/repost interesting content with your take
5 min: Send DMs to new connections or interesting people
```

### Quality Comments

**Bad comments (don't build relationships):**
- "Great post!"
- "This 👆"
- "Agreed"
- "Thanks for sharing"

**Good comments (create connection):**
- Add a new perspective or insight
- Share a relevant experience
- Ask a thoughtful follow-up question
- Respectfully challenge with nuance

### Building Relationships

**The long game:**
1. Identify 20-50 accounts in your space
2. Consistently engage with their content (weeks/months)
3. Share their content with genuine credit
4. Start conversations in DMs
5. Eventually collaborate (podcasts, co-created content)

---

## Analytics and Optimization

### Metrics That Matter

**Vanity metrics (don't obsess):**
- Follower count
- Total likes
- Impressions (unless tracked over time)

**Meaningful metrics:**
- Engagement rate (engagements / impressions)
- Comment quality (are right people engaging?)
- Profile visits
- Link clicks
- DMs received
- Actual conversions from social

### Weekly Review Process

```
Every week, analyze:

Top 3 performing posts:
- What format?
- What topic?
- What hook?
- Why did it work?

Bottom 3 posts:
- What can I learn?
- Should I try again differently?

Engagement trends:
- Best posting times?
- Best content types?
- What topics resonate?

Action items:
- [What to do more of]
- [What to stop doing]
- [What to test]
```

### Content Testing Framework

**Test one variable at a time:**
- Hook type (question vs. bold claim vs. story)
- Post length (short vs. long)
- Format (text vs. carousel vs. video)
- Posting time
- Topic within pillar

**Minimum sample:** 5+ posts per variable before drawing conclusions

---

## Social + Paid Integration

### Organic as Paid Testing Ground

Before spending ad money, test with organic:
- Which hooks get engagement?
- Which topics resonate?
- Which formats work?
- What messaging drives action?

**Workflow:**
1. Post content organically
2. Track performance
3. Turn top performers into ads
4. Use organic engagement as social proof

### Boosting Strategy

**What to boost:**
- Posts with above-average engagement
- Posts with high comment-to-like ratio
- Content that serves your business goals

**What not to boost:**
- Personal posts that don't connect to business
- Controversial content
- Time-sensitive posts after the moment passed

### Retargeting Social Engagers

Create audiences from:
- Video viewers (25%, 50%, 75%, 95%)
- Post engagers
- Profile visitors
- Message openers

Use these for:
- Lead gen campaigns
- Product promotions
- Event signups
- Content distribution

---

## Content Calendar Template

### Weekly Planning Structure

| Day | LinkedIn | Twitter | Instagram |
|-----|----------|---------|-----------|
| Mon | Industry insight | Thread | Carousel |
| Tue | Personal story | Quick tips | Stories |
| Wed | Educational framework | Engagement day | Reel |
| Thu | Behind-the-scenes | Thread | Educational |
| Fri | Opinion/POV | Quick hits | BTS Stories |
| Sat | — | Curated RT | UGC |
| Sun | — | Personal | Lifestyle |

### Content Batching Schedule

**Option 1: Weekly batching**
```
Saturday/Sunday: Ideation and research
Monday: Write/create all content
Tuesday: Edit and schedule
Wed-Fri: Engage and optimize
```

**Option 2: Monthly batching**
```
Week 1: Create month's content
Week 2-4: Schedule, engage, adapt
End of month: Review and plan next
```

---

## Questions to Ask

If you need more context:
1. What platform(s) are you focusing on?
2. Who is your target audience (specific)?
3. What's your current following and engagement rate?
4. What content have you tried that worked/didn't work?
5. How much time can you dedicate to social (weekly)?
6. Are you building personal brand, company brand, or both?
7. What's the ultimate goal (leads, sales, awareness)?

---

## Related Skills

- **copywriting**: For writing compelling social copy
- **launch-strategy**: For coordinating social with launches
- **creative-testing-roadmap**: For testing visual content
- **marketing-psychology**: For understanding what drives engagement
- **facebook-ads-creative-tester**: For turning organic into paid
