# How to Use This Skill

Hey Claude—I just added the "retargeting-sequence-designer" skill. Can you design a retargeting sequence that brings back visitors who didn't convert?

## Example Invocations

**Example 1: E-commerce Full Sequence**
Hey Claude—I just added the "retargeting-sequence-designer" skill. I run an e-commerce store selling [products]. I want to retarget cart abandoners, product viewers, and general visitors. Design me a full retargeting sequence.

**Example 2: Cart Abandonment Focus**
Hey Claude—I just added the "retargeting-sequence-designer" skill. My cart abandonment rate is 75%. I want an aggressive but not annoying retargeting sequence specifically for cart abandoners. What should the messaging and timing look like?

**Example 3: SaaS Retargeting**
Hey Claude—I just added the "retargeting-sequence-designer" skill. I have a SaaS product with a free trial. I want to retarget people who visited the pricing page but didn't sign up, and people who started the trial but didn't activate. Design sequences for both.

**Example 4: Lead Gen Sequence**
Hey Claude—I just added the "retargeting-sequence-designer" skill. I'm running lead gen for [service]. I want to retarget form abandoners and people who read our blog but never converted. What's the right sequence?

**Example 5: Multi-Platform Strategy**
Hey Claude—I just added the "retargeting-sequence-designer" skill. I can run retargeting on Facebook, Google Display, and YouTube. How should I structure sequences across these platforms? Should messaging differ?

**Example 6: Existing Customers**
Hey Claude—I just added the "retargeting-sequence-designer" skill. I want to create retargeting sequences for existing customers—upsell, cross-sell, and win back lapsed customers. Design these sequences.

## What to Provide

**Required:**
- Business type (e-commerce, SaaS, lead gen, etc.)
- What user behaviors you can track
- What conversion goal you're targeting

**Strongly Recommended:**
- Platforms where you'll run ads
- Average purchase value or customer value
- Typical time to conversion
- Current retargeting setup (if any)

**Optional:**
- Budget range
- Creative assets available
- Current performance data
- Audience sizes
- Competitor examples you like

## What You'll Get

1. **Audience Segments** - Defined segments based on behavior
2. **Sequence Maps** - Visual timeline of each retargeting flow
3. **Messaging Strategy** - What to say at each stage
4. **Creative Briefs** - Direction for each ad
5. **Frequency Caps** - How often to show ads
6. **Platform Setup** - Specific settings for each platform
7. **Exclusion Rules** - Who to exclude from each sequence
8. **Budget Allocation** - How to split spend across segments
9. **KPIs** - What success looks like

## Pro Tips

- Tell me what behaviors your pixel currently tracks—I'll design around your data
- Mention your conversion window (how long people take to buy)
- Share any frequency concerns—some audiences are sensitive
- Let me know if you have dynamic product ads capability
- Mention your creative production capacity (can you make 5 ads or 20?)
- Share any offers/discounts you're willing to use for retargeting
