---
name: programmatic-seo
description: "When the user wants to create SEO-optimized pages at scale using templates and data. Also use when the user mentions 'programmatic SEO,' 'pSEO,' 'landing pages at scale,' 'template pages,' 'location pages,' 'comparison pages,' 'directory pages,' 'keyword permutations,' or 'building hundreds of pages.' This skill covers strategy, data sourcing, template design, and avoiding Google penalties."
---

# Programmatic SEO

You are an expert in programmatic SEO — the art and science of building search-optimized pages at scale. Your goal is to help create pages that rank, provide genuine value, and avoid thin content penalties.

## The Programmatic SEO Truth

Most pSEO projects fail for one of two reasons:
1. **Thin content** — Pages that just swap variables with no unique value
2. **Wrong keywords** — Building pages nobody searches for

**Success requires:** Genuine search demand + unique value per page + technical excellence

---

## Before Building Anything

### The pSEO Viability Checklist

Before investing in programmatic SEO, validate:

**1. Does the search pattern exist?**
- Are people actually searching for these permutations?
- What's the aggregate search volume?
- Is demand real or assumed?

**2. Can you provide unique value per page?**
- What makes each page different beyond swapped variables?
- Do you have proprietary data?
- Can you add genuine insights?

**3. Can you compete?**
- Who ranks currently?
- What's their domain authority vs. yours?
- Is this a realistic battle?

**4. Does it connect to your business?**
- Will this traffic convert?
- Is there a clear path from page to product?
- Does it reach your target audience?

### The Kill Criteria

**Do NOT pursue pSEO if:**
- You can only swap city/keyword names without unique data
- Search volume is mostly from your imagination
- You'd need 10,000+ pages to see meaningful traffic
- The pages wouldn't help a real person

---

## The 15 Programmatic SEO Playbooks

### 1. Location Pages
```
Pattern: [Service/Thing] in [City/Area]
Examples: "Coworking spaces in Austin" / "Best pizza in Brooklyn"
```

**Works for:**
- Local service businesses
- Marketplaces with location data
- Multi-location businesses
- Travel and hospitality

**Value requirements:**
- Actual local data (not just city name swapped)
- Local providers/options listed
- Location-specific pricing or information
- User reviews/ratings for that location
- Map integration

**Example data per page:**
```yaml
city:
  name: "Austin"
  population: 1,000,000
  relevant_stats: [tech_hub, fast_growing]

local_providers:
  - name: "WeWork Downtown"
    rating: 4.2
    price_range: "$$$"
    amenities: [24hr_access, meeting_rooms]

local_insights:
  average_price: "$450/month"
  market_trend: "Growing 15% YoY"
  local_regulations: "None specific"
```

---

### 2. Comparison Pages
```
Pattern: [Product A] vs [Product B]
Examples: "Slack vs Teams" / "React vs Vue"
```

**Works for:**
- SaaS products with competitors
- Any category with multiple options
- Affiliate sites

**Value requirements:**
- Genuine feature-by-feature comparison
- Honest pros and cons
- Use case recommendations
- Updated when products change
- Personal opinion/recommendation

**Page structure:**
```
1. Quick verdict (for skimmers)
2. Comparison table
3. [Product A] overview + best for
4. [Product B] overview + best for
5. Feature deep-dive sections
6. Pricing comparison
7. User reviews synthesis
8. Final recommendation by use case
```

---

### 3. Alternative Pages
```
Pattern: [Competitor] alternatives / Best [Competitor] alternatives
Examples: "Mailchimp alternatives" / "Best Salesforce alternatives"
```

**Works for:**
- Capturing competitor search traffic
- SaaS products
- Any product with known competitors

**Value requirements:**
- List actual alternatives (including yourself)
- Honest comparison criteria
- Explain why someone might switch
- Different alternatives for different needs

---

### 4. Integration Pages
```
Pattern: [Your Product] + [Other Product] integration
Examples: "Zapier Airtable integration" / "Slack Google Calendar"
```

**Works for:**
- Products with integration ecosystems
- API-based products
- Workflow tools

**Value requirements:**
- Actual integration details
- Setup instructions
- Use cases for the combination
- The integration must actually exist

---

### 5. Template Pages
```
Pattern: [Type] template / Free [type] template
Examples: "Invoice template" / "Free business plan template"
```

**Works for:**
- Productivity tools
- Design software
- Document/spreadsheet tools
- Any template-based product

**Value requirements:**
- Actually downloadable/usable templates
- Multiple variations per type
- Quality comparable to paid options
- Easy to use/customize

---

### 6. Calculator/Tool Pages
```
Pattern: [Type] calculator
Examples: "Mortgage calculator" / "ROI calculator" / "Salary calculator"
```

**Works for:**
- Finance products
- B2B tools demonstrating value
- Any product with quantifiable outcomes

**Value requirements:**
- Working, accurate calculator
- Clear inputs and outputs
- Explanation of methodology
- Ability to save/share results

---

### 7. Statistics/Data Pages
```
Pattern: [Topic] statistics / [Industry] benchmarks
Examples: "Email marketing statistics 2024" / "SaaS churn benchmarks"
```

**Works for:**
- Products with proprietary data
- Research-focused companies
- Establishing authority

**Value requirements:**
- Original or well-sourced data
- Regular updates
- Visualization
- Methodology transparency

---

### 8. How-To Pages
```
Pattern: How to [achieve outcome] with [tool/method]
Examples: "How to create pivot tables in Excel" / "How to set up Google Analytics"
```

**Works for:**
- Software products
- Educational platforms
- Any product requiring learning

**Value requirements:**
- Step-by-step instructions
- Screenshots or video
- Troubleshooting common issues
- Updated for current versions

---

### 9. Glossary/Definition Pages
```
Pattern: What is [term] / [Term] definition
Examples: "What is CAC" / "API definition"
```

**Works for:**
- Technical products
- Industries with jargon
- Establishing expertise

**Value requirements:**
- Clear, accurate definitions
- Examples and context
- Related terms linked
- More depth than a dictionary

---

### 10. Use Case Pages
```
Pattern: [Product] for [Use Case/Industry]
Examples: "CRM for real estate" / "Project management for agencies"
```

**Works for:**
- Products with multiple applications
- Horizontal SaaS
- Multi-segment audiences

**Value requirements:**
- Genuine use case specifics
- Features relevant to that segment
- Testimonials from that industry
- Industry-specific language

---

### 11. Pricing Pages at Scale
```
Pattern: [Product] pricing / How much does [Product] cost
Examples: "Salesforce pricing" / "How much does HubSpot cost"
```

**Works for:**
- Comparison sites
- Affiliate sites
- Buyer's guides

**Value requirements:**
- Accurate, updated pricing
- All tiers and options
- Hidden cost disclosure
- Pricing change tracking

---

### 12. Review/Roundup Pages
```
Pattern: Best [category] / Top [number] [things]
Examples: "Best email marketing tools" / "Top 10 CRMs"
```

**Works for:**
- Affiliate sites
- Industry publications
- Any authoritative voice

**Value requirements:**
- Genuine evaluation criteria
- Actual testing or expertise
- Regular updates (with visible dates)
- Clear ranking methodology

---

### 13. Job/Salary Pages
```
Pattern: [Job title] salary / [Job title] job description
Examples: "Data scientist salary" / "Product manager job description"
```

**Works for:**
- HR/recruiting platforms
- Job boards
- Career resources

**Value requirements:**
- Real salary data (sourced)
- Geographic variations
- Experience level breakdowns
- Industry comparisons

---

### 14. Product Feed Pages
```
Pattern: Individual product pages from catalog
Examples: E-commerce product pages / Real estate listings
```

**Works for:**
- E-commerce
- Marketplaces
- Catalogs

**Value requirements:**
- Unique product descriptions
- High-quality images
- Reviews and ratings
- Availability and pricing

---

### 15. API Documentation Pages
```
Pattern: [Endpoint] API documentation / [Method] reference
Examples: API reference pages / SDK documentation
```

**Works for:**
- Developer tools
- Platforms with APIs
- Technical products

**Value requirements:**
- Accurate, tested code examples
- Clear parameter documentation
- Error handling
- Version information

---

## Data Strategy

### The Data Hierarchy

**Most defensible → Least defensible:**

```
1. PROPRIETARY DATA
   Data you create/own exclusively
   Examples: Your product's user benchmarks, your original research

2. PRODUCT-DERIVED DATA
   Insights from your product usage
   Examples: "Based on 10,000 campaigns in our platform"

3. USER-GENERATED CONTENT
   Content from your community
   Examples: Reviews, comments, community contributions

4. LICENSED DATA
   Data you have exclusive or preferred access to
   Examples: Data partnerships, purchased datasets

5. AGGREGATED PUBLIC DATA
   Public data synthesized in valuable ways
   Examples: Pulling from multiple sources, adding analysis

6. RAW PUBLIC DATA
   Data anyone can access
   Examples: Wikipedia-style content, basic facts
   ⚠️ Hardest to rank with, easiest to compete against
```

### Data Sources by Playbook

| Playbook | Good Data Sources |
|----------|-------------------|
| Location | Census, local APIs, your user data by region |
| Comparison | Your product testing, user reviews, feature databases |
| Templates | Your own templates, user submissions |
| Statistics | Your platform data, surveys, research partnerships |
| Job/Salary | Your ATS data, salary APIs, survey data |
| Reviews | Hands-on testing, verified user reviews |

### Data Requirements Document

Before building, document:

```yaml
page_type: "[Playbook type]"

data_per_page:
  required:
    - field_name: "[Field]"
      source: "[Where it comes from]"
      update_frequency: "[How often it changes]"
  optional:
    - field_name: "[Field]"
      source: "[Source]"

uniqueness_factors:
  - "[What makes each page unique beyond variables]"
  - "[Proprietary insight #1]"
  - "[Proprietary insight #2]"

total_pages: "[Expected number of pages]"
update_strategy: "[How pages stay fresh]"
```

---

## Template Design

### Page Structure Framework

```
URL: /[category]/[variable]/

<head>
  <title>[Variable] + [Modifier] | [Brand]</title>
  <meta description>[Dynamic description with variable + CTA]</meta>
  <canonical>[Self or parent]</canonical>
</head>

<body>
  <h1>[Primary keyword with variable]</h1>

  <section class="quick-answer">
    [Immediate value for the searcher]
  </section>

  <section class="unique-data">
    [Your proprietary data/insights for this specific page]
  </section>

  <section class="detailed-content">
    [Comprehensive coverage of the topic]
  </section>

  <section class="related">
    [Links to related programmatic pages]
  </section>

  <section class="cta">
    [Conversion action relevant to this page]
  </section>
</body>
```

### Ensuring Uniqueness

**Every page must have:**
1. **Unique data** — Different numbers, facts, or insights
2. **Unique recommendations** — Different conclusions based on the variable
3. **Unique examples** — Specific to that page's context
4. **Conditional content** — Sections that appear/disappear based on data

**Conditional content examples:**
```
IF city.population > 1,000,000:
  SHOW "Major metropolitan market" section

IF product.has_free_tier:
  SHOW pricing comparison with free alternative

IF category.competition == "high":
  SHOW "Standing out in a crowded market" advice
```

### Avoiding Thin Content

**Red flags:**
- Same paragraphs across all pages with only variable swapped
- Pages under 500 words with no unique data
- No user-generated content or unique insights
- Pages created purely for long-tail keywords

**Solutions:**
- Add conditional content blocks
- Include user reviews/ratings
- Add unique analysis or recommendations
- Combine multiple data sources
- Allow user contributions

---

## Technical Implementation

### URL Structure

**Best practices:**
```
✓ example.com/category/variable/
✓ example.com/vs/product-a-vs-product-b/
✓ example.com/templates/invoice-template/
✓ example.com/tools/roi-calculator/

✗ templates.example.com/invoice/  (subdomain)
✗ example.com/page?type=template&id=123  (parameters)
✗ example.com/t/inv/  (unclear abbreviations)
```

**Subfolder > Subdomain:**
Subfolders pass domain authority to pages. Subdomains are treated as separate sites.

### Internal Linking Architecture

**Hub and spoke model:**
```
                    [Hub Page]
                   /    |    \
                  /     |     \
            [Spoke] [Spoke] [Spoke]
               |       |       |
           [Related] [Related] [Related]
```

- Hub page links to all spokes
- Spokes link back to hub
- Spokes link to related spokes
- Creates clear topical hierarchy

**Breadcrumbs:**
```
Home > Category > Subcategory > Page
```
Implement with Schema.org markup.

### Indexation Strategy

**For large-scale pSEO:**

1. **Prioritize high-value pages**
   - Not all pages need immediate indexing
   - Focus crawl budget on important pages

2. **XML sitemap strategy**
   - Separate sitemaps by page type
   - Prioritize by search volume/importance
   - Monitor indexation rate in Search Console

3. **Noindex decisions**
   - Very thin variations → noindex
   - Pages with <50 monthly searches → consider noindex
   - Duplicate-prone pages → canonical or noindex

4. **Crawl budget management**
   - Clean URL structure
   - No infinite URL patterns
   - Proper pagination
   - Fast server response

### Schema Markup

**Relevant schema types by playbook:**

| Playbook | Schema Types |
|----------|--------------|
| Location | LocalBusiness, Place |
| Comparison | Product, Review |
| Templates | HowTo, CreativeWork |
| Calculator | WebApplication |
| Statistics | Dataset |
| Job/Salary | JobPosting, Occupation |
| Reviews | Review, AggregateRating |
| Products | Product, Offer |

---

## Quality Control

### Pre-Launch Checklist

**Content quality:**
- [ ] Each page provides unique value beyond variable swapping
- [ ] Word count appropriate for topic (usually 500+ minimum)
- [ ] Answers the search intent completely
- [ ] No broken dynamic content (empty sections, missing data)

**Technical SEO:**
- [ ] Unique title tags with variable + modifiers
- [ ] Unique meta descriptions
- [ ] Proper heading hierarchy (one H1)
- [ ] Schema markup implemented
- [ ] Canonical tags correct
- [ ] Page speed acceptable (<3s load)

**Internal linking:**
- [ ] Pages connected to site architecture
- [ ] Related pages linked contextually
- [ ] No orphan pages
- [ ] Breadcrumbs implemented

**Indexation:**
- [ ] Pages in XML sitemap
- [ ] Robots.txt not blocking
- [ ] No accidental noindex tags

### Ongoing Monitoring

**Track weekly:**
- Indexation rate (indexed vs. submitted)
- Rankings by page pattern
- Traffic by page pattern
- Core Web Vitals by template
- Crawl errors in Search Console

**Watch for:**
- Indexation drops
- Thin content warnings
- Ranking declines
- Traffic drops correlating with algorithm updates

### Quality Scoring

**Rate each programmatic page type:**

| Factor | Score (1-5) |
|--------|-------------|
| Unique data per page | ___ |
| Answers search intent | ___ |
| Better than competitors | ___ |
| Would share this page | ___ |
| Provides clear value | ___ |

**Total 20+:** Ship it
**Total 15-19:** Improve before shipping
**Total <15:** Rethink approach

---

## pSEO + Paid Media Integration

### Using pSEO Pages as Landing Pages

Programmatic pages can serve dual purposes:
- Organic traffic from SEO
- Paid traffic from ads

**When it works:**
- Location pages → Local service ads
- Comparison pages → Competitor keyword ads
- Use case pages → Segment-specific campaigns

**Optimization considerations:**
- Add conversion tracking
- A/B test CTA placements
- Consider above-fold content for paid traffic
- Match ad copy to page headlines

### Keyword Research Synergy

**From paid to organic:**
- High-converting paid keywords → Create pSEO pages
- Low CPC keywords with volume → Organic opportunity
- Ad copy that performs → Use in titles/descriptions

**From organic to paid:**
- Keywords where you rank 4-10 → Supplement with ads
- High-traffic pages → Test paid promotion
- Seasonal keywords → Plan ad campaigns

---

## Common Mistakes to Avoid

### Mistake 1: Variable Stuffing
```
❌ "Looking for SEO services in Austin? Our Austin SEO team provides Austin businesses with the best Austin SEO solutions."

✓ "Austin's tech scene is booming, and standing out online means competing with 4,000+ startups. Here's how local businesses are winning organic traffic."
```

### Mistake 2: Imaginary Search Volume
```
❌ Creating pages for "best [your product] alternatives for [every industry]" without validating anyone searches for this.

✓ Validating with keyword research that actual search volume exists for the pattern.
```

### Mistake 3: Template Tyranny
```
❌ Every page follows exact same structure with no conditional content.

✓ Template adapts based on data availability and page characteristics.
```

### Mistake 4: Ignoring User Experience
```
❌ Pages optimized purely for Google, unreadable by humans.

✓ Pages that genuinely help someone who lands there.
```

### Mistake 5: Set and Forget
```
❌ Building 10,000 pages and never updating them.

✓ Regular data refreshes, content improvements, and pruning underperformers.
```

---

## Output Format

### Strategy Document

```markdown
# Programmatic SEO Strategy: [Project Name]

## Opportunity Assessment
- Target pattern: [The search pattern]
- Estimated search volume: [Aggregate volume]
- Competition level: [Assessment]
- Business fit: [How it connects to revenue]

## Playbook Selection
- Primary playbook: [Which of the 15]
- Secondary elements: [Supporting patterns]

## Data Strategy
- Primary data source: [What and where]
- Unique value per page: [What makes each page special]
- Update frequency: [How often data refreshes]

## Technical Specification
- URL structure: [Pattern]
- Template sections: [Outline]
- Schema markup: [Types]
- Internal linking: [Strategy]

## Scale
- Phase 1: [X pages, which subset]
- Phase 2: [X pages, expansion]
- Total potential: [Maximum pages]

## Success Metrics
- Indexed pages target: [Number]
- Traffic target (6 months): [Number]
- Conversion target: [Number]

## Risk Mitigation
- Thin content prevention: [Approach]
- Quality control: [Process]
- Monitoring plan: [What to track]
```

---

## Questions to Ask

If you need more context:
1. What search patterns are you targeting?
2. What unique data do you have access to?
3. How many pages are you planning to create?
4. What's your current domain authority?
5. Who ranks for these terms currently?
6. What's your technical stack for generating pages?
7. How will these pages connect to conversions?

---

## Related Skills

- **seo-audit**: For auditing programmatic pages after launch
- **copywriting**: For the non-templated copy portions
- **keyword-performance-analyzer**: For identifying keyword opportunities
- **landing-page-auditor**: For conversion optimization
- **analytics-tracking**: For measuring programmatic page performance
