---
name: pricing-page-auditor
description: Audits pricing pages for conversion optimization and revenue maximization. Triggers when user shares pricing page URL/screenshot, asks "why aren't people upgrading?", or wants to optimize pricing presentation. Evaluates tier structure, anchoring, feature gating, value communication, and psychological triggers. Provides specific fixes to increase plan selection and upgrade rates.
---

# Pricing Page Auditor

Turn your pricing page from a decision blocker into a conversion driver.

## Core Philosophy

**Pricing is positioning.** Your pricing page doesn't just communicate cost—it signals value, quality, and who you're for. Every element either builds confidence or creates doubt.

**The Goal:** Make the right choice obvious and the purchase decision feel safe.

**The Principle:** Great pricing pages reduce cognitive load, anchor expectations, and guide visitors to the optimal plan for them (and for you).

---

## Required Context

### Must Have

**1. Pricing Page**
- URL or screenshots
- All tiers visible
- Feature lists and pricing

**2. Business Context**
- Business model (SaaS, e-commerce, service)
- Primary revenue goal (volume vs. revenue per customer)
- Target customer (SMB, enterprise, consumer)

### Strongly Recommended

**3. Current Performance**
- Plan distribution (% on each tier)
- Pricing page conversion rate
- Most common plan selected
- Upgrade/downgrade patterns

**4. Pricing Strategy Intent**
- Which tier you want people to choose
- Any plans being phased out or pushed
- Pricing changes planned

### Nice to Have

- Competitor pricing pages
- Customer feedback on pricing
- Sales objections related to pricing
- Win/loss data where price was factor
- A/B test history on pricing page

---

## Audit Framework

### The 8 Pricing Page Pillars

| Pillar | Focus | Impact |
|--------|-------|--------|
| **Tier Architecture** | Number, names, and structure of plans | High |
| **Price Anchoring** | How prices are framed and compared | High |
| **Value Hierarchy** | How features/benefits are presented | High |
| **Visual Guidance** | Design directing to preferred plan | Medium |
| **Trust Elements** | Social proof and risk reducers | Medium |
| **Urgency/Scarcity** | Motivation to act now | Medium |
| **Objection Handling** | FAQ and concerns addressed | Medium |
| **CTA Clarity** | Button text and next steps | High |

---

### Pillar 1: Tier Architecture

**Number of Tiers:**

| Count | Assessment |
|-------|------------|
| 1 | Too simple—no anchoring, no upsell path |
| 2 | Works for simple products, limited anchoring |
| 3 | Ideal—good, better, best psychology works |
| 4 | Acceptable if clear differentiation exists |
| 5+ | Decision overload—simplify |

**Tier Naming Assessment:**

| Naming Pattern | Effectiveness | Example |
|----------------|---------------|---------|
| Good-Better-Best | High | Basic, Pro, Enterprise |
| Audience-Based | High | Starter, Team, Business |
| Value-Based | Medium | Essential, Growth, Scale |
| Generic | Low | Plan 1, Plan 2, Plan 3 |
| Confusing | Poor | Silver, Platinum, Diamond |

**Tier Naming Check:**

| Tier | Name | Clear Who It's For? | Aspirational? |
|------|------|---------------------|---------------|
| [Tier 1] | [Name] | Y/N | Y/N |
| [Tier 2] | [Name] | Y/N | Y/N |
| [Tier 3] | [Name] | Y/N | Y/N |

**Tier Spread Analysis:**

| Metric | Value | Assessment |
|--------|-------|------------|
| Lowest price | $X | [Market position] |
| Highest non-enterprise | $X | [Market position] |
| Price multiplier (high/low) | Xx | Ideal: 3-5x |
| Step increase pattern | [Even/Uneven] | [Assessment] |

---

### Pillar 2: Price Anchoring

**Anchoring Techniques Present:**

| Technique | Present? | Execution |
|-----------|----------|-----------|
| High anchor displayed first/prominently | Y/N | [Assessment] |
| Annual vs. monthly comparison | Y/N | [Savings shown?] |
| "Was/Now" or crossed-out pricing | Y/N | [Assessment] |
| Per-unit vs. total pricing | Y/N | [Which is shown?] |
| Competitor comparison | Y/N | [How handled?] |
| Value quantification | Y/N | [ROI shown?] |

**Annual Pricing Analysis:**

| Metric | Value | Assessment |
|--------|-------|------------|
| Monthly price | $X/mo | — |
| Annual price (per month) | $X/mo | — |
| Annual discount | X% | Ideal: 15-20% |
| Savings displayed | $X/year | [Prominent?] |
| Default selection | Monthly/Annual | [Which?] |

**Anchoring Score:**

| Element | Score | Notes |
|---------|-------|-------|
| High anchor visible | 0-10 | [Assessment] |
| Savings clearly communicated | 0-10 | [Assessment] |
| Comparison framing effective | 0-10 | [Assessment] |

---

### Pillar 3: Value Hierarchy

**Feature Presentation Style:**

| Style | Present? | Effectiveness |
|-------|----------|---------------|
| Features listed | Y/N | Commodity feel |
| Benefits emphasized | Y/N | Value-oriented |
| Outcomes promised | Y/N | Most compelling |

**Feature List Analysis:**

| Issue | Present? | Impact |
|-------|----------|--------|
| Too many features (>10 per tier) | Y/N | Overwhelming |
| Features without context | Y/N | Meaningless |
| Jargon/technical terms | Y/N | Confusing |
| Key features buried | Y/N | Missed value |
| No differentiation visible | Y/N | Why upgrade? |

**Feature Gating Assessment:**

| Feature | Gated To | Makes Sense? | Creates Desire? |
|---------|----------|--------------|-----------------|
| [Feature 1] | [Tier] | Y/N | Y/N |
| [Feature 2] | [Tier] | Y/N | Y/N |
| [Feature 3] | [Tier] | Y/N | Y/N |

**Value Communication Score:**

| Element | Score | Notes |
|---------|-------|-------|
| Benefits over features | 0-10 | [Assessment] |
| Clear tier differentiation | 0-10 | [Assessment] |
| Upgrade value obvious | 0-10 | [Assessment] |

---

### Pillar 4: Visual Guidance

**Recommended Plan Signals:**

| Signal | Present? | Effectiveness |
|--------|----------|---------------|
| "Most Popular" badge | Y/N | [Assessment] |
| "Recommended" label | Y/N | [Assessment] |
| Visual highlight (color/border) | Y/N | [Assessment] |
| Size/prominence difference | Y/N | [Assessment] |
| Position (center/first) | Y/N | [Assessment] |

**Visual Hierarchy Assessment:**

| Element | Score | Notes |
|---------|-------|-------|
| Eye drawn to preferred plan | 0-10 | [Assessment] |
| CTA buttons stand out | 0-10 | [Assessment] |
| Price is readable/prominent | 0-10 | [Assessment] |
| Easy to scan/compare | 0-10 | [Assessment] |
| Mobile experience | 0-10 | [Assessment] |

**Comparison UX:**

| Element | Present? | Quality |
|---------|----------|---------|
| Side-by-side comparison | Y/N | [Assessment] |
| Feature comparison table | Y/N | [Assessment] |
| Checkmarks vs. X marks | Y/N | [Balanced?] |
| Expandable details | Y/N | [Assessment] |

---

### Pillar 5: Trust Elements

**Social Proof on Pricing Page:**

| Element | Present? | Placement | Quality |
|---------|----------|-----------|---------|
| Customer logos | Y/N | Above/Below pricing | H/M/L |
| Customer count | Y/N | [Location] | H/M/L |
| Testimonials | Y/N | [Location] | H/M/L |
| Ratings/reviews | Y/N | [Location] | H/M/L |
| Case study links | Y/N | [Location] | H/M/L |

**Risk Reducers:**

| Element | Present? | Prominence |
|---------|----------|------------|
| Money-back guarantee | Y/N | [Assessment] |
| Free trial available | Y/N | [Assessment] |
| No credit card required | Y/N | [Assessment] |
| Cancel anytime | Y/N | [Assessment] |
| Security badges | Y/N | [Assessment] |
| Compliance certifications | Y/N | [Assessment] |

**Trust Score:**

| Element | Score | Notes |
|---------|-------|-------|
| Social proof visible | 0-10 | [Assessment] |
| Risk clearly reduced | 0-10 | [Assessment] |
| Credibility established | 0-10 | [Assessment] |

---

### Pillar 6: Urgency/Scarcity

**Urgency Elements:**

| Element | Present? | Type | Authentic? |
|---------|----------|------|------------|
| Limited time offer | Y/N | Real/Manufactured | Y/N |
| Price increase warning | Y/N | Real/Manufactured | Y/N |
| Limited availability | Y/N | Real/Manufactured | Y/N |
| Countdown timer | Y/N | Real/Manufactured | Y/N |
| Early bird pricing | Y/N | Real/Manufactured | Y/N |

**Urgency Assessment:**

| Criterion | Score | Notes |
|-----------|-------|-------|
| Urgency present | 0-10 | [Assessment] |
| Feels authentic | 0-10 | [Assessment] |
| Not manipulative | 0-10 | [Assessment] |

---

### Pillar 7: Objection Handling

**FAQ Section:**

| Element | Present? | Quality |
|---------|----------|---------|
| FAQ section exists | Y/N | — |
| Addresses pricing objections | Y/N | [Assessment] |
| Addresses switching concerns | Y/N | [Assessment] |
| Addresses feature questions | Y/N | [Assessment] |
| Addresses billing/refund | Y/N | [Assessment] |

**Common Objections Coverage:**

| Objection | Addressed? | How |
|-----------|------------|-----|
| "Too expensive" | Y/N | [How handled] |
| "Not sure which plan" | Y/N | [How handled] |
| "What if I need to change?" | Y/N | [How handled] |
| "Hidden fees?" | Y/N | [How handled] |
| "What about support?" | Y/N | [How handled] |
| "How does billing work?" | Y/N | [How handled] |

---

### Pillar 8: CTA Clarity

**Primary CTA Analysis:**

| Tier | CTA Text | Assessment |
|------|----------|------------|
| [Tier 1] | [Button text] | [Clear? Action-oriented?] |
| [Tier 2] | [Button text] | [Clear? Action-oriented?] |
| [Tier 3] | [Button text] | [Clear? Action-oriented?] |

**CTA Assessment:**

| Element | Score | Notes |
|---------|-------|-------|
| Action clarity | 0-10 | Do I know what happens next? |
| Consistency | 0-10 | Same style across tiers? |
| Urgency in CTA | 0-10 | Does it motivate action? |
| Risk in CTA | 0-10 | Does it feel safe? |

**CTA Button Audit:**

| Issue | Present? |
|-------|----------|
| Generic text ("Submit", "Buy") | Y/N |
| Multiple competing CTAs | Y/N |
| CTA below fold | Y/N |
| Low contrast button | Y/N |
| Unclear next step | Y/N |

---

## Output Format

### Executive Summary

```
PRICING PAGE SCORE: XX/100 [GRADE]

Page: [URL or Name]
Business Model: [SaaS/E-commerce/Service]
Tiers: [X] plans

BIGGEST STRENGTH: [What's working well]
BIGGEST WEAKNESS: [Primary conversion blocker]
QUICK WIN: [Easiest high-impact fix]
ESTIMATED IMPACT: [Revenue/conversion improvement]
```

**Grade Scale:**

| Score | Grade | Assessment |
|-------|-------|------------|
| 85-100 | A | Optimized—minor tweaks only |
| 70-84 | B | Good foundation, clear improvements |
| 55-69 | C | Significant issues hurting conversion |
| 40-54 | D | Major problems, needs overhaul |
| <40 | F | Fundamentally broken |

---

### Pillar Scores

```
TIER ARCHITECTURE:    ████████████████░░░░ 40/50
PRICE ANCHORING:      ████████████░░░░░░░░ 30/50  ⚠️
VALUE HIERARCHY:      ██████████████░░░░░░ 35/50
VISUAL GUIDANCE:      ████████████████████ 45/50
TRUST ELEMENTS:       ████████░░░░░░░░░░░░ 20/50  ⚠️
URGENCY/SCARCITY:     ██████░░░░░░░░░░░░░░ 15/50
OBJECTION HANDLING:   ████████████░░░░░░░░ 30/50
CTA CLARITY:          ██████████████████░░ 42/50

OVERALL: 257/400 = 64/100 (C)
```

---

### Critical Issues

**Issue 1: [Title]**
- **Pillar:** [Which pillar]
- **Problem:** [Specific description]
- **Evidence:** [What I observed]
- **Impact:** [How it hurts conversion/revenue]
- **Fix:** [Specific recommendation]
- **Priority:** CRITICAL

---

### High-Priority Improvements

**Improvement 1: [Title]**
- **Pillar:** [Which pillar]
- **Current:** [What exists]
- **Recommended:** [What to change]
- **Rationale:** [Why this helps]
- **Effort:** Low/Medium/High
- **Impact:** High/Medium/Low

---

### Tier-by-Tier Analysis

**[Tier 1 Name] - $X/mo**

| Element | Assessment |
|---------|------------|
| Target audience clear | [Y/N + notes] |
| Value proposition | [Assessment] |
| Feature presentation | [Assessment] |
| CTA effectiveness | [Assessment] |
| Upgrade path clear | [Assessment] |

**Recommendation:** [Specific changes for this tier]

---

**[Tier 2 Name] - $X/mo**

[Same format]

---

### Pricing Psychology Opportunities

**Currently Missing:**

| Technique | Recommendation | Expected Impact |
|-----------|----------------|-----------------|
| [Technique 1] | [How to implement] | [Impact] |
| [Technique 2] | [How to implement] | [Impact] |

**Decoy Pricing Opportunity:**
[If applicable, explain how to use decoy pricing]

**Anchoring Improvement:**
[Specific recommendations for better anchoring]

---

### Recommended Rewrites

**Tier Names:**
| Current | Recommended | Rationale |
|---------|-------------|-----------|
| [Current name] | [New name] | [Why] |

**CTA Buttons:**
| Current | Recommended | Rationale |
|---------|-------------|-----------|
| [Current CTA] | [New CTA] | [Why] |

**Value Statements:**
| Tier | Recommended Tagline |
|------|---------------------|
| [Tier 1] | "[Tagline that captures value]" |
| [Tier 2] | "[Tagline that captures value]" |
| [Tier 3] | "[Tagline that captures value]" |

---

### A/B Test Recommendations

| Test | Hypothesis | Priority |
|------|------------|----------|
| [Test 1] | If we [change], then [outcome] because [reason] | High |
| [Test 2] | If we [change], then [outcome] because [reason] | Medium |
| [Test 3] | If we [change], then [outcome] because [reason] | Medium |

---

### Competitor Comparison (if provided)

| Element | Your Page | Competitor | Advantage |
|---------|-----------|------------|-----------|
| Tier count | X | X | [Who] |
| Price range | $X-$X | $X-$X | [Assessment] |
| Annual discount | X% | X% | [Who] |
| Trust signals | [Count] | [Count] | [Who] |
| CTA clarity | [Score] | [Score] | [Who] |

---

## Pricing Psychology Reference

### Key Principles

**1. Anchoring Effect**
- First price seen sets expectations
- Show high option first (even if few buy it)
- Compare to higher competitor/alternative

**2. Decoy Effect**
- Add option that makes target option look better
- Decoy should be close in price, less in value
- Works best with 3 options

**3. Center Stage Effect**
- Middle option gets chosen most often
- Position preferred plan in center
- Ensure middle is most profitable

**4. Price-Quality Inference**
- Higher price = higher perceived quality
- Don't be cheapest unless that's your strategy
- Premium tier validates mid-tier value

**5. Pain of Paying**
- Monthly feels smaller than annual
- Per-user feels smaller than total
- Show savings, not just price

---

## Limitations

**I can assess:**
- Visual presentation and layout
- Pricing psychology application
- Copy and messaging effectiveness
- Trust signal presence
- Obvious UX issues
- Competitive positioning

**I cannot assess:**
- Price sensitivity (need customer research)
- Willingness to pay (need surveys/tests)
- Actual conversion data (need analytics)
- Feature value perception (need user research)
- Price elasticity (need experiments)

**For complete pricing optimization, also conduct:**
- Van Westendorp price sensitivity analysis
- Conjoint analysis for feature value
- Customer interviews on pricing
- A/B tests on pricing page
- Win/loss analysis with pricing focus

---

## Quality Checklist

Before delivering audit:
- [ ] All 8 pillars evaluated
- [ ] Each tier analyzed individually
- [ ] Pricing psychology assessed
- [ ] Critical issues clearly flagged
- [ ] Specific rewrites provided
- [ ] A/B test ideas included
- [ ] Competitor context (if provided)
- [ ] Limitations acknowledged
