# How to Use This Skill

Hey Claude—I just added the "pricing-page-auditor" skill. Can you audit my pricing page and tell me how to increase conversions?

## Example Invocations

**Example 1: Full Pricing Audit**
Hey Claude—I just added the "pricing-page-auditor" skill. Here's my SaaS pricing page [URL]. We have 3 tiers and want to push more people to the Pro plan. What's wrong and how do I fix it?

**Example 2: Tier Structure Review**
Hey Claude—I just added the "pricing-page-auditor" skill. I have 5 pricing tiers and I think that's too many. Here's the page [screenshot]. Should I consolidate? Which ones?

**Example 3: Psychology Check**
Hey Claude—I just added the "pricing-page-auditor" skill. I want to know if I'm using pricing psychology effectively. Here's my pricing page [URL]. Am I anchoring correctly? Should I add a decoy?

**Example 4: Competitor Comparison**
Hey Claude—I just added the "pricing-page-auditor" skill. Here's my pricing page [URL] and my main competitor's [URL]. How does mine compare and what should I steal?

**Example 5: Upgrade Rate Problem**
Hey Claude—I just added the "pricing-page-auditor" skill. 80% of our customers are on the free plan. Here's our pricing page [URL]. Why aren't people upgrading?

**Example 6: Annual vs Monthly**
Hey Claude—I just added the "pricing-page-auditor" skill. Only 20% of customers choose annual billing. Here's my pricing page [URL]. How do I push more to annual?

## What to Provide

**Required:**
- Pricing page URL or screenshots
- Business type (SaaS, e-commerce, service)
- Number of tiers

**Strongly Recommended:**
- Which tier you want people to choose
- Current plan distribution (if known)
- Target customer (SMB, enterprise, consumer)

**Optional:**
- Competitor pricing pages
- Current conversion rate
- Customer feedback on pricing
- Any planned pricing changes

## What You'll Get

1. **Pricing Page Score** - Overall grade across 8 pillars
2. **Tier Analysis** - Each plan evaluated individually
3. **Psychology Assessment** - Anchoring, decoy, and framing review
4. **Critical Issues** - Conversion blockers to fix immediately
5. **Rewrite Suggestions** - Better tier names, CTAs, and copy
6. **A/B Test Ideas** - What to test and expected impact

## Pro Tips

- Tell me which tier you WANT people to choose—I'll optimize for that
- Share your plan distribution data if you have it
- Include any enterprise/custom tier even if it's "Contact Us"
- Screenshot the whole page including FAQ section
- If you have competitor pages, share them for context
- Mention any constraints (can't change prices, must keep tier names, etc.)
