---
name: newsletter
description: Creates newsletter content across multiple formats and strategies. Triggers when user asks for "newsletter ideas", "email newsletter", "weekly roundup", "subscriber content", "newsletter strategy", or "turn content into newsletter". Provides 9 distinct formats from curated to story-driven, helping turn content into recurring audience touchpoints that build trust and drive conversions.
---

# Newsletter

Turn content into recurring audience touchpoints. 9 formats from curated to story-driven.

## Core Philosophy

**Newsletters aren't about blasting content—they're about building relationships at scale.** Every send is a promise kept. Every open is trust earned. Every click is interest validated.

**The Goal:** Create newsletter content people actually look forward to receiving.

**The Principle:** Consistency beats frequency. Value beats volume. Personality beats polish.

---

## Required Context

### Must Have

**1. Newsletter Basics**
- Newsletter name and purpose
- Target audience
- Current frequency (or planned)

**2. Content Goal**
What should readers DO after reading?
- Click through to content
- Reply/engage
- Purchase/convert
- Share/refer
- Learn something specific

**3. Available Content**
What do you have to work with?
- Original content (blog posts, guides, etc.)
- Curated content (industry news, resources)
- Product updates
- Customer stories
- Personal insights/opinions

### Strongly Recommended

**4. Voice/Tone**
- Brand voice guidelines
- Newsletter-specific personality
- Example newsletters you admire

**5. Format Preference**
- Length expectations
- Visual vs. text-heavy
- Section structure

### Nice to Have

- Current performance data (open rates, clicks)
- Subscriber feedback/replies
- Content calendar
- Team expertise to feature
- Seasonal/timely events

---

## The 9 Newsletter Formats

### Format 1: The Curator

**Best for:** Busy audiences who want filtered information
**Effort:** Medium
**Personality:** Moderate

**Structure:**
```
SUBJECT: [Catchy theme] + [Number] of must-reads

1. INTRO (2-3 sentences)
   - Quick context or theme
   - Why these picks matter this week

2. CURATED PICKS (3-7 items)
   Each pick includes:
   - Source/Title
   - 1-2 sentence summary
   - Why it matters / Your take
   - Link

3. SIGN-OFF
   - Quick personal note
   - CTA if relevant
```

**Example:**
```
SUBJECT: 5 things that'll change your Q2 strategy

Hey—

Three weeks into Q2 and the landscape already shifted. Here's what caught my attention:

📊 Google's removing broad match modifier
   → TL;DR: Your keyword strategy needs an audit. This changes everything.
   → Read the announcement: [link]

🎯 This case study on creative fatigue
   → Company saw 40% drop in ROAS from a single image. The fix took 20 minutes.
   → Full breakdown: [link]

[Continue pattern...]

That's your week. Hit reply if anything surprised you.

—[Name]
```

---

### Format 2: The Teacher

**Best for:** Audiences seeking to improve skills
**Effort:** High
**Personality:** High

**Structure:**
```
SUBJECT: How to [achieve specific outcome]

1. HOOK (1-2 sentences)
   - Promise or problem statement

2. CONTEXT (2-3 sentences)
   - Why this matters now
   - Common mistake or misconception

3. THE METHOD (Bulk of newsletter)
   - Step-by-step breakdown
   - Examples at each step
   - Common pitfalls to avoid

4. QUICK WIN
   - One thing they can do TODAY

5. CTA
   - Related resource
   - Reply prompt
```

**Example:**
```
SUBJECT: The 5-minute landing page audit that finds 80% of problems

Most landing page problems are obvious—if you know where to look.

I've audited 200+ pages this year. The same issues show up everywhere.
Here's the exact checklist I use:

**ABOVE THE FOLD (30 seconds)**
□ Can I tell what this is in 5 seconds?
□ Is there ONE clear action to take?
□ Does the headline speak to a desire, not a feature?

If any box is unchecked, stop. Fix these first.

**THE SCROLL TEST (60 seconds)**
[Continue teaching...]

YOUR HOMEWORK:
Open your top landing page right now. Run through just the "Above the Fold" section. Reply and tell me what you found.

—[Name]
```

---

### Format 3: The Storyteller

**Best for:** Building deep connection and brand affinity
**Effort:** High
**Personality:** Very High

**Structure:**
```
SUBJECT: [Intriguing story hook]

1. STORY OPENING
   - Drop into the middle of action
   - Specific details that create imagery

2. THE TENSION
   - What went wrong / the challenge
   - Stakes involved

3. THE TURN
   - What changed / the insight
   - The decision made

4. THE LESSON
   - Universal takeaway
   - How it applies to reader

5. BRIDGE TO ACTION
   - Natural transition to CTA
   - Or simple sign-off
```

**Example:**
```
SUBJECT: The $47,000 email I almost didn't send

Tuesday, 11:47 PM. I'm staring at a draft that's been sitting there for three weeks.

It's a re-engagement email to our dead leads. 2,847 contacts who downloaded something, then vanished.

My thumb hovers over "Send." I hesitate.

"What if they get annoyed? What if they unsubscribe? What if—"

I hit send and close my laptop.

Wednesday, 8 AM. I open my inbox to 23 replies. Not unsubscribes. Replies.

"Perfect timing. We were just talking about this."
"I meant to reach out—life got crazy."
"Can we get on a call this week?"

By Friday, we'd booked 11 calls. Closed 4 deals. $47,000 in revenue from people who were "dead."

The email? 47 words. No design. Just: "Hey, noticed you grabbed [X] a while back. Still working on [problem]? Happy to help if timing's better now."

The lesson isn't about the email. It's about the sends we don't make because we're protecting ourselves from imaginary rejection.

What's sitting in your drafts?

—[Name]
```

---

### Format 4: The Roundup

**Best for:** Consistent value delivery, easy to produce
**Effort:** Low-Medium
**Personality:** Low-Moderate

**Structure:**
```
SUBJECT: [Newsletter Name] #[Number]: [Theme or Hook]

1. QUICK INTRO
   - One personal sentence
   - Theme of this issue (optional)

2. SECTIONS (3-5 consistent sections)
   Examples:
   - 📰 News: [Industry updates]
   - 🛠 Tool: [Weekly recommendation]
   - 📊 Stat: [Interesting data point]
   - 💡 Tip: [Quick actionable advice]
   - 📖 Read: [Best article this week]
   - 🎧 Listen: [Podcast episode]
   - 🐦 Tweet: [Best social insight]

3. SIGN-OFF
   - Brief personal note
   - Same closing each time (builds ritual)
```

**Example:**
```
SUBJECT: The Growth Memo #47: The hidden cost of "free" tools

Happy Thursday—

📰 NEWS YOU CAN USE
Meta's testing AI-generated ad variations. Early results are... mixed.
Worth watching, not adopting yet. [Link]

🛠 TOOL OF THE WEEK
Tally (free Typeform alternative). Used it for 3 client projects.
Zero complaints. Unlimited forms. [Link]

📊 STAT THAT MATTERS
67% of B2B buyers say they're "overwhelmed" by content.
Takeaway: Less, better > more, mediocre.

💡 QUICK WIN
Before your next ad creative review, ask: "Would I stop scrolling for this?"
If you hesitate, so will they.

That's the memo. See you next Thursday.

—[Name]

PS: Reply with your tool of the week. Best one gets featured.
```

---

### Format 5: The Analyst

**Best for:** Data-driven audiences, establishing expertise
**Effort:** High
**Personality:** Moderate

**Structure:**
```
SUBJECT: [Specific insight from data]

1. THE FINDING
   - Lead with the insight
   - Specific numbers

2. THE DATA
   - How you found this
   - Sample size/credibility
   - Supporting data points

3. THE IMPLICATIONS
   - What this means for reader
   - What to do differently

4. THE CAVEATS
   - When this doesn't apply
   - Limitations of data

5. YOUR TAKE
   - Personal interpretation
   - What you're doing about it
```

**Example:**
```
SUBJECT: We analyzed 1,247 Facebook ads. Here's what's actually working.

Last month we audited 1,247 Facebook ads across 23 e-commerce accounts.

One pattern dominated everything else.

**THE FINDING:**
Ads using customer-generated photos outperformed studio shots by 2.3x on average.
Not influencer content. Not UGC-style brand content.
Actual customer photos pulled from reviews.

**THE DATA:**
- Sample: 1,247 ads, 23 accounts, $2.1M total spend
- Time period: Jan-Mar 2024
- "Outperformed" = lower CPA at statistical significance

**WHAT THIS MEANS:**
Your best creative might already exist—in your review section.

**ACTION STEPS:**
1. Mine your reviews for photos (G2, Amazon, Yelp, wherever)
2. Test 3-5 as ad creative this week
3. Track CPA against your current top performers

**CAVEAT:**
This worked for e-commerce. B2B/SaaS results pending—we're running that analysis now.

What patterns are you seeing? Reply and let me know.

—[Name]
```

---

### Format 6: The Behind-the-Scenes

**Best for:** Building trust, humanizing brand
**Effort:** Medium
**Personality:** Very High

**Structure:**
```
SUBJECT: [Honest/vulnerable hook]

1. THE REVEAL
   - Share something normally hidden
   - Process, mistake, internal debate

2. THE CONTEXT
   - Why you're sharing this
   - What led to this moment

3. THE DETAILS
   - Specific, concrete information
   - Numbers, screenshots, real examples

4. THE LESSON
   - What you learned
   - What you'd do differently

5. INVITATION
   - Ask for their experiences
   - Create two-way dialogue
```

**Example:**
```
SUBJECT: Our worst product launch (and what we learned)

Last March we launched a feature nobody used.

I'm not talking "underperformed." I'm talking 23 users in 90 days.
We spent 4 months building it.

Here's the full post-mortem:

**WHAT HAPPENED:**
We built "Advanced Reporting" because three enterprise prospects asked for it.
We didn't validate with existing customers. We assumed big accounts = right direction.

**THE NUMBERS:**
- Development time: 4 months
- Cost: ~$180K (fully loaded)
- Users after 90 days: 23
- Revenue generated: $0

**WHAT WE MISSED:**
The three prospects who asked? They wanted custom reports.
What we built? Template reports with more filters.
Same words, completely different needs.

**WHAT CHANGED:**
Now every feature request gets a 15-minute call: "Show me exactly what you'd do with this."

The features that come out of those calls?
Average adoption: 67% of users within 30 days.

Have you built something nobody used? Reply—I'd love to hear what you learned.

—[Name]
```

---

### Format 7: The Interview/Q&A

**Best for:** Leveraging external expertise, content variety
**Effort:** Medium (plus interview time)
**Personality:** Moderate

**Structure:**
```
SUBJECT: [Expert name] on [specific topic/insight]

1. INTRO
   - Who this person is (brief)
   - Why you talked to them
   - One surprising thing they said

2. CONTEXT QUESTION
   - Set up their expertise
   - Current role/project

3. MEATY QUESTIONS (3-5)
   - Tactical, specific questions
   - Follow-ups where interesting
   - Pull quotes for emphasis

4. RAPID FIRE (optional)
   - Quick personal questions
   - Builds human connection

5. WRAP
   - Where to find them
   - Key takeaway summary
```

---

### Format 8: The Contrarian

**Best for:** Cutting through noise, sparking engagement
**Effort:** Medium-High
**Personality:** High

**Structure:**
```
SUBJECT: [Common belief] is wrong

1. THE CONVENTIONAL WISDOM
   - State what everyone believes
   - Why it seems logical

2. THE PROBLEM
   - Where this breaks down
   - Evidence it doesn't work

3. THE ALTERNATIVE
   - Your contrarian view
   - Why this works better

4. THE PROOF
   - Examples, data, experience
   - Address obvious objections

5. THE INVITATION
   - Acknowledge you might be wrong
   - Ask for counterarguments
```

**Example:**
```
SUBJECT: Stop A/B testing your headlines

I know. Heresy.

**THE CONVENTIONAL WISDOM:**
Test everything. Headlines, CTAs, button colors. Data beats opinions.

**THE PROBLEM:**
Most A/B tests don't have enough traffic to reach significance.
You're making decisions on statistical noise.

Here's the math:
To detect a 10% improvement at 95% confidence, you need ~3,000 conversions. Per variant.

Most landing pages? 50-100 conversions per month.
That "winning" headline? Probably random chance.

**THE ALTERNATIVE:**
Instead of testing small changes, make big bets.

Don't test "Free Trial" vs "Start Free Trial."
Test completely different value propositions.
Test different audiences.
Test different offers.

Big swings = real signal. Small tweaks = noise.

**THE PROOF:**
We stopped micro-testing last year. Started running 3-4 radically different pages.
Found winners 3x faster. Conversion improvements 2-5x bigger than headline tests ever produced.

**YOUR TURN:**
Am I wrong? If you've seen micro-testing work, I want to hear about it.
Reply with your best A/B test win.

—[Name]
```

---

### Format 9: The Product/Update

**Best for:** Driving adoption, announcing changes
**Effort:** Low-Medium
**Personality:** Moderate

**Structure:**
```
SUBJECT: [New thing]: [What it does for them]

1. THE NEWS (1-2 sentences)
   - What's new
   - Available when/to whom

2. THE PROBLEM IT SOLVES
   - Why this matters
   - Pain point addressed

3. HOW IT WORKS
   - Brief walkthrough
   - Visual if possible

4. QUICK START
   - Simplest way to try it
   - One action to take

5. WHAT'S NEXT
   - Roadmap tease (optional)
   - Feedback request
```

---

## Newsletter Strategy Framework

### Frequency Guidelines

| Frequency | Best For | Risk |
|-----------|----------|------|
| Daily | News, curated content, devoted audience | Burnout, unsubscribes |
| 2-3x/week | Active communities, high-value content | Requires content volume |
| Weekly | Most newsletters | Balance of presence and patience |
| Bi-weekly | Deep content, busy audiences | May lose momentum |
| Monthly | Long-form, premium content | Easy to forget |

**Rule:** Better to be consistent at lower frequency than inconsistent at higher.

### Subject Line Patterns

**Curiosity:**
- "The [thing] nobody's talking about"
- "I was wrong about [topic]"
- "What happened when we [action]"

**Specificity:**
- "[Number] ways to [outcome]"
- "The [timeframe] guide to [topic]"
- "How [company] achieved [result]"

**Direct value:**
- "How to [achieve outcome]"
- "[Problem]? Try this"
- "The fix for [common issue]"

**Personal:**
- "Quick question"
- "Thoughts on [topic]"
- "Can I get your take?"

### Engagement Tactics

**Open rate boosters:**
- Personalize subject line (test [First Name] vs. without)
- Send at consistent time (build habit)
- Preview text that complements (not repeats) subject

**Click rate boosters:**
- Fewer links = higher CTR per link
- Describe what they'll get, not just "read more"
- Use buttons for primary CTA

**Reply rate boosters:**
- Ask specific questions
- Share something vulnerable
- Respond to every reply (builds expectation)

---

## Output Format

### Newsletter Draft

```
═══════════════════════════════════════════════════════════════
NEWSLETTER: [Name] - Issue #[XX]
═══════════════════════════════════════════════════════════════

FORMAT: [Format type from the 9]
GOAL: [What readers should do]
AUDIENCE: [Who this is for]

───────────────────────────────────────────────────────────────
SUBJECT LINE OPTIONS
───────────────────────────────────────────────────────────────

Option A: [Subject line]
Option B: [Subject line]
Option C: [Subject line]

PREVIEW TEXT: [Preview text]

───────────────────────────────────────────────────────────────
NEWSLETTER BODY
───────────────────────────────────────────────────────────────

[Full newsletter content]

───────────────────────────────────────────────────────────────
IMPLEMENTATION NOTES
───────────────────────────────────────────────────────────────

Links needed:
• [Link 1 description] → [URL or placeholder]
• [Link 2 description] → [URL or placeholder]

Images needed:
• [Image description]

Personalization:
• [Variables to include]

Send timing recommendation: [Day/Time with rationale]

───────────────────────────────────────────────────────────────
A/B TEST SUGGESTION
───────────────────────────────────────────────────────────────

Test: [What to test]
Hypothesis: [Expected outcome]
```

---

## Content Repurposing for Newsletters

### Blog Post → Newsletter

| Blog Element | Newsletter Treatment |
|--------------|---------------------|
| Full article | Extract 3 key insights + link to full |
| How-to guide | Feature one step in depth + link |
| List post | Highlight best item + tease others |
| Case study | Tell the story, results as hook |

### Social Content → Newsletter

- Thread → Expanded with examples
- Viral post → Behind-the-scenes of why it worked
- Poll results → Analysis and implications

### Customer Conversations → Newsletter

- Common questions → Educational content
- Success stories → Story format
- Objections → Myth-busting content

---

## Limitations

**I can help with:**
- Writing newsletter content in any format
- Subject line and preview text options
- Content structure and flow
- Repurposing existing content
- Strategy recommendations

**I cannot provide:**
- Send time optimization (need your data)
- Deliverability troubleshooting
- ESP-specific implementation
- Actual performance predictions
- Design/HTML templates

**For complete newsletter success, also need:**
- Email service provider
- Consistent content calendar
- Performance tracking
- List hygiene practices
- Reply management system

---

## Quality Checklist

Before sending:
- [ ] Subject line is compelling (would YOU open this?)
- [ ] Preview text adds value, doesn't repeat subject
- [ ] Opening line hooks immediately
- [ ] Value is delivered early
- [ ] One clear CTA (or intentionally none)
- [ ] Tone matches brand voice
- [ ] Length is appropriate for format
- [ ] All links work
- [ ] Proofread for errors
- [ ] Mobile preview checked
