# How to Use: Newsletter

## Quick Start

Tell me what you want to communicate and I'll create newsletter content in the right format.

## Minimum Input

```
Newsletter purpose: [What's it about]
Audience: [Who reads it]
Goal: [What should they do after reading]
Content to include: [Topics, links, ideas]
```

## Best Results Input

```
Newsletter: [Name]
Frequency: [Daily/Weekly/etc.]
Audience: [Who and what they care about]

THIS ISSUE:
- Main topic/theme: [What's this issue about]
- Content to include: [Links, topics, ideas]
- Goal: [What should readers do]

VOICE:
- Tone: [Professional/Casual/Playful/etc.]
- Personality level: [Low/Medium/High]
- Example newsletters I like: [Names or links]

FORMAT PREFERENCE:
- Preferred format: [Curator/Teacher/Storyteller/etc.]
- Length: [Short/Medium/Long]
- Sections: [Any recurring sections]
```

## The 9 Formats

| Format | Best For | Effort |
|--------|----------|--------|
| **Curator** | Busy audiences, filtered info | Medium |
| **Teacher** | Skill-building, how-to | High |
| **Storyteller** | Deep connection, brand affinity | High |
| **Roundup** | Consistent value, easy to produce | Low |
| **Analyst** | Data-driven audiences | High |
| **Behind-the-Scenes** | Trust building, transparency | Medium |
| **Interview/Q&A** | External expertise | Medium |
| **Contrarian** | Cutting through noise | Medium-High |
| **Product/Update** | Driving adoption, announcements | Low-Medium |

## Example Prompts

**Weekly roundup:**
> "Create this week's newsletter. Include: [link 1], [link 2], one tip about Google Ads, and mention our new feature."

**Educational content:**
> "Write a Teacher-format newsletter about why most A/B tests are statistically invalid. Include practical advice."

**Story-driven:**
> "Turn this customer success story into a Storyteller newsletter: [details about the customer]"

**Content repurposing:**
> "Turn this blog post into a newsletter: [link or paste content]"

## Output You'll Get

1. **Subject Line Options** (3 choices with different angles)
2. **Preview Text** (complements subject)
3. **Full Newsletter Body** (in chosen format)
4. **Links/Images Needed** (implementation checklist)
5. **Send Timing Recommendation**
6. **A/B Test Suggestion** (what to test)

## Tips

- Pick ONE format per issue—don't mix
- Curator format is easiest to sustain long-term
- Storyteller format builds the strongest connection but requires the most effort
- Consistency in format builds reader expectations
- Always include a clear CTA (even if it's just "reply")
