# How to Use This Skill

Hey Claude—I just added the "meta-ads-audience-auditor" skill. Can you audit my Meta Ads audiences and tell me what's wrong?

## Example Invocations

**Example 1: Full Audience Audit**
Hey Claude—I just added the "meta-ads-audience-auditor" skill. Here's my Meta Ads performance data [paste/screenshot]. I have 8 ad sets and my ROAS has been declining. What's wrong with my audiences?

**Example 2: Saturation Check**
Hey Claude—I just added the "meta-ads-audience-auditor" skill. My CPMs have increased 40% in the last month. Here's my audience data [paste]. Am I hitting saturation? What do I do?

**Example 3: Overlap Analysis**
Hey Claude—I just added the "meta-ads-audience-auditor" skill. I think my audiences might be overlapping and competing with each other. Here's my targeting setup [paste]. Can you identify overlap issues?

**Example 4: Lookalike Strategy**
Hey Claude—I just added the "meta-ads-audience-auditor" skill. I'm using 5% lookalikes but they're not performing. Here's my current setup [paste]. How should I restructure my lookalikes?

**Example 5: Custom Audience Review**
Hey Claude—I just added the "meta-ads-audience-auditor" skill. What custom audiences should I create for my [business type]? Here's my current website traffic and customer data situation [describe].

**Example 6: Campaign Structure**
Hey Claude—I just added the "meta-ads-audience-auditor" skill. Is my campaign structure right? I have [describe structure]. Here's the performance data [paste]. Should I reorganize?

## What to Provide

**Required:**
- Audience names and targeting definitions
- Performance metrics (spend, CPM, results, CPA/ROAS)
- Frequency data

**Strongly Recommended:**
- Audience sizes
- Campaign objectives
- How long audiences have been running
- Any overlap data from Meta

**Optional:**
- Historical performance trends
- Custom audience match rates
- Lookalike configurations
- Exclusion setup

## How to Export Data from Meta Ads Manager

1. Go to Ads Manager → Campaigns/Ad Sets
2. Select date range (30 days minimum recommended)
3. Customize columns to include: Reach, Frequency, CPM, Results, Cost per Result
4. Export or screenshot the data
5. Include the targeting details for each ad set

## What You'll Get

1. **Audience Health Score** - Overall grade across 6 dimensions
2. **Saturation Analysis** - Which audiences are exhausted
3. **Overlap Report** - Where you're competing with yourself
4. **Quality Assessment** - Is targeting precise enough?
5. **Custom Audience Recommendations** - What to create/improve
6. **Lookalike Optimization** - Better seed audiences and sizes
7. **Budget Reallocation** - Where to shift spend
8. **Implementation Checklist** - Prioritized action items

## Pro Tips

- Export at least 30 days of data for meaningful patterns
- Include frequency data—it's the #1 saturation signal
- Check Meta's Audience Overlap tool and share the results if possible
- Tell me your business type—benchmarks vary significantly
- Share what audiences you've tested before and paused
- Include your target CPA/ROAS so I can assess performance properly
