---
name: landing-page-auditor
description: Analyzes landing pages for conversion optimization issues. Triggers when user shares a landing page URL, screenshot, or asks "why isn't my page converting?" Evaluates message match, value proposition clarity, CTA effectiveness, trust signals, friction points, and visual hierarchy. Provides prioritized fixes with expected conversion impact.
---

# Landing Page Auditor

Turn underperforming landing pages into conversion machines.

## Core Philosophy

**Every element either helps conversion or hurts it.** There's no neutral. A landing page is a persuasion sequence—each section must earn the visitor's continued attention and move them toward action.

**The Goal:** Identify exactly why visitors aren't converting and what to fix first.

**The Principle:** Systematic evaluation of the 7 conversion pillars—Clarity, Relevance, Value, Trust, Urgency, Friction, and Design.

---

## Required Context

### Must Have

**1. Landing Page Access**
One of:
- Live URL (preferred)
- Screenshots (full page, above-the-fold, and mobile)
- Copy document with layout description

**2. Page Purpose**
- Primary conversion goal (signup, purchase, download, demo request, etc.)
- Target audience (who is this page for?)

### Strongly Recommended

**3. Traffic Source Context**
- Where visitors come from (paid ads, organic, email, social)
- Ad copy or email that drives traffic (for message match analysis)
- Keywords or targeting used

**4. Current Performance**
- Conversion rate (if known)
- Bounce rate
- Time on page
- Traffic volume

### Nice to Have

- Heatmaps or scroll depth data
- Form analytics (if applicable)
- User recordings or session replays
- A/B test history
- Competitor landing pages for comparison

---

## Analysis Framework

### The 7 Conversion Pillars

| Pillar | Question | Weight |
|--------|----------|--------|
| **Clarity** | Do visitors instantly understand what this is? | Critical |
| **Relevance** | Does it match what brought them here? | Critical |
| **Value** | Is the benefit worth the ask? | Critical |
| **Trust** | Do visitors believe the claims? | High |
| **Urgency** | Why should they act now? | Medium |
| **Friction** | What makes action difficult? | High |
| **Design** | Does visual hierarchy guide to CTA? | Medium |

---

### Pillar 1: Clarity Audit

**The 5-Second Test:** If a stranger glanced at this page for 5 seconds, could they answer:
- What is this?
- Who is it for?
- What do I do next?

**Evaluation Criteria:**

| Element | Check | Score |
|---------|-------|-------|
| Headline | States clear outcome or benefit | 0-10 |
| Subheadline | Clarifies how/what | 0-10 |
| Hero Section | Single focus, no competing messages | 0-10 |
| CTA | Action is obvious and specific | 0-10 |
| Visual | Supports message, not decorative | 0-10 |

**Common Clarity Killers:**
- Clever/vague headlines that require thinking
- Multiple value propositions competing for attention
- Industry jargon or technical terms
- Buried or unclear CTA
- Hero image that doesn't reinforce message

**Clarity Score:** ___ / 50

---

### Pillar 2: Relevance Audit (Message Match)

**The Promise-Delivery Test:** Does the page deliver what the traffic source promised?

**For Paid Ads:**

| Ad Element | Landing Page Match | Score |
|------------|-------------------|-------|
| Ad headline | Reflected in page headline | 0-10 |
| Ad offer | Prominently displayed | 0-10 |
| Ad keywords | Present in page copy | 0-10 |
| Ad imagery | Consistent visual style | 0-10 |
| Audience targeting | Language matches audience | 0-10 |

**Message Match Scoring:**

| Score | Assessment | Impact |
|-------|------------|--------|
| 40-50 | Excellent match | Baseline conversion |
| 30-39 | Good match | ~10-15% conversion loss |
| 20-29 | Weak match | ~25-40% conversion loss |
| <20 | Mismatch | ~50%+ conversion loss |

**Common Relevance Killers:**
- Generic landing page for specific ad
- Headline doesn't echo ad promise
- Offer mentioned in ad is buried or missing
- Different tone/style than traffic source
- Audience mismatch (B2B ad to B2C page)

**Relevance Score:** ___ / 50

---

### Pillar 3: Value Proposition Audit

**The "So What?" Test:** Does every claim pass the "so what?" challenge?

**Value Hierarchy Check:**

| Level | Element | Present? | Clear? |
|-------|---------|----------|--------|
| 1 | Primary benefit (outcome) | Y/N | Y/N |
| 2 | Supporting benefits (features→benefits) | Y/N | Y/N |
| 3 | Differentiation (why you vs others) | Y/N | Y/N |
| 4 | Proof (evidence it works) | Y/N | Y/N |

**Value Proposition Framework:**
```
[End Result] + [Time Period] + [Address Objection]

Example: "Get 50% more leads in 30 days—without increasing ad spend"
```

**Evaluation Criteria:**

| Element | Check | Score |
|---------|-------|-------|
| Outcome Focus | Benefits over features | 0-10 |
| Specificity | Concrete vs vague claims | 0-10 |
| Differentiation | Clear reason to choose this | 0-10 |
| Believability | Claims feel achievable | 0-10 |
| Desire Creation | Makes visitor want this | 0-10 |

**Common Value Killers:**
- Feature lists without benefit translation
- Vague claims ("best-in-class," "innovative")
- Missing differentiation from alternatives
- No quantification of value
- Benefit buried below the fold

**Value Score:** ___ / 50

---

### Pillar 4: Trust Audit

**The Skeptic Test:** Would a cynical first-time visitor believe these claims?

**Trust Elements Inventory:**

| Trust Signal | Present? | Quality | Placement |
|--------------|----------|---------|-----------|
| Customer logos | Y/N | High/Med/Low | Above/Below fold |
| Testimonials | Y/N | High/Med/Low | Above/Below fold |
| Case studies | Y/N | High/Med/Low | Above/Below fold |
| Reviews/ratings | Y/N | High/Med/Low | Above/Below fold |
| Security badges | Y/N | High/Med/Low | Above/Below fold |
| Media mentions | Y/N | High/Med/Low | Above/Below fold |
| Certifications | Y/N | High/Med/Low | Above/Below fold |
| Data/statistics | Y/N | High/Med/Low | Above/Below fold |
| Guarantees | Y/N | High/Med/Low | Above/Below fold |

**Trust Signal Quality Assessment:**

| Quality | Characteristics |
|---------|-----------------|
| High | Specific, verifiable, relevant, recognized |
| Medium | Present but generic or less recognizable |
| Low | Vague, unverifiable, or irrelevant |

**Testimonial Quality Check:**
- [ ] Real names and photos
- [ ] Specific results/outcomes mentioned
- [ ] Relevant to target audience
- [ ] Addresses common objections
- [ ] Verifiable (company, title, LinkedIn)

**Trust Score:** ___ / 50

---

### Pillar 5: Urgency Audit

**The "Later" Test:** Is there any reason to act now vs. bookmark for later?

**Urgency Types:**

| Type | Example | Effectiveness |
|------|---------|---------------|
| Real scarcity | "Only 3 spots left" | High (if true) |
| Deadline | "Offer ends Friday" | High |
| Price urgency | "Price increases next month" | Medium-High |
| Bonus urgency | "Bonus expires in 24 hours" | Medium |
| Implied urgency | "Start seeing results today" | Low-Medium |
| No urgency | Generic evergreen page | Low |

**Urgency Evaluation:**

| Element | Check | Score |
|---------|-------|-------|
| Urgency Present | Any time-sensitivity? | 0-10 |
| Authenticity | Is it believable/real? | 0-10 |
| Visibility | Is it prominent? | 0-10 |
| Consequence | Clear cost of waiting? | 0-10 |
| Ethical | Not manipulative/fake? | 0-10 |

**Urgency Score:** ___ / 50

---

### Pillar 6: Friction Audit

**The Lazy User Test:** How easy is it to complete the desired action?

**Form Friction Analysis:**

| Factor | Current State | Friction Level |
|--------|---------------|----------------|
| Number of fields | [X] fields | Low (<4) / Med (4-7) / High (>7) |
| Required vs optional | [X] required | Count them |
| Field types | [List them] | Dropdowns vs text vs phone |
| Multi-step? | Y/N | Added friction if poorly designed |
| Error handling | [Assessment] | Clear, inline, helpful? |

**Field-by-Field Friction:**

| Field | Necessary? | Friction | Recommendation |
|-------|------------|----------|----------------|
| Email | Yes | Low | Keep |
| Phone | Maybe | High | Make optional or remove |
| Company size | Maybe | Medium | Dropdown if needed |
| Message | Rarely | High | Remove or make optional |

**Page-Level Friction:**

| Element | Check | Friction Added |
|---------|-------|----------------|
| Navigation | Visible? | High if yes (exit points) |
| Footer links | Distracting? | Medium if prominent |
| Multiple CTAs | Competing? | High if conflicting actions |
| Pop-ups | Interrupting? | High if poorly timed |
| Load time | Slow? | Critical if >3 seconds |
| Mobile | Optimized? | Critical if not |

**Friction Score:** ___ / 50 (Inverted—higher = less friction)

---

### Pillar 7: Design & Visual Hierarchy Audit

**The Squint Test:** When squinted at, does the page's visual hierarchy guide toward CTA?

**Visual Hierarchy Check:**

| Element | Assessment | Score |
|---------|------------|-------|
| CTA visibility | Stands out immediately | 0-10 |
| Whitespace | Adequate breathing room | 0-10 |
| Content flow | Natural eye path to CTA | 0-10 |
| Contrast | Key elements pop | 0-10 |
| Mobile design | Responsive, thumb-friendly | 0-10 |

**Design Red Flags:**
- [ ] CTA below the fold on mobile
- [ ] CTA color doesn't contrast with page
- [ ] Multiple visual focal points competing
- [ ] Dense text blocks without breaks
- [ ] Slow-loading images or animations
- [ ] Horizontal scrolling required
- [ ] Text over busy images (unreadable)
- [ ] Inconsistent styling/fonts

**Design Score:** ___ / 50

---

## Output Format

### Executive Summary

```
LANDING PAGE HEALTH SCORE: XX/100 [GRADE]

Page: [URL or Name]
Goal: [Primary conversion action]
Traffic Source: [Where visitors come from]

CRITICAL ISSUES: X found
HIGH-PRIORITY FIXES: X identified
ESTIMATED CONVERSION LIFT: +XX-XX% (if fixed)
```

**Grade Scale:**

| Score | Grade | Assessment |
|-------|-------|------------|
| 85-100 | A | High-performing, minor optimizations |
| 70-84 | B | Good foundation, clear improvements available |
| 55-69 | C | Significant issues hurting conversion |
| 40-54 | D | Major problems, needs overhaul |
| <40 | F | Fundamentally broken, rebuild recommended |

---

### Pillar Scores Breakdown

```
CLARITY:      ██████████░░░░░ 38/50
RELEVANCE:    ████████████░░░ 42/50
VALUE:        ██████░░░░░░░░░ 28/50  ⚠️ WEAK
TRUST:        ████████████░░░ 44/50
URGENCY:      ████░░░░░░░░░░░ 18/50  ⚠️ WEAK
FRICTION:     ██████████████░ 46/50
DESIGN:       ████████████░░░ 40/50

OVERALL:      256/350 = 73/100 (B)
```

---

### Critical Issues (Fix Immediately)

**Issue 1: [Title]**
- **Pillar:** [Which pillar]
- **Problem:** [Specific description]
- **Evidence:** [What I observed]
- **Impact:** Estimated XX% conversion loss
- **Fix:** [Specific recommendation]
- **Priority:** CRITICAL

---

**Issue 2: [Title]**

[Same format]

---

### High-Priority Improvements

**Improvement 1: [Title]**
- **Pillar:** [Which pillar]
- **Current:** [What exists now]
- **Recommended:** [What it should be]
- **Expected Impact:** +X-X% conversion lift
- **Effort:** Low / Medium / High
- **Priority:** HIGH

---

### Quick Wins (Low Effort, Good Impact)

| Fix | Pillar | Effort | Impact | Do This |
|-----|--------|--------|--------|---------|
| [Fix 1] | [Pillar] | Low | Medium | [Action] |
| [Fix 2] | [Pillar] | Low | High | [Action] |
| [Fix 3] | [Pillar] | Low | Medium | [Action] |

---

### Detailed Analysis by Section

**Above the Fold:**
- Headline: [Assessment]
- Subheadline: [Assessment]
- Hero Image/Video: [Assessment]
- Primary CTA: [Assessment]
- Message Match: [Assessment]

**Body Content:**
- Value Proposition: [Assessment]
- Benefits Communication: [Assessment]
- Feature Presentation: [Assessment]
- Content Flow: [Assessment]

**Trust Section:**
- Social Proof: [Assessment]
- Testimonials: [Assessment]
- Logos/Badges: [Assessment]
- Guarantees: [Assessment]

**Conversion Section:**
- Form/CTA: [Assessment]
- Friction Points: [Assessment]
- Objection Handling: [Assessment]
- Urgency Elements: [Assessment]

---

### Rewrite Recommendations

**Current Headline:**
> "[Current headline text]"

**Recommended Headline:**
> "[Improved headline with rationale]"

**Why:** [Explanation of improvement]

---

**Current CTA:**
> "[Current CTA text]"

**Recommended CTA:**
> "[Improved CTA with rationale]"

**Why:** [Explanation of improvement]

---

### A/B Test Recommendations

| Test | Hypothesis | Expected Lift | Confidence |
|------|------------|---------------|------------|
| [Test 1] | If we [change], then [outcome] because [reason] | +X-X% | High/Med/Low |
| [Test 2] | If we [change], then [outcome] because [reason] | +X-X% | High/Med/Low |
| [Test 3] | If we [change], then [outcome] because [reason] | +X-X% | High/Med/Low |

**Recommended Test Priority:**
1. [Test name] - Highest impact, easiest to implement
2. [Test name] - Good impact, medium effort
3. [Test name] - Worth testing after basics fixed

---

### Competitor Comparison (if provided)

| Element | Your Page | Competitor A | Winner |
|---------|-----------|--------------|--------|
| Headline clarity | X/10 | X/10 | [Who] |
| Value proposition | X/10 | X/10 | [Who] |
| Trust signals | X/10 | X/10 | [Who] |
| CTA strength | X/10 | X/10 | [Who] |
| Form friction | X/10 | X/10 | [Who] |

**Key Competitive Gaps:**
- [Gap 1 and recommendation]
- [Gap 2 and recommendation]

---

### Implementation Roadmap

**Week 1 - Critical Fixes:**
- [ ] [Fix 1 - specific action]
- [ ] [Fix 2 - specific action]
- [ ] [Fix 3 - specific action]

**Week 2 - High Priority:**
- [ ] [Improvement 1]
- [ ] [Improvement 2]
- [ ] Set up A/B test for [element]

**Week 3-4 - Optimization:**
- [ ] Launch A/B test
- [ ] Implement remaining improvements
- [ ] Monitor conversion lift

**Success Metrics:**
- Primary: Conversion rate increase from X% to Y%
- Secondary: Bounce rate decrease
- Secondary: Time to conversion decrease

---

## Special Scenarios

### Scenario 1: E-commerce Product Page
**Additional Focus:**
- Product images (quality, angles, zoom)
- Price presentation and anchoring
- Shipping/return information visibility
- Add-to-cart prominence
- Cross-sells/upsells (help or hurt?)
- Reviews and ratings integration

### Scenario 2: SaaS Sign-up Page
**Additional Focus:**
- Free trial vs. paid positioning
- Pricing transparency
- Feature comparison clarity
- Integration/compatibility mentions
- Onboarding expectation setting
- Security/privacy for data concerns

### Scenario 3: Lead Generation Page
**Additional Focus:**
- Lead magnet value clarity
- Form length vs. lead quality trade-off
- Follow-up expectation setting
- Privacy/spam reassurance
- Qualification questions (if B2B)

### Scenario 4: Event/Webinar Registration
**Additional Focus:**
- Date/time prominence and timezone
- Speaker credibility
- Agenda/takeaways clarity
- Calendar integration
- Replay availability mention
- Social proof (registrant count)

---

## Limitations

**I can assess:**
- Visual design and hierarchy (from screenshots/URL)
- Copy effectiveness and clarity
- Trust signal presence and quality
- Obvious friction points
- Message match (if ad/email provided)
- Mobile responsiveness (if screenshot provided)

**I cannot assess:**
- Actual page load speed (use PageSpeed Insights)
- Real user behavior (need analytics/heatmaps)
- Technical functionality (forms, tracking)
- SEO factors (different analysis)
- Backend conversion tracking accuracy
- Statistical significance of changes

**For complete analysis, also provide:**
- Google Analytics / conversion data
- Heatmaps (Hotjar, Crazy Egg, etc.)
- Session recordings
- Form analytics
- A/B test history

---

## Quality Checklist

Before delivering audit:
- [ ] All 7 pillars evaluated with scores
- [ ] Critical issues clearly identified
- [ ] Fixes are specific and actionable
- [ ] Priority order is justified
- [ ] Expected impact estimated for each fix
- [ ] Rewrite suggestions provided for weak copy
- [ ] A/B test hypotheses are testable
- [ ] Implementation roadmap is realistic
- [ ] Limitations acknowledged
