# How to Use This Skill

Hey Claude—I just added the "landing-page-auditor" skill. Can you audit my landing page and tell me why it's not converting?

## Example Invocations

**Example 1: Full Audit with URL**
Hey Claude—I just added the "landing-page-auditor" skill. Here's my landing page: [URL]. Traffic comes from Google Ads with this ad copy: [paste ad]. Conversion rate is 2.1%. Give me a full audit with prioritized fixes.

**Example 2: Screenshot-Based Audit**
Hey Claude—I just added the "landing-page-auditor" skill. Here are screenshots of my landing page [attach images]. This is a SaaS free trial signup page targeting marketing managers. What's killing my conversions?

**Example 3: Message Match Check**
Hey Claude—I just added the "landing-page-auditor" skill. Here's my Facebook ad [paste/attach] and the landing page it goes to [URL]. Check if my message match is good and what to fix.

**Example 4: Quick CTA Review**
Hey Claude—I just added the "landing-page-auditor" skill. Just focus on my above-the-fold section and CTA. Is it clear and compelling? [URL or screenshot]

**Example 5: Competitor Comparison**
Hey Claude—I just added the "landing-page-auditor" skill. Here's my landing page [URL] and my competitor's page [URL]. What are they doing better that I should steal?

**Example 6: Form Friction Analysis**
Hey Claude—I just added the "landing-page-auditor" skill. My form has 8 fields and I think that's hurting conversions. Here's the page [URL]. Which fields should I remove?

## What to Provide

**Required:**
- Landing page URL, screenshot, or detailed description
- What action you want visitors to take (signup, buy, download, etc.)
- Who the target audience is

**Strongly Recommended:**
- Traffic source (ads, organic, email, etc.)
- Ad copy or email that drives traffic
- Current conversion rate

**Optional:**
- Bounce rate and time on page
- Heatmaps or scroll data
- Competitor pages for comparison
- Form analytics
- A/B test history

## What You'll Get

1. **Health Score** - Overall landing page grade (A-F) with 7-pillar breakdown
2. **Critical Issues** - Conversion killers that need immediate attention
3. **Prioritized Fixes** - Specific, actionable recommendations ranked by impact
4. **Rewrite Suggestions** - Better versions of headlines, CTAs, and copy
5. **A/B Test Ideas** - Hypotheses to test with expected lift
6. **Implementation Roadmap** - Week-by-week action plan

## Pro Tips

- Always share the traffic source—message match is often the #1 conversion killer
- Include mobile screenshots if you have them (50%+ traffic is mobile)
- Share any data you have—conversion rate, bounce rate, heatmaps make audits more accurate
- If you've done A/B tests before, share what you learned
- Multiple pages? Start with your highest-traffic page for biggest impact
