# How to Use This Skill

Hey Claude—I just added the "funnel-dropoff-diagnostician" skill. Can you analyze my funnel and tell me where I'm losing people?

## Example Invocations

**Example 1: Full Funnel Analysis**
Hey Claude—I just added the "funnel-dropoff-diagnostician" skill. Here's my e-commerce funnel data [paste]. I'm getting traffic but only 1.2% convert to purchase. Where are the biggest leaks?

**Example 2: Specific Step Analysis**
Hey Claude—I just added the "funnel-dropoff-diagnostician" skill. I'm losing 70% of users between add-to-cart and checkout complete. Here's the data [paste]. What's causing this and how do I fix it?

**Example 3: SaaS Funnel**
Hey Claude—I just added the "funnel-dropoff-diagnostician" skill. Here's my SaaS signup funnel: Landing (10,000) → Signup Start (800) → Signup Complete (400) → Activated (80). Is this normal? What should I fix first?

**Example 4: Mobile vs Desktop**
Hey Claude—I just added the "funnel-dropoff-diagnostician" skill. My mobile conversion rate is half of desktop. Here's the funnel data by device [paste]. Where exactly is mobile breaking?

**Example 5: Lead Gen Funnel**
Hey Claude—I just added the "funnel-dropoff-diagnostician" skill. My form starts at 500 users but only 50 submit. Here's my lead gen funnel [paste]. How do I reduce form abandonment?

**Example 6: Before/After Comparison**
Hey Claude—I just added the "funnel-dropoff-diagnostician" skill. We redesigned our checkout last month. Here's the funnel before and after [paste both]. Did the change help or hurt? Where?

## What to Provide

**Required:**
- Each step in your funnel with names
- User count at each step
- Conversion rate between steps (or I'll calculate)

**Strongly Recommended:**
- Funnel type (e-commerce, SaaS, lead gen)
- Device breakdown (mobile vs desktop)
- Traffic source breakdown
- Time period of data

**Optional:**
- Historical comparison data
- Exit page data
- Error rates or logs
- User feedback or survey data
- Heatmap observations

## How to Get Funnel Data

**Google Analytics 4:**
- Explore → Funnel exploration
- Set up your funnel steps
- Export or screenshot

**Mixpanel/Amplitude:**
- Funnels report
- Define conversion steps
- Export data

**Your Platform:**
- Checkout analytics
- User flow reports
- Conversion reports

## What You'll Get

1. **Funnel Visualization** - Visual map of your entire funnel
2. **Benchmark Comparison** - How each step compares to industry standards
3. **Drop-off Diagnosis** - Likely causes for each leak
4. **Priority Matrix** - Which fixes will have most impact
5. **Segment Analysis** - Mobile, traffic source, and other breakdowns
6. **Specific Fixes** - Actionable recommendations for each problem
7. **A/B Test Ideas** - What to test first

## Pro Tips

- Include absolute numbers, not just percentages—volume matters
- Segment by device—mobile often has hidden issues
- Segment by traffic source—quality varies significantly
- Share at least 30 days of data for reliable patterns
- Note any recent changes (redesigns, new features, offers)
- Tell me your target conversion rate if you have one
