---
name: email-sequence-builder
description: Designs strategic email sequences with timing, subject lines, and full copy. Triggers when user asks for email sequence, drip campaign, nurture flow, onboarding emails, or abandoned cart recovery. Builds sequences for welcome, nurture, re-engagement, cart abandonment, and post-purchase journeys. Outputs ready-to-implement emails with subject lines, preview text, and body copy.
---

# Email Sequence Builder

Turn subscribers into customers with strategic email sequences.

## Core Philosophy

**Email is a conversation, not a broadcast.** Every email should feel like a natural next step in an ongoing dialogue—relevant, timely, and valuable.

**The Goal:** Move subscribers through a journey with the right message at the right time.

**The Principle:** Sequence design follows psychology—build trust, demonstrate value, handle objections, then ask for action.

---

## Required Context

### Must Have

**1. Sequence Type**
What journey are you building?
- Welcome/Onboarding
- Lead Nurture
- Cart Abandonment
- Post-Purchase
- Re-Engagement
- Product Launch
- Event/Webinar
- Sales Outreach

**2. Audience**
- Who receives this sequence?
- What triggered their entry?
- What do they already know about you?

**3. Goal**
- Primary conversion action
- Success metric (purchase, upgrade, demo, etc.)

### Strongly Recommended

**4. Product/Offer Details**
- What you're selling/promoting
- Key benefits and features
- Pricing (if applicable)
- Common objections

**5. Voice/Tone**
- Brand voice guidelines
- Formal vs. casual
- Example emails you like

### Nice to Have

- Existing email performance data
- Competitor email examples
- Customer testimonials/quotes
- Specific content assets to link (blog posts, case studies)
- Segmentation available

---

## Sequence Types & Frameworks

### Type 1: Welcome Sequence (New Subscribers)

**Purpose:** Introduce brand, set expectations, deliver lead magnet, build relationship.

**Recommended Length:** 5-7 emails over 14-21 days

**Framework: The "Know, Like, Trust" Arc**

| Email | Day | Purpose | Focus |
|-------|-----|---------|-------|
| 1 | 0 | Deliver + Welcome | Give promised value, introduce brand |
| 2 | 1-2 | Quick Win | Actionable tip they can use today |
| 3 | 3-4 | Story | Your origin or customer success story |
| 4 | 5-7 | Value | Best content piece or resource |
| 5 | 8-10 | Social Proof | Customer results, testimonials |
| 6 | 12-14 | Soft CTA | Introduce product/service naturally |
| 7 | 18-21 | Direct CTA | Clear offer with urgency |

---

### Type 2: Lead Nurture Sequence (Marketing Qualified Leads)

**Purpose:** Educate, build trust, move toward sales conversation.

**Recommended Length:** 6-10 emails over 30-60 days

**Framework: The "Problem-Solution-Proof" Arc**

| Email | Day | Purpose | Focus |
|-------|-----|---------|-------|
| 1 | 0 | Problem Awareness | Agitate the pain point |
| 2 | 3 | Cost of Problem | What happens if unsolved? |
| 3 | 7 | Solution Introduction | How to solve (educate) |
| 4 | 10 | Your Approach | Why your method works |
| 5 | 14 | Case Study | Customer transformation story |
| 6 | 18 | Objection Handling | Address common concerns |
| 7 | 22 | Differentiation | Why you vs. alternatives |
| 8 | 26 | Offer Introduction | Your product/service pitch |
| 9 | 30 | Urgency + CTA | Deadline or scarcity element |
| 10 | 35 | Last Chance | Final follow-up |

---

### Type 3: Cart Abandonment Sequence

**Purpose:** Recover lost sales, address objections, create urgency.

**Recommended Length:** 3-4 emails over 3-7 days

**Framework: The "Remind-Reason-Urgency" Arc**

| Email | Timing | Purpose | Focus |
|-------|--------|---------|-------|
| 1 | 1 hour | Helpful Reminder | "Did you forget something?" |
| 2 | 24 hours | Address Objections | FAQ, reviews, guarantees |
| 3 | 48-72 hours | Incentive | Discount, free shipping, bonus |
| 4 | 5-7 days | Last Chance | Urgency, scarcity |

**Key Elements:**
- Product image from cart
- Clear CTA to return
- Customer reviews for products in cart
- FAQ/objection handlers
- Risk reducers (guarantees, easy returns)

---

### Type 4: Post-Purchase Sequence

**Purpose:** Reduce refunds, increase satisfaction, generate reviews, enable repeat purchase.

**Recommended Length:** 4-6 emails over 14-30 days

**Framework: The "Delight-Advocate-Expand" Arc**

| Email | Day | Purpose | Focus |
|-------|-----|---------|-------|
| 1 | 0 | Confirmation + Excitement | Thank you, what to expect |
| 2 | 2-3 | Onboarding | How to get started, quick wins |
| 3 | 7 | Check-in | How's it going? Support offer |
| 4 | 14 | Social Proof Request | Review/testimonial ask |
| 5 | 21 | Upsell/Cross-sell | Complementary product |
| 6 | 30 | Referral | Refer a friend program |

---

### Type 5: Re-Engagement Sequence (Inactive Subscribers)

**Purpose:** Wake up dormant subscribers, clean list, recover potential customers.

**Recommended Length:** 3-5 emails over 14-21 days

**Framework: The "Notice-Value-Goodbye" Arc**

| Email | Day | Purpose | Focus |
|-------|-----|---------|-------|
| 1 | 0 | We Miss You | Acknowledge absence, offer value |
| 2 | 5 | Best Stuff | Your most valuable content/offer |
| 3 | 10 | What Changed | New features, improvements |
| 4 | 15 | Special Offer | Exclusive comeback incentive |
| 5 | 21 | Goodbye | List cleaning warning, unsubscribe CTA |

---

### Type 6: SaaS Onboarding Sequence

**Purpose:** Activate users, drive product adoption, reduce churn, upgrade to paid.

**Recommended Length:** 7-10 emails over 14-30 days (trial period)

**Framework: The "Activate-Engage-Convert" Arc**

| Email | Timing | Purpose | Focus |
|-------|--------|---------|-------|
| 1 | Signup | Welcome | Login, first step, support |
| 2 | Day 1 | Quick Win | Easiest value-generating action |
| 3 | Day 2 | Core Feature | Key feature tutorial |
| 4 | Day 4 | Use Case | Specific workflow example |
| 5 | Day 7 | Progress Check | Usage celebration or help offer |
| 6 | Day 10 | Advanced Feature | Power user capability |
| 7 | Day 12 | Social Proof | Customer success story |
| 8 | Day 14* | Upgrade Prompt | Trial ending, conversion CTA |
| 9 | Day 15* | Urgency | Last day reminder |
| 10 | Post-trial | Win-back | Extended trial or discount offer |

*Adjust based on trial length

---

## Email Copy Framework

### Subject Line Formulas

**Curiosity:**
- "The [unexpected thing] about [topic]"
- "I was wrong about [topic]"
- "This is probably a mistake..."

**Benefit-Driven:**
- "How to [achieve result] in [timeframe]"
- "[Number] ways to [achieve result]"
- "The fastest way to [achieve result]"

**Urgency/Scarcity:**
- "[X] hours left to [claim offer]"
- "Last chance: [offer]"
- "Closing tonight"

**Personal:**
- "Quick question, [Name]"
- "Can I ask you something?"
- "Thoughts?"

**Social Proof:**
- "How [Customer] achieved [result]"
- "[Number] people can't be wrong"
- "See what [Name] said about [topic]"

**Pain Point:**
- "Tired of [problem]?"
- "Why [problem] keeps happening"
- "Stop doing [wrong thing]"

---

### Preview Text Strategy

**Purpose:** Extend the subject line, not repeat it.

**Formulas:**
- Subject: Question → Preview: Answer tease
- Subject: Statement → Preview: Supporting detail
- Subject: Curiosity → Preview: More intrigue
- Subject: Benefit → Preview: Proof point

**Examples:**

| Subject | Preview |
|---------|---------|
| "How to double your leads" | "Without increasing ad spend (here's how)" |
| "Quick question for you" | "It'll only take 30 seconds to answer" |
| "Your cart is waiting" | "Complete your order before items sell out" |

---

### Body Copy Structure

**The PASTOR Framework:**

| Element | Purpose | Example |
|---------|---------|---------|
| **P**roblem | Identify pain | "You're spending hours on [task]..." |
| **A**mplify | Make it worse | "And every day, it costs you..." |
| **S**tory | Share example | "That's exactly where [Customer] was..." |
| **T**estimony | Prove solution | "After using [Product], they..." |
| **O**ffer | Present solution | "Here's how you can do the same..." |
| **R**esponse | Call to action | "Click here to [action]" |

**The 1-2-3-1 Framework:**

| Element | Purpose |
|---------|---------|
| **1** Big Idea | Single main point |
| **2** Benefits | What they gain |
| **3** Proof Points | Why believe it |
| **1** CTA | Single action |

---

### CTA Best Practices

**Button Text (Action-Oriented):**
| Weak | Strong |
|------|--------|
| Submit | Get My Free Guide |
| Click Here | Start My Trial |
| Learn More | See How It Works |
| Buy Now | Add to Cart |

**CTA Placement:**
- One primary CTA per email
- Place at natural decision points
- Consider PS as secondary CTA
- Link early for scanners

---

## Output Format

### Sequence Overview

```
SEQUENCE TYPE: [Type]
AUDIENCE: [Who enters this sequence]
TRIGGER: [What initiates the sequence]
GOAL: [Primary conversion action]
LENGTH: [X] emails over [Y] days

SEQUENCE MAP:
Day 0:  Email 1 - [Purpose]
Day X:  Email 2 - [Purpose]
Day X:  Email 3 - [Purpose]
...
```

---

### Email Template

For each email in the sequence:

```
═══════════════════════════════════════════════════════════════
EMAIL [#]: [EMAIL NAME]
═══════════════════════════════════════════════════════════════

SEND: [Day X after trigger / Timing]
GOAL: [What this email should accomplish]
SEGMENT: [If conditional, who receives this]

───────────────────────────────────────────────────────────────
SUBJECT LINE OPTIONS:
───────────────────────────────────────────────────────────────

Option A: [Subject line]
Option B: [Subject line]
Option C: [Subject line]

PREVIEW TEXT: [Preview text that complements subject]

───────────────────────────────────────────────────────────────
EMAIL BODY:
───────────────────────────────────────────────────────────────

[Full email copy goes here]

[Greeting],

[Opening hook - first line is critical]

[Body content following chosen framework]

[CTA section with clear action]

[Sign-off],
[Name]

PS: [Optional postscript with secondary CTA or urgency]

───────────────────────────────────────────────────────────────
CTA: [Button text] → [Link destination]
───────────────────────────────────────────────────────────────

NOTES:
• [Implementation note]
• [Personalization opportunities]
• [Conditional logic if applicable]
```

---

### Sequence Calendar View

```
WEEK 1
├── Day 0: Email 1 - Welcome & Deliver
├── Day 2: Email 2 - Quick Win
└── Day 4: Email 3 - Story

WEEK 2
├── Day 7: Email 4 - Value Content
└── Day 10: Email 5 - Social Proof

WEEK 3
├── Day 14: Email 6 - Soft Offer
└── Day 18: Email 7 - Direct CTA
```

---

### Performance Prediction

| Email | Expected Open Rate | Expected Click Rate | Key Metric |
|-------|-------------------|---------------------|------------|
| Email 1 | XX-XX% | X-X% | Engagement baseline |
| Email 2 | XX-XX% | X-X% | [Specific metric] |
| ... | ... | ... | ... |

**Benchmarks by Sequence Type:**

| Type | Avg Open | Avg Click | Conversion |
|------|----------|-----------|------------|
| Welcome | 50-60% | 8-12% | 10-15% |
| Nurture | 20-30% | 2-4% | 3-5% |
| Cart Abandonment | 40-50% | 10-15% | 10-20% |
| Post-Purchase | 40-50% | 5-10% | 5-10% |
| Re-Engagement | 10-20% | 2-5% | 5-10% |

---

## Optimization Guidance

### Subject Line Testing Priority

| Test | Impact | Effort |
|------|--------|--------|
| Personalization (name) | Medium | Low |
| Emoji vs. no emoji | Medium | Low |
| Question vs. statement | High | Low |
| Length (short vs. long) | Medium | Low |
| Urgency language | High | Low |
| Number inclusion | Medium | Low |

### Timing Optimization

**Best Send Times (General):**
- B2B: Tuesday-Thursday, 9-11am local time
- B2C: Varies, test weekends
- Time zone: Send in recipient's local time

**Sequence Timing Principles:**
- First email: Immediately or within 1 hour
- Early sequence: More frequent (1-2 days apart)
- Later sequence: Space out (3-7 days apart)
- Urgency sequences: Compress timeline

### Deliverability Checklist

- [ ] Sender name is recognizable
- [ ] Reply-to is monitored inbox
- [ ] Unsubscribe link is clear
- [ ] No spam trigger words
- [ ] Text-to-image ratio is healthy
- [ ] Links are tested and working
- [ ] Personalization fallbacks set
- [ ] Mobile preview checked

---

## Special Scenarios

### Scenario 1: B2B Long Sales Cycle
**Adjustments:**
- Extend sequence to 60-90 days
- More educational content, less selling
- Include case studies and ROI data
- Consider account-based personalization
- Add sales team handoff triggers

### Scenario 2: Low-Priced Product
**Adjustments:**
- Shorter sequence (decision is quick)
- Focus on urgency and scarcity
- Emphasize social proof
- Cart abandonment critical
- Post-purchase focus on repeat

### Scenario 3: High-Touch Service
**Adjustments:**
- Goal is conversation, not transaction
- Personal tone, less templated
- Include video where possible
- Emphasize credibility and trust
- Multiple touchpoints before ask

### Scenario 4: E-commerce with Large Catalog
**Adjustments:**
- Dynamic product recommendations
- Browsing behavior triggers
- Category-specific sequences
- Heavy personalization
- Back-in-stock notifications

---

## Limitations

**I can provide:**
- Strategic sequence structure
- Email copy and subject lines
- Timing recommendations
- Best practice frameworks
- A/B test suggestions
- Personalization guidance

**I cannot provide:**
- ESP-specific implementation
- Technical automation setup
- Deliverability troubleshooting
- Design/HTML templates
- List segmentation execution
- Actual performance data

**For implementation, you'll also need:**
- Email service provider (ESP)
- Trigger/automation setup
- Segmentation logic configuration
- Design templates
- Tracking and analytics setup

---

## Quality Checklist

Before delivering sequence:
- [ ] Sequence type matches audience need
- [ ] Timing feels natural, not spammy
- [ ] Each email has single clear purpose
- [ ] Subject lines are varied and testable
- [ ] Preview text complements subjects
- [ ] Copy follows consistent voice
- [ ] CTAs are clear and single-focused
- [ ] Personalization opportunities noted
- [ ] Conditional logic identified
- [ ] Expected metrics provided
- [ ] Implementation notes included
