# How to Use This Skill

Hey Claude—I just added the "email-sequence-builder" skill. Can you build me an email sequence for [purpose]?

## Example Invocations

**Example 1: Welcome Sequence**
Hey Claude—I just added the "email-sequence-builder" skill. I need a welcome sequence for new newsletter subscribers. We're a B2B SaaS tool for project managers. Goal is to get them to start a free trial.

**Example 2: Cart Abandonment**
Hey Claude—I just added the "email-sequence-builder" skill. Build me a cart abandonment sequence for our e-commerce store. We sell premium coffee. Average order is $45. We can offer 10% off if needed.

**Example 3: SaaS Onboarding**
Hey Claude—I just added the "email-sequence-builder" skill. I need an onboarding email sequence for our 14-day free trial. Key activation metric is "create first project." Users who do that convert at 3x the rate.

**Example 4: Lead Nurture**
Hey Claude—I just added the "email-sequence-builder" skill. Create a nurture sequence for leads who downloaded our "Complete Guide to SEO" ebook. We want to move them toward booking a consultation call.

**Example 5: Re-Engagement**
Hey Claude—I just added the "email-sequence-builder" skill. I have 5,000 subscribers who haven't opened an email in 90 days. Build me a re-engagement sequence before I clean the list.

**Example 6: Post-Purchase**
Hey Claude—I just added the "email-sequence-builder" skill. I need post-purchase emails for customers who bought our online course. Goals: reduce refunds, get testimonials, and upsell to our coaching program.

**Example 7: Product Launch**
Hey Claude—I just added the "email-sequence-builder" skill. We're launching a new feature next month. Build me a launch sequence for existing customers to get them excited and using the new feature.

## What to Provide

**Required:**
- Sequence type (welcome, nurture, cart abandonment, etc.)
- Target audience (who enters this sequence?)
- Primary goal (what action do you want them to take?)

**Strongly Recommended:**
- Your product/service description
- Key benefits and differentiators
- Common objections your audience has
- Voice/tone preferences (formal, casual, funny, etc.)

**Optional:**
- Existing high-performing emails
- Customer testimonials/quotes to include
- Specific content pieces to link (blog posts, case studies)
- Any offers/discounts available
- Competitor examples you like
- Current email performance benchmarks

## What You'll Get

1. **Sequence Map** - Visual overview of all emails with timing
2. **Full Email Copy** - Ready-to-use email drafts
3. **Subject Line Options** - Multiple options to A/B test
4. **Preview Text** - Complementary preview text for each
5. **CTA Recommendations** - Button text and link destinations
6. **Timing Strategy** - When to send each email
7. **Optimization Tips** - What to test and improve

## Pro Tips

- Tell me about your audience's biggest pain point—I'll address it in the copy
- Share your brand voice (formal? fun? direct?)—consistency matters
- Include any constraints (can't offer discounts? only 3 emails allowed?)
- Share what's worked before—I'll build on winning elements
- Mention your ESP if relevant—some have specific limitations
- For B2B, share average sales cycle length
- For e-commerce, share average order value
