---
name: competitor-swot-analyzer
description: Performs deep competitive analysis to identify positioning opportunities. Triggers when user shares competitor websites, asks "how do I differentiate from X?", or wants competitive intelligence. Analyzes messaging, positioning, pricing, features, trust signals, and weaknesses. Outputs actionable insights for ad copy, landing pages, and go-to-market strategy.
---

# Competitor SWOT Analyzer

Turn competitor intelligence into your competitive advantage.

## Core Philosophy

**Competitors are free market research.** Every competitor has already tested messaging, pricing, and positioning with real customers. Learn from their successes and exploit their gaps.

**The Goal:** Understand competitors deeply enough to position against them—not just be different, but be *strategically* different.

**The Principle:** Competitive advantage comes from being better at what matters to customers, not just being different for difference's sake.

---

## Required Context

### Must Have

**1. Competitor Information**
At minimum:
- Competitor name(s)
- Website URL(s)
- Product/service category

**2. Your Context**
- Your product/service
- Your target audience
- Your current positioning (if any)

### Strongly Recommended

**3. Competitor Materials**
- Homepage screenshots or URL
- Pricing page
- Key landing pages
- Ad examples (Google Ads, social ads)
- Product screenshots or demo

**4. Market Context**
- Industry/vertical
- Target market (SMB, enterprise, consumer)
- Your key differentiators
- Win/loss data vs. this competitor (if available)

### Nice to Have

- Competitor reviews (G2, Capterra, Trustpilot, etc.)
- Sales call recordings where competitor mentioned
- Competitor content (blog posts, case studies)
- LinkedIn/career pages (hiring signals)
- Funding/company news

---

## Analysis Framework

### The 6 Pillars of Competitive Analysis

| Pillar | Focus | Weight |
|--------|-------|--------|
| **Positioning** | How they define themselves in the market | Critical |
| **Messaging** | What they say and how they say it | Critical |
| **Value Proposition** | Their promised benefits and outcomes | High |
| **Trust/Proof** | How they build credibility | High |
| **Pricing/Packaging** | How they capture value | Medium |
| **Weaknesses** | Gaps, complaints, vulnerabilities | Critical |

---

### Pillar 1: Positioning Analysis

**Core Positioning Questions:**

| Question | Finding |
|----------|---------|
| What category do they claim? | [e.g., "CRM", "Sales automation"] |
| Who is their stated audience? | [e.g., "SMBs", "Enterprise sales teams"] |
| What is their primary differentiator? | [e.g., "Easiest to use", "Most powerful"] |
| What is their positioning statement? | [Extracted or inferred] |

**Positioning Framework Extraction:**

```
For [target customer]
Who [has this problem/need]
[Product] is a [category]
That [key benefit/differentiator]
Unlike [competitors/alternatives]
We [unique difference]
```

**Positioning Strategy Type:**

| Strategy | Description | Example |
|----------|-------------|---------|
| Category Leader | Own the category definition | "The CRM for salespeople" |
| Challenger | Positioned against leader | "The Salesforce alternative" |
| Niche Specialist | Own a vertical or use case | "CRM for real estate agents" |
| Price Player | Cost leadership | "Enterprise CRM at SMB prices" |
| Innovation Leader | Newest/most advanced | "AI-powered CRM" |
| Experience Leader | Best UX/service | "CRM people actually enjoy using" |

**Competitive Positioning Map:**

```
                    HIGH PRICE
                        │
         Premium        │        Enterprise
         Niche          │        Full-suite
                        │
    ────────────────────┼─────────────────────
    SIMPLE              │              COMPLEX
                        │
         Budget         │        Mid-market
         Basic          │        Growing
                        │
                    LOW PRICE

    [Plot competitor and yourself on this map]
```

---

### Pillar 2: Messaging Analysis

**Headline/Tagline Extraction:**

| Location | Their Headline | Analysis |
|----------|----------------|----------|
| Homepage H1 | "[Headline]" | [What it communicates] |
| Homepage tagline | "[Tagline]" | [What it communicates] |
| Meta title | "[Title]" | [SEO positioning] |
| Ad headlines | "[Headlines]" | [Paid messaging angle] |

**Messaging Themes:**

| Theme | Presence | Prominence | Examples |
|-------|----------|------------|----------|
| Speed/Time savings | Y/N | High/Med/Low | [Specific claims] |
| Cost savings | Y/N | High/Med/Low | [Specific claims] |
| Ease of use | Y/N | High/Med/Low | [Specific claims] |
| Power/Features | Y/N | High/Med/Low | [Specific claims] |
| Results/ROI | Y/N | High/Med/Low | [Specific claims] |
| Support/Service | Y/N | High/Med/Low | [Specific claims] |
| Security/Compliance | Y/N | High/Med/Low | [Specific claims] |
| Integration | Y/N | High/Med/Low | [Specific claims] |

**Tone & Voice Assessment:**

| Attribute | Their Tone | Scale |
|-----------|------------|-------|
| Formal ↔ Casual | [Assessment] | 1-5 |
| Technical ↔ Simple | [Assessment] | 1-5 |
| Corporate ↔ Friendly | [Assessment] | 1-5 |
| Feature-focused ↔ Benefit-focused | [Assessment] | 1-5 |
| Serious ↔ Playful | [Assessment] | 1-5 |

**Key Claims Inventory:**

| Claim | Type | Proof Provided? |
|-------|------|-----------------|
| "[Claim 1]" | Quantified/Vague | Y/N |
| "[Claim 2]" | Quantified/Vague | Y/N |
| "[Claim 3]" | Quantified/Vague | Y/N |

---

### Pillar 3: Value Proposition Analysis

**Benefits Hierarchy:**

| Level | Their Benefits |
|-------|---------------|
| Primary (biggest promise) | [Benefit] |
| Secondary | [Benefit] |
| Secondary | [Benefit] |
| Tertiary | [Benefit] |

**Feature-to-Benefit Mapping:**

| Feature They Highlight | Implied Benefit | Who Cares |
|-----------------------|-----------------|-----------|
| [Feature 1] | [Benefit] | [Persona] |
| [Feature 2] | [Benefit] | [Persona] |
| [Feature 3] | [Benefit] | [Persona] |

**Outcome Promises:**

| Type | Their Promise |
|------|---------------|
| Time saved | [e.g., "Save 10 hours/week"] |
| Money saved/earned | [e.g., "2x your revenue"] |
| Problems solved | [e.g., "Never lose a deal again"] |
| Transformation | [e.g., "Become a sales machine"] |

**Value Proposition Strength:**

| Criterion | Score | Notes |
|-----------|-------|-------|
| Clarity | 1-10 | [Is it easy to understand?] |
| Specificity | 1-10 | [Are claims concrete?] |
| Credibility | 1-10 | [Is it believable?] |
| Differentiation | 1-10 | [Could a competitor say this?] |
| Desirability | 1-10 | [Do customers want this?] |

---

### Pillar 4: Trust & Proof Analysis

**Social Proof Inventory:**

| Trust Signal | Present? | Quality | Specifics |
|--------------|----------|---------|-----------|
| Customer logos | Y/N | High/Med/Low | [Notable names] |
| Customer count | Y/N | — | [Number] |
| Testimonials | Y/N | High/Med/Low | [Named/anonymous, specific/vague] |
| Case studies | Y/N | High/Med/Low | [Topics, results] |
| Reviews/ratings | Y/N | High/Med/Low | [Platforms, scores] |
| Media mentions | Y/N | High/Med/Low | [Publications] |
| Awards/recognition | Y/N | High/Med/Low | [Which awards] |
| Certifications | Y/N | High/Med/Low | [Which certs] |
| Data/research | Y/N | High/Med/Low | [Studies cited] |

**Authority Indicators:**

| Signal | Present? | Details |
|--------|----------|---------|
| Industry reports cited | Y/N | [Which ones] |
| Thought leadership | Y/N | [Blog, podcast, speaking] |
| Team credentials | Y/N | [Notable backgrounds] |
| Investor backing | Y/N | [Notable investors] |
| Partnership logos | Y/N | [Integration partners] |

**Risk Reducers:**

| Element | Present? | Details |
|---------|----------|---------|
| Money-back guarantee | Y/N | [Terms] |
| Free trial | Y/N | [Length, CC required?] |
| Freemium tier | Y/N | [What's included] |
| Demo availability | Y/N | [Live/recorded] |
| Security certifications | Y/N | [SOC2, GDPR, etc.] |
| SLA/uptime guarantee | Y/N | [Specifics] |

---

### Pillar 5: Pricing & Packaging Analysis

**Pricing Model:**

| Aspect | Their Approach |
|--------|---------------|
| Pricing visibility | Public/Sales-gated/Hidden |
| Model type | Per user/Flat rate/Usage/Tiered |
| Billing options | Monthly/Annual/Both |
| Discount for annual | [Percentage] |
| Starting price | $X/month |
| Enterprise pricing | [Approach] |

**Tier Analysis:**

| Tier | Price | Target User | Key Differentiator |
|------|-------|-------------|-------------------|
| [Tier 1] | $X | [Who] | [What's limited/included] |
| [Tier 2] | $X | [Who] | [What's limited/included] |
| [Tier 3] | $X | [Who] | [What's limited/included] |
| Enterprise | Custom | [Who] | [What's included] |

**Pricing Psychology Tactics:**

| Tactic | Used? | Example |
|--------|-------|---------|
| Anchoring (high-price option) | Y/N | [Details] |
| Decoy pricing | Y/N | [Details] |
| Feature gating | Y/N | [What's gated] |
| Usage limits | Y/N | [What's limited] |
| "Most popular" highlight | Y/N | [Which tier] |
| Price savings emphasis | Y/N | [How displayed] |

**Competitive Pricing Position:**

| Comparison | Relationship |
|------------|--------------|
| vs. You | More/Less/Similar |
| vs. Category average | Premium/Mid/Budget |
| Value perception | High-value/Fair/Overpriced |

---

### Pillar 6: Weaknesses Analysis

**Review Mining (G2, Capterra, Trustpilot, etc.):**

| Complaint Theme | Frequency | Sample Quote |
|-----------------|-----------|--------------|
| [Theme 1] | Common/Occasional/Rare | "[Quote]" |
| [Theme 2] | Common/Occasional/Rare | "[Quote]" |
| [Theme 3] | Common/Occasional/Rare | "[Quote]" |

**Common Weakness Categories:**

| Category | Evidence | Exploitability |
|----------|----------|----------------|
| Learning curve/complexity | [Evidence] | High/Med/Low |
| Missing features | [Evidence] | High/Med/Low |
| Price/value perception | [Evidence] | High/Med/Low |
| Customer support | [Evidence] | High/Med/Low |
| Performance/reliability | [Evidence] | High/Med/Low |
| Integration gaps | [Evidence] | High/Med/Low |
| Hidden costs | [Evidence] | High/Med/Low |

**Positioning Gaps:**

| Gap | Description | Opportunity |
|-----|-------------|-------------|
| Audience gap | [Who they don't serve well] | [How you could own this] |
| Use case gap | [What they don't solve] | [How you could own this] |
| Message gap | [What they don't emphasize] | [How you could own this] |
| Proof gap | [What they can't claim] | [How you could own this] |

**Strategic Vulnerabilities:**

| Vulnerability | Evidence | How to Exploit |
|---------------|----------|----------------|
| [Vulnerability 1] | [Evidence] | [Strategy] |
| [Vulnerability 2] | [Evidence] | [Strategy] |

---

## Output Format

### Executive Summary

```
COMPETITOR: [Name]
CATEGORY: [Category]
PRIMARY POSITIONING: [One-line description]

THEIR BIGGEST STRENGTH: [What they do best]
THEIR BIGGEST WEAKNESS: [Most exploitable gap]
YOUR BEST ANGLE AGAINST THEM: [Positioning strategy]
```

---

### SWOT Matrix

```
┌─────────────────────────────────────────────────────────────────┐
│ STRENGTHS                      │ WEAKNESSES                     │
│ (What they do well)            │ (Where they fall short)        │
│                                │                                │
│ • [Strength 1]                 │ • [Weakness 1]                 │
│ • [Strength 2]                 │ • [Weakness 2]                 │
│ • [Strength 3]                 │ • [Weakness 3]                 │
│ • [Strength 4]                 │ • [Weakness 4]                 │
├────────────────────────────────┼────────────────────────────────┤
│ OPPORTUNITIES                  │ THREATS                        │
│ (How you can win against them) │ (How they could hurt you)      │
│                                │                                │
│ • [Opportunity 1]              │ • [Threat 1]                   │
│ • [Opportunity 2]              │ • [Threat 2]                   │
│ • [Opportunity 3]              │ • [Threat 3]                   │
│ • [Opportunity 4]              │ • [Threat 4]                   │
└─────────────────────────────────────────────────────────────────┘
```

---

### Detailed Competitive Profile

#### Positioning Summary

**Their Positioning Statement:**
> "[Extracted or synthesized positioning statement]"

**Category Claim:** [What category they own/claim]
**Target Audience:** [Who they're targeting]
**Primary Differentiator:** [Their main claim to fame]
**Positioning Strategy:** [Leader/Challenger/Niche/Price/etc.]

---

#### Messaging Playbook

**Primary Messages They Lead With:**
1. [Message 1]
2. [Message 2]
3. [Message 3]

**Proof Points They Use:**
- [Proof point 1]
- [Proof point 2]
- [Proof point 3]

**Objections They Preemptively Address:**
- [Objection 1] → [Their response]
- [Objection 2] → [Their response]

---

#### Pricing Intelligence

**Pricing Summary:**
- Starting at: $X/month
- Mid-tier: $X/month
- Enterprise: [Custom/Quote]
- Pricing model: [Per user/Flat/Usage]

**Key Feature Gates:**
- [Feature] available only in [Tier]
- [Feature] available only in [Tier]

---

#### Trust Arsenal

**Strongest Trust Signals:**
1. [Signal with specific example]
2. [Signal with specific example]
3. [Signal with specific example]

**Missing Trust Signals:**
- [What they don't have that you could use]

---

### Competitive Battlecard

```
WHEN COMPETING AGAINST [COMPETITOR]:

SAY THIS:
✅ "[Angle 1 - what to emphasize]"
✅ "[Angle 2 - what to emphasize]"
✅ "[Angle 3 - what to emphasize]"

DON'T SAY THIS:
❌ "[What to avoid - plays to their strength]"
❌ "[What to avoid - not credible]"

THEIR LIKELY COUNTER:
"[What they'll say against you]"

YOUR RESPONSE:
"[How to handle their counter]"
```

---

### Strategic Recommendations

#### Differentiation Opportunities

**Opportunity 1: [Opportunity Name]**
- **Gap:** [What's missing or weak in competitor]
- **Strategy:** [How to position against it]
- **Message:** "[Draft messaging that exploits this]"
- **Proof needed:** [What you need to make this credible]

---

**Opportunity 2: [Opportunity Name]**
- **Gap:** [What's missing or weak in competitor]
- **Strategy:** [How to position against it]
- **Message:** "[Draft messaging that exploits this]"
- **Proof needed:** [What you need to make this credible]

---

#### Ad Copy Angles

**Google Ads Headlines Against [Competitor]:**
1. "[Headline targeting their weakness]"
2. "[Headline emphasizing your strength]"
3. "[Headline for comparison searches]"

**Google Ads Descriptions:**
1. "[Description that differentiates]"
2. "[Description with competitive proof point]"

**Facebook Ad Angles:**
1. [Angle] — "[Example hook]"
2. [Angle] — "[Example hook]"

---

#### Landing Page Elements

**For Competitor Comparison Page:**
- Headline: "[Recommended headline]"
- Key comparison points: [List features/benefits to compare]
- Trust signals to emphasize: [What proof to highlight]
- CTA: "[Recommended CTA]"

---

### Comparison Table Template

| Factor | You | [Competitor] | Winner |
|--------|-----|--------------|--------|
| [Factor 1] | [Your status] | [Their status] | You/Them/Tie |
| [Factor 2] | [Your status] | [Their status] | You/Them/Tie |
| [Factor 3] | [Your status] | [Their status] | You/Them/Tie |
| [Factor 4] | [Your status] | [Their status] | You/Them/Tie |
| [Factor 5] | [Your status] | [Their status] | You/Them/Tie |
| Price | [Your price] | [Their price] | You/Them/Tie |

---

## Special Scenarios

### Scenario 1: Analyzing Category Leader
**Focus On:**
- What are they NOT doing well (complacency gaps)?
- Who do they underserve (niche opportunities)?
- Where is their complexity a weakness?
- What messages are they NOT owning?

### Scenario 2: Analyzing New/Funded Competitor
**Focus On:**
- What's their growth trajectory?
- What's their unfair advantage (talent, tech, funding)?
- Where are they hiring (signals priorities)?
- What can you do before they get there?

### Scenario 3: Analyzing Price Competitor
**Focus On:**
- Why are they cheaper (cut corners, VC subsidized, efficient)?
- What do customers sacrifice for lower price?
- How do you justify your premium?
- Who values quality over price?

### Scenario 4: Multiple Competitors
**Focus On:**
- Common positioning patterns
- Category white space (what nobody owns)
- Messaging fatigue (what everyone says)
- Unique angle opportunities

---

## Limitations

**I can analyze:**
- Public positioning and messaging
- Pricing (if visible)
- Website content and structure
- Review sentiment and themes
- Social proof presence and quality
- Obvious feature differences

**I cannot provide:**
- Internal competitor data
- Traffic/revenue estimates (need tools like SimilarWeb)
- Feature-by-feature technical comparison (need product access)
- Real-time competitive monitoring
- Win/loss analysis (need your sales data)

**For complete competitive intelligence, supplement with:**
- Win/loss interviews with sales
- Customer switching interviews
- Competitive monitoring tools (Crayon, Klue)
- Product demos of competitor
- Sales call recordings

---

## Quality Checklist

Before delivering analysis:
- [ ] All 6 pillars analyzed
- [ ] SWOT matrix complete with specific items
- [ ] Positioning clearly articulated
- [ ] Messaging themes extracted
- [ ] Weaknesses supported by evidence
- [ ] Opportunities are actionable
- [ ] Battlecard language is specific
- [ ] Ad copy angles are usable
- [ ] Comparison factors are meaningful
- [ ] Limitations acknowledged
