# How to Use This Skill

Hey Claude—I just added the "competitor-swot-analyzer" skill. Can you analyze my competitor and help me figure out how to position against them?

## Example Invocations

**Example 1: Full Competitor Analysis**
Hey Claude—I just added the "competitor-swot-analyzer" skill. Here's my main competitor [URL]. We're both CRM tools for SMBs. Give me a full SWOT analysis with differentiation opportunities.

**Example 2: Messaging Analysis**
Hey Claude—I just added the "competitor-swot-analyzer" skill. I want to understand how [Competitor] positions themselves. Here's their homepage and pricing page [screenshots/URLs]. What messaging angles do they use that I should compete against or avoid?

**Example 3: Weakness Mining**
Hey Claude—I just added the "competitor-swot-analyzer" skill. What are [Competitor]'s biggest weaknesses based on their G2 reviews and website? Here's their profile [G2 URL] and website [URL].

**Example 4: Pricing Comparison**
Hey Claude—I just added the "competitor-swot-analyzer" skill. Here's [Competitor]'s pricing page [URL]. How should I position my pricing against theirs? I'm currently at $X/month.

**Example 5: Battlecard Creation**
Hey Claude—I just added the "competitor-swot-analyzer" skill. I need a sales battlecard for when we compete against [Competitor]. Here's their website [URL] and some reviews [URLs]. What should our sales team say?

**Example 6: Comparison Page Strategy**
Hey Claude—I just added the "competitor-swot-analyzer" skill. I'm creating a "[My Product] vs [Competitor]" landing page. Analyze them and tell me what comparison points will make us look best.

**Example 7: Multiple Competitors**
Hey Claude—I just added the "competitor-swot-analyzer" skill. I have 3 main competitors [URLs]. What positioning white space exists that none of them own?

## What to Provide

**Required:**
- Competitor name and website
- Your product/service category
- Your target audience

**Strongly Recommended:**
- Your current positioning/differentiators
- Competitor pricing page
- Competitor reviews (G2, Capterra, etc.)
- Example competitor ads (if available)

**Optional:**
- Win/loss reasons from sales
- Customer feedback mentioning competitor
- Competitor content (blog, case studies)
- Your own website for comparison

## What You'll Get

1. **SWOT Matrix** - Strengths, Weaknesses, Opportunities, Threats
2. **Positioning Analysis** - How they position and their strategy type
3. **Messaging Playbook** - Their key messages and proof points
4. **Weakness Report** - Exploitable gaps with evidence
5. **Battlecard** - What to say and not say when competing
6. **Ad Copy Angles** - Ready-to-use headlines and hooks
7. **Comparison Table** - Framework for vs. pages

## Pro Tips

- Share G2/Capterra reviews—the negative ones reveal exploitable weaknesses
- Include screenshots of their homepage above-the-fold and pricing page
- Mention your biggest strengths so I can find where they're weak on those
- If you've lost deals to them, share what reasons you heard
- For SaaS, check their LinkedIn jobs page—hiring signals strategic priorities
- Look at their recent press/funding announcements for context
