---
name: brand-voice
description: Defines and documents brand voice, tone, and personality. Triggers when user asks about "how should we sound?", "brand guidelines", "voice and tone", "writing style guide", "make our copy consistent", or "define our brand personality". Creates comprehensive voice documentation that ensures every piece of copy sounds authentically like the brand, not generic AI-speak.
---

# Brand Voice

Define how you sound. One file ensures every piece of copy matches your voice, not generic AI-speak.

## Core Philosophy

**Voice is what makes strangers recognize you.** Without a defined voice, every piece of content sounds like it could come from any company. With a defined voice, your audience recognizes you before they see your logo.

**The Goal:** Create a voice document so clear that anyone (human or AI) can write copy that sounds authentically like your brand.

**The Principle:** Voice comes from values. Tone adapts to context. Style is the execution.

---

## Required Context

### Must Have

**1. Brand Basics**
- Company/product name
- What you do (one sentence)
- Who you serve (primary audience)

**2. Values & Beliefs**
- What you stand for
- What you stand against
- What makes you different philosophically

**3. Existing Content**
- Examples of content you like (yours or others')
- Examples of content that feels wrong for you
- Any existing brand guidelines

### Strongly Recommended

**4. Audience Understanding**
- How sophisticated is your audience?
- How do they talk about their problems?
- What tone do they respond to?

**5. Competitive Context**
- How do competitors sound?
- What voice territory is crowded?
- What voice territory is available?

### Nice to Have

- Founder/team personality traits
- Origin story or brand narrative
- Customer testimonials (for their language)
- Internal culture documents
- Brands you admire (in any industry)

---

## The Voice Framework

### Three Layers of Brand Communication

```
┌─────────────────────────────────────────────────────┐
│                      VOICE                          │
│           (Permanent personality traits)            │
│         What you sound like ALL the time            │
├─────────────────────────────────────────────────────┤
│                       TONE                          │
│           (Contextual adjustments)                  │
│      How personality adapts to situations           │
├─────────────────────────────────────────────────────┤
│                      STYLE                          │
│           (Tactical execution)                      │
│     Grammar, formatting, word choices               │
└─────────────────────────────────────────────────────┘
```

**Voice** = Personality (stays constant)
**Tone** = Mood (changes by context)
**Style** = Rules (specific guidelines)

---

## Step 1: Voice Discovery

### The Brand Personality Exercise

**If your brand were a person at a party, how would they act?**

| Question | Answer |
|----------|--------|
| Are they the center of attention or observing from the side? | |
| Do they use big words or keep it simple? | |
| Are they cracking jokes or staying serious? | |
| Do they speak quickly or take their time? | |
| Are they formal or casual? | |
| Do they challenge ideas or agree easily? | |

### The Voice Attribute Spectrum

Rate your brand on each spectrum (1-5):

```
Formal      1 ─ 2 ─ 3 ─ 4 ─ 5      Casual
Serious     1 ─ 2 ─ 3 ─ 4 ─ 5      Playful
Reserved    1 ─ 2 ─ 3 ─ 4 ─ 5      Enthusiastic
Technical   1 ─ 2 ─ 3 ─ 4 ─ 5      Accessible
Safe        1 ─ 2 ─ 3 ─ 4 ─ 5      Bold
Traditional 1 ─ 2 ─ 3 ─ 4 ─ 5      Innovative
Corporate   1 ─ 2 ─ 3 ─ 4 ─ 5      Human
Humble      1 ─ 2 ─ 3 ─ 4 ─ 5      Confident
```

### The Four Voice Pillars

Every brand voice can be defined by 3-4 primary traits:

**Examples of Voice Pillars:**

| Pillar | Description | Sounds Like | Doesn't Sound Like |
|--------|-------------|-------------|-------------------|
| Confident | We know our stuff and aren't afraid to say it | "Here's what works" | "We think maybe..." |
| Warm | We actually care about the people we serve | "We've been there too" | "Users will find that..." |
| Direct | We respect your time and get to the point | "Do this. Here's why." | "It could potentially be beneficial to consider..." |
| Witty | We take work seriously but not ourselves | "Let's fix this mess" | "We shall endeavor to optimize..." |

---

### The "We Are / We Are Not" Framework

Define voice through contrast:

```
WE ARE:                          WE ARE NOT:
───────────────────────────────────────────────────
Confident                    →   Arrogant
Helpful                      →   Condescending
Clear                        →   Dumbed-down
Passionate                   →   Salesy
Professional                 →   Stiff
Friendly                     →   Fake-cheerful
Bold                         →   Reckless
Expert                       →   Jargon-heavy
```

---

## Step 2: Tone Mapping

### Tone Varies by Context

The same voice sounds different in different situations:

| Context | Tone Adjustment | Example |
|---------|----------------|---------|
| Homepage | Confident, inspiring | "Transform how your team works" |
| Error message | Helpful, calm | "Something went wrong. Here's how to fix it" |
| Celebration | Enthusiastic, warm | "You did it! 10,000 users and counting" |
| Apology | Sincere, accountable | "We messed up. Here's what happened and what we're doing about it" |
| Onboarding | Encouraging, patient | "Let's get you set up. This takes about 3 minutes" |
| Sales | Confident, direct | "Here's exactly what you get and what it costs" |

### Tone Matrix

Map tone adjustments across situations:

```
                     MORE FORMAL ◄──────────► MORE CASUAL
                            │
       CRISIS/BAD NEWS      │      CELEBRATION
       (Serious, Direct,    │      (Enthusiastic, Warm,
        Accountable)        │       Celebratory)
                            │
MORE ──────────────────────┼────────────────────── MORE
SERIOUS                     │                      PLAYFUL
                            │
       EDUCATION/HELP       │      MARKETING/SOCIAL
       (Patient, Clear,     │      (Engaging, Punchy,
        Supportive)         │       Personality-forward)
                            │
```

---

## Step 3: Style Rules

### Writing Style Guide

**Sentence Structure:**
- [ ] Short sentences preferred (under 20 words)
- [ ] One idea per sentence
- [ ] Active voice default
- [ ] Passive voice acceptable when: [specify]

**Paragraph Structure:**
- [ ] Short paragraphs (2-3 sentences max)
- [ ] One main point per paragraph
- [ ] White space is your friend

**Formatting Preferences:**
| Element | Preference |
|---------|------------|
| Headlines | Sentence case / Title Case |
| Lists | Bulleted / Numbered / When to use each |
| Emphasis | Bold / Italic / When to use |
| Numbers | Spell out 1-10 / Always numerals |

### Vocabulary Guidelines

**Words We Use:**
| Instead of... | We say... |
|---------------|-----------|
| Utilize | Use |
| Leverage | Use / Build on |
| Synergy | [Don't say this] |
| Solution | [Be specific: tool, platform, service] |
| Innovative | [Show, don't tell] |

**Words We Own:**
Words or phrases unique to your brand:
- [Brand term 1]: Definition
- [Brand term 2]: Definition
- [Brand phrase]: When to use

**Words We Avoid:**
| Word | Why |
|------|-----|
| [Word 1] | [Reason] |
| [Word 2] | [Reason] |
| [Word 3] | [Reason] |

### Grammar & Mechanics

| Rule | Our Standard |
|------|--------------|
| Oxford comma | Yes / No |
| Contractions | Yes / Limited / No |
| Exclamation points | Sparingly / Never / One per page max |
| Emoji | Yes (social only) / Limited / Never |
| Capitalization | Product names, features, etc. |
| Abbreviations | Spell out first use / Common ones OK |

---

## Step 4: Voice in Action

### Before & After Examples

Provide clear transformations:

**Generic → On-Brand:**

```
GENERIC:
"Our innovative solution leverages cutting-edge technology to deliver best-in-class results for your business needs."

ON-BRAND (Example: Confident + Direct + Warm):
"We built this because we were tired of tools that promise everything and deliver spreadsheets. It actually works. Here's how."
```

**Too Casual → On-Brand:**

```
TOO CASUAL:
"OMG you guys!! This feature is literally going to change your life!!! 🎉🎉🎉"

ON-BRAND (Example: Enthusiastic but Professional):
"This one's been in the works for months. It's finally here, and it's going to save you serious time."
```

**Too Formal → On-Brand:**

```
TOO FORMAL:
"We are pleased to announce the implementation of enhanced functionality within the platform infrastructure."

ON-BRAND (Example: Direct + Human):
"New feature: bulk editing. Edit 100 items at once instead of one at a time. You asked, we built it."
```

---

### Channel-Specific Applications

| Channel | Voice Expression | Example |
|---------|-----------------|---------|
| Website | Full brand voice, polished | [Example] |
| Email | Slightly warmer, more personal | [Example] |
| Social | More casual, personality-forward | [Example] |
| Support | Patient, helpful, solution-focused | [Example] |
| Sales | Confident, direct, value-focused | [Example] |
| Internal | Relaxed but professional | [Example] |

---

## Output Format

### Voice Document Structure

```
═══════════════════════════════════════════════════════════════
BRAND VOICE GUIDE: [BRAND NAME]
═══════════════════════════════════════════════════════════════

QUICK REFERENCE
───────────────────────────────────────────────────────────────
Our voice in 3 words: [Word 1], [Word 2], [Word 3]

Remember: [One-sentence voice reminder]

───────────────────────────────────────────────────────────────
VOICE PILLARS
───────────────────────────────────────────────────────────────

1. [PILLAR NAME]
   What it means: [Description]
   Sounds like: "[Example]"
   Doesn't sound like: "[Anti-example]"

2. [PILLAR NAME]
   What it means: [Description]
   Sounds like: "[Example]"
   Doesn't sound like: "[Anti-example]"

3. [PILLAR NAME]
   What it means: [Description]
   Sounds like: "[Example]"
   Doesn't sound like: "[Anti-example]"

───────────────────────────────────────────────────────────────
WE ARE / WE ARE NOT
───────────────────────────────────────────────────────────────

We are: [Trait 1], [Trait 2], [Trait 3]
We are not: [Anti-trait 1], [Anti-trait 2], [Anti-trait 3]

───────────────────────────────────────────────────────────────
TONE BY CONTEXT
───────────────────────────────────────────────────────────────

| Situation | Tone | Example |
|-----------|------|---------|
| [Context] | [Tone] | "[Example copy]" |

───────────────────────────────────────────────────────────────
STYLE RULES
───────────────────────────────────────────────────────────────

Vocabulary:
• Use: [words]
• Avoid: [words]
• Our terms: [brand-specific vocabulary]

Grammar:
• Contractions: [Yes/No]
• Oxford comma: [Yes/No]
• Sentence length: [Guideline]

───────────────────────────────────────────────────────────────
EXAMPLES
───────────────────────────────────────────────────────────────

HEADLINE - ON BRAND:
"[Example]"

HEADLINE - OFF BRAND:
"[Example]"

BODY COPY - ON BRAND:
"[Example paragraph]"

BODY COPY - OFF BRAND:
"[Example paragraph]"

───────────────────────────────────────────────────────────────
QUICK CHECKLIST
───────────────────────────────────────────────────────────────

Before publishing, ask:
□ Does this sound like us?
□ Would our audience recognize this as ours?
□ Is the tone right for this context?
□ Did we follow our style rules?
□ Is this something we'd be proud to sign our name to?
```

---

## Voice Testing Methods

### The Logo Swap Test
Remove your logo. Could this content be from any competitor? If yes, your voice isn't distinct enough.

### The Read Aloud Test
Read copy out loud. Does it sound like how your brand would actually talk? Or does it sound like "marketing speak"?

### The Personality Test
If someone read only this piece of content, what 3 adjectives would they use to describe the author? Do those match your intended voice?

### The Consistency Test
Compare 5 random pieces of your content. Do they sound like they came from the same source?

---

## Common Voice Problems & Fixes

| Problem | Symptom | Fix |
|---------|---------|-----|
| Generic voice | Could be any company | Add specific opinions, personality |
| Inconsistent voice | Different content sounds different | Create clearer examples, train team |
| Wrong tone for context | Playful in serious moments | Develop tone matrix by situation |
| Too corporate | Sounds like legal wrote it | Use contractions, shorter sentences |
| Trying too hard | Forced humor, over-personality | Pull back, let value speak |
| No personality | Safe, forgettable | Take a stance, have opinions |

---

## Limitations

**I can help with:**
- Extracting voice from existing content
- Defining voice pillars and attributes
- Creating style guidelines
- Writing before/after examples
- Mapping tone across contexts

**I cannot provide:**
- Customer research on what resonates
- Competitive voice analysis from real data
- Guarantee voice will connect with audience
- Implementation across your team

**For complete voice development, also conduct:**
- Customer interviews (how do they describe you?)
- Team workshops (how do employees describe the brand?)
- Content audit (what's working now?)
- Competitive analysis (how do others sound?)

---

## Quality Checklist

Before delivering voice guide:
- [ ] Voice pillars are clear and distinct (3-4 max)
- [ ] "We are / We are not" contrasts are useful
- [ ] Tone variations by context are mapped
- [ ] Style rules are specific and actionable
- [ ] Multiple before/after examples provided
- [ ] Channel-specific guidance included
- [ ] Quick reference summary is usable
- [ ] Checklist for writers is practical
- [ ] Guide is readable in under 10 minutes
