# How to Use: Brand Voice

## Quick Start

Provide context about your brand and this skill will create a comprehensive voice guide.

## Minimum Input

```
Brand: [Your brand name]
What we do: [One sentence]
Who we serve: [Target audience]

Examples of copy we like: [Links or paste examples]
Examples that feel wrong: [What doesn't sound like us]
```

## Best Results Input

```
Brand: [Name]
What we do: [One sentence]
Who we serve: [Target audience]

VALUES:
- What we stand for: [beliefs]
- What we stand against: [anti-values]

PERSONALITY:
- If our brand were a person: [description]
- We are: [3-5 traits]
- We are NOT: [3-5 anti-traits]

EXISTING CONTENT:
- Content we like (ours): [examples]
- Content we like (others): [examples]
- Content that feels wrong: [examples]

COMPETITORS:
- [Competitor 1] sounds like: [description]
- [Competitor 2] sounds like: [description]
- Voice territory that's crowded: [description]
```

## Example Prompts

**Starting from scratch:**
> "We're launching a B2B SaaS for accountants. We want to sound confident but not cocky, helpful but not hand-holdy. Create our brand voice guide."

**Documenting existing voice:**
> "Here are 5 pieces of content that sound like us: [links]. Extract our voice and create a guide we can share with writers."

**Refreshing voice:**
> "Our current voice feels too corporate. We want to sound more human. Help us define a new voice that keeps professionalism but adds personality."

## Output You'll Get

1. **Voice Pillars** (3-4 core personality traits with examples)
2. **We Are / We Are Not** (clarity through contrast)
3. **Tone Matrix** (how voice adapts to different contexts)
4. **Style Rules** (vocabulary, grammar, formatting)
5. **Before/After Examples** (concrete transformations)
6. **Quick Reference Card** (shareable summary)
7. **Writer Checklist** (practical quality check)

## Tips

- Be honest about who you are, not who you wish you were
- Include content that feels WRONG—it's just as useful as content you like
- The more existing content you provide, the better the extraction
- Voice should reflect your actual team/culture, not a manufactured persona
