---
name: linkedin-ads-auditor
description: Audits LinkedIn Ads campaigns for B2B advertisers, analyzing targeting, lead quality, CPL efficiency, and creative performance. Triggers when user asks "why is my LinkedIn Ads CPL so high?", "how do I improve LinkedIn lead quality?", or wants to optimize B2B advertising. Provides specific recommendations for B2B lead generation.
---

# LinkedIn Ads Auditor

B2B advertising is different. Audit like it.

## Core Philosophy

**LinkedIn is not Meta.** Higher CPMs, smaller audiences, longer sales cycles. Stop comparing apples to oranges.

**The LinkedIn Paradox:** You'll pay more per lead, but if they're the right leads, you'll pay less per customer.

**The Three Truths of LinkedIn Ads:**
1. **Quality over quantity:** 10 right leads beat 100 wrong leads
2. **Targeting is the product:** LinkedIn's value is precision, not scale
3. **Patience pays:** B2B cycles are long—judge results over months, not days

---

## Required Context

### Must Have

**1. Campaign Overview**
- Campaign objectives (Lead Gen, Website Visits, Conversions)
- Monthly spend
- Leads generated
- Cost per lead (CPL)

**2. Targeting Setup**
- Job titles, functions, seniority targeted
- Company size, industry, company names
- Audience size

**3. Lead Quality Data**
- Lead-to-opportunity rate (if known)
- Lead-to-customer rate (if known)
- Feedback from sales team

### Strongly Recommended

**4. Ad Performance**
- Ad format (Single Image, Carousel, Video, etc.)
- CTR by ad
- Engagement metrics
- Frequency

**5. Campaign Type Details**
- Lead Gen Forms vs. Website Conversions
- Form fields used
- Offer/asset being promoted

### Nice to Have

- Historical performance trends
- Competitor context
- Sales cycle length
- Customer lifetime value (LTV)

---

## LinkedIn Ads Audit Framework

### Level 1: Efficiency Benchmarks

**LinkedIn CPL Benchmarks by Industry (2024):**

| Industry | Low CPL | Average CPL | High CPL |
|----------|---------|-------------|----------|
| SaaS/Technology | $50 | $80-120 | $150+ |
| Financial Services | $80 | $120-180 | $250+ |
| Professional Services | $40 | $70-100 | $150+ |
| Manufacturing | $60 | $90-140 | $200+ |
| Healthcare | $70 | $100-150 | $200+ |
| Education | $30 | $50-80 | $120+ |

**Other Key Benchmarks:**

| Metric | Poor | Average | Good | Excellent |
|--------|------|---------|------|-----------|
| CTR (Sponsored Content) | <0.35% | 0.35-0.50% | 0.50-0.80% | >0.80% |
| CTR (Lead Gen Forms) | <0.50% | 0.50-0.80% | 0.80-1.2% | >1.2% |
| Form Completion Rate | <15% | 15-25% | 25-40% | >40% |
| Engagement Rate | <0.30% | 0.30-0.50% | 0.50-0.70% | >0.70% |

---

### Level 2: Targeting Audit

**Audience Size Sweet Spot:**

| Audience Size | Assessment | Recommendation |
|---------------|------------|----------------|
| <10,000 | Too narrow | Expand criteria |
| 10,000-50,000 | Niche but viable | Good for ABM |
| 50,000-300,000 | Optimal | Best balance |
| 300,000-1,000,000 | Broad | Consider segmenting |
| >1,000,000 | Very broad | Likely inefficient |

**Targeting Criteria Audit:**

| Criteria | Strength | Cost Impact |
|----------|----------|-------------|
| Job Title (exact) | High precision | Higher CPM |
| Job Function | Medium precision | Medium CPM |
| Seniority + Function | Good balance | Medium-High CPM |
| Company Name (ABM) | Highest precision | Highest CPM |
| Industry only | Low precision | Lower CPM |
| Skills | Variable | Lower CPM |

**Common Targeting Mistakes:**

| Mistake | Impact | Fix |
|---------|--------|-----|
| Too many titles | Dilutes message | 5-10 titles max |
| No seniority filter | Reaches non-decision-makers | Add seniority |
| Too broad geography | Wastes budget | Focus on high-value regions |
| Overlapping audiences | Self-competition | Exclusion strategy |
| Company size too broad | Irrelevant leads | Define ICP tightly |

---

### Level 3: Lead Quality Analysis

**Lead Quality Framework:**

```
LEAD QUALITY SCORE = (Lead-to-Opp Rate × 0.5) +
                     (Title Match Rate × 0.3) +
                     (Company Fit Rate × 0.2)
```

**Quality Tiers:**

| Tier | Lead-to-Opp | Assessment |
|------|-------------|------------|
| A | >20% | Excellent targeting |
| B | 10-20% | Good, optimize edges |
| C | 5-10% | Needs improvement |
| D | <5% | Targeting problem |

**Lead Quality Issues and Causes:**

| Symptom | Likely Cause | Solution |
|---------|--------------|----------|
| Low title match | Targeting too broad | Tighten job titles |
| Wrong company size | No size filter | Add company size |
| Wrong industry | Industry too broad | Refine industries |
| Students/interns | No seniority filter | Exclude entry-level |
| Competitors | No exclusions | Exclude competitor domains |

---

### Level 4: Campaign Structure Audit

**Campaign Type Assessment:**

| Type | Best For | Expected CPL |
|------|----------|--------------|
| Lead Gen Forms | Lower-commitment offers | Lower CPL, lower quality |
| Website Conversions | High-intent offers | Higher CPL, higher quality |
| Conversation Ads | Personal outreach | Variable |
| Document Ads | Content download | Lower CPL |
| Event Ads | Webinar/event registration | Medium CPL |

**Lead Gen Form Optimization:**

| Form Fields | Form Completion Rate | Recommendation |
|-------------|---------------------|----------------|
| 3-4 fields | 30-40% | Optimal |
| 5-6 fields | 20-30% | Acceptable |
| 7+ fields | <20% | Too long |

**Recommended Fields:**
- Always: Name, Email, Company, Job Title
- Optional: Phone (lowers completion 10-15%)
- Custom: 1 qualifying question max

---

### Level 5: Creative Audit

**Ad Format Performance (LinkedIn Averages):**

| Format | Avg CTR | Best For |
|--------|---------|----------|
| Single Image | 0.40-0.50% | Brand awareness, simple offers |
| Carousel | 0.50-0.70% | Multiple products, storytelling |
| Video | 0.35-0.45% | Brand, complex messages |
| Document | 0.60-0.80% | Content offers, thought leadership |
| Conversation | Variable | Personalized outreach |

**Creative Best Practices Checklist:**

| Element | Best Practice | Common Mistake |
|---------|---------------|----------------|
| Image | Professional, not stock-y | Generic stock photos |
| Headline | Benefit-focused, <150 char | Feature-focused |
| Body | Clear CTA, credibility | Too long, no CTA |
| CTA Button | Match intent | Mismatched CTA |
| Logo | Clear, properly sized | Blurry or cut off |

---

### Level 6: Budget & Bidding Audit

**Budget Guidelines:**

| Audience Size | Min Daily Budget | Recommended |
|---------------|------------------|-------------|
| <50K | $50 | $75-100 |
| 50K-200K | $75 | $100-150 |
| 200K-500K | $100 | $150-250 |
| >500K | $150 | $250+ |

**Bidding Strategy Assessment:**

| Strategy | When to Use | Risk |
|----------|-------------|------|
| Maximum Delivery | Getting started, testing | Overpay for impressions |
| Cost Cap | Controlling costs | May underdeliver |
| Manual CPC | Experienced advertisers | Requires active management |

---

## Output Format

### LinkedIn Ads Audit Report

```
═══════════════════════════════════════════════════════════════
LINKEDIN ADS AUDIT
Account: [Account Name]
Audit Period: [Date Range]
Total Spend: $[X] | Leads: [X] | CPL: $[X]
Overall Health: [HEALTHY/NEEDS WORK/CRITICAL]
═══════════════════════════════════════════════════════════════
```

---

### Executive Summary

**Performance vs. Benchmarks:**

| Metric | Your Value | Benchmark | Status |
|--------|------------|-----------|--------|
| CPL | $[X] | $[X] (industry avg) | [Above/Below] |
| CTR | [X]% | [X]% | [Above/Below] |
| Lead-to-Opp | [X]% | [X]% | [Above/Below] |
| Form Completion | [X]% | [X]% | [Above/Below] |

**Top 3 Issues:**
1. [Issue] - [Impact]
2. [Issue] - [Impact]
3. [Issue] - [Impact]

**Top 3 Opportunities:**
1. [Opportunity] - [Potential impact]
2. [Opportunity] - [Potential impact]
3. [Opportunity] - [Potential impact]

---

### Campaign Performance Breakdown

**By Campaign:**

| Campaign | Spend | Leads | CPL | CTR | Quality | Status |
|----------|-------|-------|-----|-----|---------|--------|
| [Name] | $[X] | [X] | $[X] | [X]% | [A/B/C/D] | [Status] |

**Campaign Health Tiers:**

| Tier | Campaigns | Action |
|------|-----------|--------|
| Scale | [Names] | Increase budget |
| Optimize | [Names] | Improve targeting/creative |
| Fix | [Names] | Major changes needed |
| Pause | [Names] | Consider stopping |

---

### Targeting Audit

**Current Targeting Assessment:**

| Criteria | Setting | Assessment | Recommendation |
|----------|---------|------------|----------------|
| Job Titles | [List] | [Assessment] | [Recommendation] |
| Job Functions | [List] | [Assessment] | [Recommendation] |
| Seniority | [List] | [Assessment] | [Recommendation] |
| Company Size | [Range] | [Assessment] | [Recommendation] |
| Industries | [List] | [Assessment] | [Recommendation] |
| Geography | [Regions] | [Assessment] | [Recommendation] |

**Audience Size:**
- Current: [X]
- Optimal range: [X-Y]
- Status: [Too narrow/Optimal/Too broad]

**Targeting Recommendations:**
1. [Specific recommendation]
2. [Specific recommendation]
3. [Specific recommendation]

---

### Lead Quality Analysis

**Quality Metrics:**

| Metric | Value | Benchmark | Status |
|--------|-------|-----------|--------|
| Lead-to-Opportunity Rate | [X]% | 10-15% | [Status] |
| Title Match Rate | [X]% | >80% | [Status] |
| Company Fit Rate | [X]% | >70% | [Status] |

**Lead Quality Score: [X]/100**

**Quality Issues Identified:**
| Issue | Evidence | Solution |
|-------|----------|----------|
| [Issue] | [Data/feedback] | [Solution] |

**Sales Team Feedback Integration:**
- [Feedback point and how to address]

---

### Creative Audit

**Ad Performance:**

| Ad | Format | Impressions | CTR | Leads | CPL | Status |
|----|--------|-------------|-----|-------|-----|--------|
| [Name] | [Format] | [X] | [X]% | [X] | $[X] | [Status] |

**Creative Assessment:**

| Element | Current | Assessment | Improvement |
|---------|---------|------------|-------------|
| Headlines | [Description] | [Score/10] | [Recommendation] |
| Images | [Description] | [Score/10] | [Recommendation] |
| Body Copy | [Description] | [Score/10] | [Recommendation] |
| CTA | [Description] | [Score/10] | [Recommendation] |

**Format Recommendations:**
- [Format recommendation based on goals]

---

### Lead Gen Form Audit

**Current Form:**
- Fields: [List of fields]
- Completion Rate: [X]%
- Benchmark: [X]%

**Form Assessment:**

| Field | Necessary? | Impact on Completion |
|-------|------------|---------------------|
| [Field] | [Yes/No/Maybe] | [Low/Medium/High] |

**Recommendations:**
- [Field to add/remove/modify]

---

### Budget & Bidding Audit

**Budget Efficiency:**

| Campaign | Budget | Spend | Utilization | CPL | Assessment |
|----------|--------|-------|-------------|-----|------------|
| [Name] | $[X] | $[X] | [X]% | $[X] | [Assessment] |

**Bidding Assessment:**
- Current strategy: [Strategy]
- Recommendation: [Recommendation]

---

### Cost Per Lead Economics

**True Cost Analysis:**

```
CPL: $[X]
Lead-to-Opportunity: [X]%
Cost per Opportunity: $[X]
Opportunity-to-Customer: [X]%
Cost per Customer (CAC): $[X]
Customer LTV: $[X]
LTV:CAC Ratio: [X]:1
```

**Assessment:** [Is LinkedIn profitable at current efficiency?]

**Break-Even Analysis:**
- At $[X] CPL, you need [X]% lead-to-customer to break even
- Current performance: [Above/Below] break-even

---

### Action Plan

**Immediate (This Week):**
1. [ ] [High-priority action]
2. [ ] [High-priority action]
3. [ ] [High-priority action]

**Short-Term (Next 2-4 Weeks):**
1. [ ] [Action]
2. [ ] [Action]
3. [ ] [Action]

**Medium-Term (Next 1-2 Months):**
1. [ ] [Action]
2. [ ] [Action]

**Expected Impact:**
- CPL reduction: [X]%
- Lead quality improvement: [X]%
- Projected cost per customer: $[X]

---

### Monitoring Framework

**Weekly Tracking:**
- [ ] CPL by campaign
- [ ] CTR trends
- [ ] Frequency (avoid fatigue)
- [ ] Budget utilization

**Monthly Tracking:**
- [ ] Lead-to-opportunity rate
- [ ] Lead quality feedback from sales
- [ ] Audience saturation (is reach declining?)

**Red Flags:**
- CPL increases >20% week-over-week
- CTR drops below 0.30%
- Frequency exceeds 5 in 30 days
- Lead quality complaints from sales

---

## Common LinkedIn Ads Problems

### Problem 1: High CPL, Decent Quality
**Cause:** Often a creative or targeting breadth issue
**Solutions:**
- Test more ad variations
- Broaden audience slightly (if <50K)
- Test Lead Gen Forms vs. Website Conversions
- Check bid strategy isn't too conservative

### Problem 2: Low CPL, Poor Quality
**Cause:** Targeting too broad or wrong offer
**Solutions:**
- Tighten seniority filters
- Add company size restrictions
- Review form fields (too few?)
- Check title matching in leads

### Problem 3: Low Delivery/Impressions
**Cause:** Audience too small or budget too low
**Solutions:**
- Expand targeting criteria
- Increase daily budget
- Check bid caps aren't too low
- Reduce frequency cap if set

### Problem 4: High CTR, Low Conversion
**Cause:** Ad-to-landing page mismatch or targeting
**Solutions:**
- Audit landing page experience
- Check message match
- Review mobile experience
- Qualify harder in targeting

---

## Limitations

**I can provide:**
- Campaign efficiency analysis
- Targeting recommendations
- Creative assessment
- Lead quality framework
- Budget optimization

**I cannot provide:**
- Competitor intelligence
- Creative design
- Landing page optimization
- CRM integration analysis

**For better audits, provide:**
- Lead-to-opportunity data from CRM
- Sales team feedback on lead quality
- Landing page performance
- Historical trends (3+ months)

---

## Quality Checklist

Before delivering audit:
- [ ] All campaigns assessed
- [ ] Benchmarks appropriate for industry
- [ ] Lead quality addressed (not just CPL)
- [ ] Targeting recommendations are specific
- [ ] Creative feedback is actionable
- [ ] Budget recommendations are realistic
- [ ] Economics (CPL to CAC) calculated if data available
- [ ] Action plan is prioritized
