# How to Use This Skill

Hey Claude—I just added the "linkedin-ads-auditor" skill. Can you audit my LinkedIn Ads and tell me why my CPL is so high?

## Example Invocations

**Example 1: Full LinkedIn Audit**
Hey Claude—I just added the "linkedin-ads-auditor" skill. Here's all my LinkedIn Ads data including campaigns, targeting, and lead quality feedback from sales. Give me a full audit.

**Example 2: CPL Troubleshooting**
Hey Claude—I just added the "linkedin-ads-auditor" skill. My LinkedIn CPL is $180 which seems high. Here's my setup—is this normal and how do I reduce it?

**Example 3: Lead Quality Review**
Hey Claude—I just added the "linkedin-ads-auditor" skill. We're getting leads from LinkedIn but sales says they're not qualified. Here's our targeting and lead data—what's wrong?

**Example 4: Targeting Optimization**
Hey Claude—I just added the "linkedin-ads-auditor" skill. I'm not sure if my LinkedIn targeting is right for B2B SaaS. Here's what I have—review and recommend changes.

**Example 5: Campaign Structure Review**
Hey Claude—I just added the "linkedin-ads-auditor" skill. I'm running 5 LinkedIn campaigns and not sure if the structure makes sense. Here's the setup—how should I reorganize?

## What to Provide

**Required:**
- Campaign names and objectives
- Monthly spend and leads generated
- Cost per lead (CPL)
- Targeting criteria (job titles, seniority, company size, industries)
- Audience sizes

**Highly Recommended:**
- Lead-to-opportunity rate (or sales feedback on quality)
- CTR and other ad metrics
- Ad formats and creative descriptions
- Lead gen form fields (if using)

**Optional:**
- Historical performance trends
- Landing page conversion rates
- Customer lifetime value (LTV)
- Industry/competitor context

## What You'll Get

1. **Benchmark Comparison** - How you stack up against industry averages
2. **Targeting Audit** - Is your targeting too broad, too narrow, or wrong?
3. **Lead Quality Analysis** - Quality scoring and improvement recommendations
4. **Creative Assessment** - Which ads are working and why
5. **Form Optimization** - If using Lead Gen Forms, field recommendations
6. **Economics Analysis** - CPL to CAC calculation and break-even analysis
7. **Action Plan** - Prioritized improvements

## Pro Tips

- LinkedIn CPLs are higher than Meta/Google—that's normal for B2B
- Lead quality matters more than CPL—a $150 lead that closes beats a $50 lead that doesn't
- Audience size sweet spot is 50K-300K
- Lead Gen Forms have lower CPL but often lower quality than website conversions
- Seniority filters are crucial—Manager+ if targeting decision-makers
- Frequency matters on LinkedIn—small audiences fatigue fast
