---
name: scaling-roadmap-builder
description: Creates a phased growth plan for scaling Google Ads accounts with budget milestones, testing priorities, and expected outcomes. Triggers when user wants to grow their account, increase spend, scale campaigns, or asks "how do I go from $X to $Y?" Provides realistic timelines, risk mitigation, and success criteria for each phase.
---

# Scaling Roadmap Builder

Grow your Google Ads spend without growing your CPA.

## Core Philosophy

**Scaling is not just spending more.** It's systematically expanding what works while maintaining efficiency.

**The Scaling Paradox:** The things that got you to $10K/month won't get you to $50K/month. Structure, strategy, and approach must evolve.

**The Three Laws of Scaling:**
1. **Efficiency first:** Never scale what isn't working
2. **Incremental growth:** 20-30% increases, not 200%
3. **Diversification:** Single-campaign dependency is a ceiling

---

## Required Context

### Must Have

**1. Current State**
- Current monthly spend
- Current conversions
- Current CPA or ROAS
- Number of campaigns

**2. Growth Target**
- Target monthly spend (or target conversions)
- Timeline expectations (realistic or aggressive)
- Budget constraints (fixed increases or flexible)

### Strongly Recommended

**3. Performance Baseline**
- Campaign-level breakdown
- Best performing campaign(s)
- Efficiency by campaign type (brand, non-brand, remarketing)

**4. Business Context**
- Conversion type (leads, sales, demos)
- Average deal value or LTV
- Sales capacity constraints (can you handle more leads?)

### Nice to Have

- Historical scaling attempts (what happened)
- Competitive landscape
- Seasonality patterns
- Market size estimates

---

## Scaling Assessment Framework

### Phase 0: Scaling Readiness Check

Before planning growth, verify the foundation is solid.

**Minimum Requirements to Scale:**

| Requirement | Threshold | Why |
|-------------|-----------|-----|
| Conversion tracking | Accurate | Can't optimize what you can't measure |
| Baseline efficiency | At or below target CPA | Don't scale inefficiency |
| Data volume | 30+ conversions/month | Need signal for optimization |
| Account structure | Campaigns organized | Chaos doesn't scale |
| Landing pages | Converting | Traffic to bad pages = waste |

**Readiness Score:**
- 5/5 requirements met: Ready to scale
- 3-4/5: Fix gaps first, then scale
- <3/5: Focus on fundamentals, scaling will fail

---

### Scaling Velocity Guidelines

**Conservative Scaling (Recommended):**
- 15-25% budget increase per phase
- 2-4 weeks per phase
- Lower risk, sustainable growth

**Moderate Scaling:**
- 25-40% budget increase per phase
- 2-3 weeks per phase
- Medium risk, faster growth

**Aggressive Scaling (Caution):**
- 40-60% budget increase per phase
- 1-2 weeks per phase
- Higher risk, CPA volatility likely

**Scaling Speed Factors:**

| Factor | Allows Faster Scaling | Requires Slower Scaling |
|--------|----------------------|------------------------|
| Current efficiency | CPA far below target | CPA near target |
| Data volume | High (100+ conv/mo) | Low (<50 conv/mo) |
| Impression share | Low (<50%) | High (>80%) |
| Market size | Large/untapped | Small/saturated |
| Competition | Stable | Increasing |

---

## Scaling Strategies by Stage

### Stage 1: $1K-$5K/month (Foundation)

**Focus:** Prove the model works

**Priorities:**
1. Nail conversion tracking
2. Find 1-2 profitable campaigns
3. Establish baseline metrics
4. Test core messaging

**Scaling Approach:**
- Increase budgets on winners
- Cut losers quickly
- Simple structure (3-5 campaigns max)

**Typical Timeline:** 1-2 months per $1K increase

---

### Stage 2: $5K-$15K/month (Optimization)

**Focus:** Maximize efficiency before expanding

**Priorities:**
1. Optimize winning campaigns deeply
2. Add keyword variations to winners
3. Test landing pages
4. Build remarketing foundation

**Scaling Approach:**
- Vertical scaling (more budget to winners)
- Horizontal expansion (new keywords in proven campaigns)
- Start audience testing

**Typical Timeline:** 1 month per $2-3K increase

---

### Stage 3: $15K-$50K/month (Expansion)

**Focus:** Diversify traffic sources

**Priorities:**
1. Launch new campaign types
2. Test new audiences
3. Expand geo/device targeting
4. Build campaign ecosystem

**Scaling Approach:**
- Balance vertical and horizontal growth
- Test new campaign types (DSA, Performance Max, YouTube)
- Segment audiences for personalization

**Typical Timeline:** 1-2 months per $5-10K increase

---

### Stage 4: $50K-$150K/month (Sophistication)

**Focus:** Efficiency at scale

**Priorities:**
1. Advanced bid strategies
2. Audience layering
3. Full-funnel approach
4. Creative testing at scale

**Scaling Approach:**
- Portfolio bid strategies
- Audience segmentation
- Multi-touch attribution
- Cross-channel coordination

**Typical Timeline:** 2-3 months per $20-30K increase

---

### Stage 5: $150K+/month (Dominance)

**Focus:** Market share and marginal gains

**Priorities:**
1. Impression share maximization
2. Incrementality testing
3. Brand building
4. Competitive defense

**Scaling Approach:**
- Diminishing returns management
- Test offline impact
- Invest in brand
- Explore new markets/products

**Typical Timeline:** Varies by market opportunity

---

## Output Format

### Scaling Roadmap Summary

```
═══════════════════════════════════════════════════════════════
SCALING ROADMAP: $[Current] → $[Target]/month
Timeline: [X] months
Phases: [X]
Confidence Level: High / Medium / Low
═══════════════════════════════════════════════════════════════
```

---

### 📊 Current State Assessment

**Readiness Score: [X]/5**

| Requirement | Status | Notes |
|-------------|--------|-------|
| Conversion tracking | ✅/❌ | [Detail] |
| Baseline efficiency | ✅/❌ | [CPA vs target] |
| Data volume | ✅/❌ | [X conv/month] |
| Account structure | ✅/❌ | [Assessment] |
| Landing pages | ✅/❌ | [Assessment] |

**Current Performance:**
```
Monthly Spend: $[X]
Monthly Conversions: [X]
CPA: $[X] (Target: $[X])
Primary Campaign: [Name] ([X]% of conversions)
```

**Scaling Capacity:**
- Impression share headroom: [X]%
- Budget-limited campaigns: [X]
- Estimated addressable market: [Assessment]

---

### 🎯 Scaling Target

**Goal:** $[Current]/month → $[Target]/month

**Growth Multiple:** [X]x

**Expected Outcomes at Target:**
```
Monthly Spend: $[Target]
Projected Conversions: [X]-[X]
Projected CPA: $[X]-$[X]
```

**Key Assumptions:**
- [Assumption 1]
- [Assumption 2]

---

### 🗺️ Phase-by-Phase Roadmap

---

**PHASE 1: [Name]**
*[Duration] | $[Start] → $[End]*

**Objective:** [One sentence goal]

**Budget Change:**
```
Start: $[X]/month
End: $[X]/month
Increase: +$[X] (+[X]%)
```

**Actions:**
1. [ ] [Specific action]
2. [ ] [Specific action]
3. [ ] [Specific action]

**Success Criteria:**
- CPA remains below $[X]
- Conversions increase to [X]+
- [Other metric]

**Risk Mitigation:**
- If CPA rises >15%: [Action]
- If conversions don't increase: [Action]

**Checkpoint:** [Date/Week]

---

**PHASE 2: [Name]**
*[Duration] | $[Start] → $[End]*

[Same format as Phase 1]

---

**PHASE 3: [Name]**
*[Duration] | $[Start] → $[End]*

[Same format as Phase 1]

---

### 📈 Projected Growth Curve

```
Month 1: $[X] → [X] conversions @ $[X] CPA
Month 2: $[X] → [X] conversions @ $[X] CPA
Month 3: $[X] → [X] conversions @ $[X] CPA
...
Month N: $[Target] → [X] conversions @ $[X] CPA
```

**Visual:**
```
[Simple ASCII chart showing spend vs conversions over time]
```

---

### ⚠️ Scaling Risks & Mitigation

**Risk 1: CPA Inflation**
- Likelihood: Medium-High
- Impact: Profitability erosion
- Mitigation: Gradual increases, efficiency monitoring, quick pullback triggers

**Risk 2: Market Saturation**
- Likelihood: Depends on market size
- Impact: Diminishing returns
- Mitigation: Diversify campaigns, test new audiences, expand geo

**Risk 3: Competitive Response**
- Likelihood: Medium
- Impact: Increased CPCs
- Mitigation: Monitor auction insights, maintain efficiency buffers

**Risk 4: Quality Degradation**
- Likelihood: Medium (especially for lead gen)
- Impact: Lower close rates
- Mitigation: Track backend metrics, adjust lead scoring

---

### 🛑 Pause Triggers

Stop scaling and reassess if:
- [ ] CPA exceeds target by >25% for 2+ weeks
- [ ] Conversion volume doesn't increase with budget
- [ ] Backend quality (close rate, LTV) drops significantly
- [ ] Impression share stops improving despite budget increases

---

### ✅ Phase Completion Checklist

Before moving to next phase, confirm:
- [ ] CPA within acceptable range
- [ ] Conversion volume increased proportionally
- [ ] No quality degradation
- [ ] Campaigns stable (not volatile)
- [ ] Team capacity can handle volume
- [ ] Budget approved for next phase

---

### 💡 Strategic Recommendations

**Quick Wins (Weeks 1-2):**
1. [Immediate optimization opportunity]
2. [Low-hanging fruit]

**Medium-Term (Months 1-2):**
1. [Strategic initiative]
2. [Testing priority]

**Long-Term (Months 3+):**
1. [Expansion opportunity]
2. [New channel/strategy]

---

## Common Scaling Patterns

### Pattern 1: Single Winner Scale
**Situation:** One campaign drives 80% of results
**Approach:**
1. Scale winner until CPA increases 15-20%
2. Launch variations of winner (new keywords, audiences)
3. Diversify to reduce single-campaign dependency

### Pattern 2: Broad Portfolio Scale
**Situation:** Multiple campaigns performing similarly
**Approach:**
1. Increase budgets proportionally
2. Let Smart Bidding optimize across campaigns
3. Monitor for winners and losers to emerge

### Pattern 3: Efficient but Capped
**Situation:** CPA well below target, but can't spend budget
**Approach:**
1. Expand targeting (keywords, audiences, geo)
2. Test new campaign types
3. Increase bids/targets to capture more volume

### Pattern 4: At Capacity
**Situation:** High impression share, near CPA ceiling
**Approach:**
1. Accept slower growth
2. Focus on efficiency improvements
3. Expand to new markets/products
4. Test adjacent channels

---

## Limitations

**I can provide:**
- Phased growth framework
- Realistic timeline estimates
- Risk identification and mitigation
- Success criteria for each phase

**I cannot provide:**
- Market size guarantees
- Exact CPA projections at scale
- Competitive response predictions
- Backend quality impact

**For better roadmaps, also provide:**
- Historical scaling performance
- Market research / TAM estimates
- Competitive landscape details
- Sales team capacity constraints

---

## Quality Checklist

Before delivering roadmap:
- [ ] Readiness assessment completed
- [ ] Growth target is realistic for market
- [ ] Phases are appropriately sized (not too aggressive)
- [ ] Each phase has clear success criteria
- [ ] Risks identified with mitigations
- [ ] Pause triggers defined
- [ ] Timeline includes buffer for setbacks
- [ ] Backend capacity considered (can they handle leads?)
