# How to Use This Skill

Hey Claude—I just added the "pmax-asset-group-analyzer" skill. Can you help me understand why my Performance Max campaign isn't hitting target CPA?

## Example Invocations

**Example 1: Full PMax Audit**
Hey Claude—I just added the "pmax-asset-group-analyzer" skill. Here's all the data from my Performance Max campaign including asset groups, asset ratings, and search themes. Tell me what's working and what to fix.

**Example 2: Asset Group Comparison**
Hey Claude—I just added the "pmax-asset-group-analyzer" skill. I have 4 asset groups and one is getting 80% of the budget. Is that normal? Here's the performance data.

**Example 3: Asset Optimization**
Hey Claude—I just added the "pmax-asset-group-analyzer" skill. Most of my headlines are rated "Low". What's wrong with them and what should I replace them with?

**Example 4: Search Themes Review**
Hey Claude—I just added the "pmax-asset-group-analyzer" skill. I pulled my search themes report and a lot looks like branded traffic. Is my PMax cannibalizing my brand campaigns?

**Example 5: Channel Distribution**
Hey Claude—I just added the "pmax-asset-group-analyzer" skill. 70% of my PMax budget is going to Display and I think that's why CPA is high. How do I shift more to Search?

## What to Provide

**Required:**
- Campaign name and objective (leads, sales, etc.)
- Monthly spend
- Conversions and CPA (or revenue and ROAS)
- Asset group names with their individual performance
- Asset ratings (Best/Good/Low) from the Assets tab

**Highly Recommended:**
- Search themes report (what queries are triggering)
- Actual headlines and descriptions (not just counts)
- Audience signals configured
- Placement/channel breakdown

**Optional:**
- Audience insights from the Insights tab
- Historical performance trends
- Comparison to other campaigns
- Feed details (for shopping-eligible)

## What You'll Get

1. **Campaign Health Check** - Is PMax fundamentally working?
2. **Asset Group Ranking** - Which groups to scale, fix, or pause
3. **Asset Performance** - Which specific assets to keep/replace
4. **Search Themes Analysis** - Relevance check and negative recommendations
5. **Signal Assessment** - Are your audience signals working?
6. **Channel Distribution** - Where budget is going and if that's good
7. **Specific Recommendations** - Exact headlines, images, changes to make

## Pro Tips

- Export asset data from Google Ads → Assets → Performance columns
- Pull search themes from Insights → Search themes
- Include both "Best" and "Low" rated assets—we need to see both
- PMax needs 30+ conversions/month to learn properly
- Don't make changes more than once every 2 weeks—algorithm needs stability
- If PMax is cannibalizing brand, you can add brand exclusions
