# How to Use This Skill

Hey Claude—I just added the "budget-allocation-optimizer" skill. Can you analyze my campaign budgets and tell me where to move money?

## Example Invocations

**Example 1: Full Optimization**
Hey Claude—I just added the "budget-allocation-optimizer" skill. Here's my campaign performance data. My total budget is $15K/month and target CPA is $50. Where should I reallocate?

**Example 2: Quick Assessment**
Hey Claude—I just added the "budget-allocation-optimizer" skill. I have 5 campaigns with very different CPAs. Just tell me which ones are overfunded and which need more budget.

**Example 3: Scaling Decision**
Hey Claude—I just added the "budget-allocation-optimizer" skill. My best campaign is budget-capped. Should I take money from other campaigns or request more budget?

**Example 4: Fixed Budget Constraint**
Hey Claude—I just added the "budget-allocation-optimizer" skill. I can't increase total budget, but I want to maximize conversions. Here's my data—optimize my allocation.

**Example 5: With Impression Share Data**
Hey Claude—I just added the "budget-allocation-optimizer" skill. I have campaign data plus impression share. Show me where I'm losing conversions due to budget.

## What to Provide

**Required:**
- Campaign names
- Current budget (daily or monthly)
- Current spend
- Conversions
- CPA

**Recommended:**
- Target CPA or ROAS
- Total budget constraint
- Whether each campaign is budget-capped

**Optional:**
- Impression share (especially IS lost to budget)
- Historical performance at different spend levels
- Conversion values

## What You'll Get

1. **Current State Analysis** - Campaigns ranked by efficiency
2. **Reallocation Recommendations** - Specific moves with amounts
3. **Impact Projections** - Expected conversion gains
4. **Risk Assessment** - What could go wrong
5. **Implementation Plan** - Step-by-step with monitoring

## Pro Tips

- Always include whether campaigns are hitting their budget caps
- Run this monthly or whenever you see big efficiency differences between campaigns
- Start with small reallocations (20%) and scale up based on results
- Keep some budget in underperformers if they serve strategic purposes (brand, conquest)
