# How to Use This Skill

Hey Claude—I just added the "bid-strategy-auditor" skill. Can you evaluate if my Target CPA bidding is actually working?

## Example Invocations

**Example 1: Full Audit**
Hey Claude—I just added the "bid-strategy-auditor" skill. I've been running Target CPA at $50 for 6 weeks but my actual CPA is $68. Here's my campaign data—is Smart Bidding the problem?

**Example 2: Strategy Selection**
Hey Claude—I just added the "bid-strategy-auditor" skill. I'm getting about 25 conversions per month. Should I use Target CPA or stick with Manual CPC?

**Example 3: Underperformance Diagnosis**
Hey Claude—I just added the "bid-strategy-auditor" skill. My Max Conversions campaign CPA keeps creeping up month over month. What's going wrong?

**Example 4: Switch Recommendation**
Hey Claude—I just added the "bid-strategy-auditor" skill. Google keeps recommending I switch to Target ROAS. Here's my data—should I make the change?

**Example 5: Learning Period Concerns**
Hey Claude—I just added the "bid-strategy-auditor" skill. My campaign has been in "Learning" status for 3 weeks. Is that normal?

## What to Provide

**Required:**
- Current bid strategy and how long it's been running
- Target CPA or ROAS (if applicable)
- Last 30 days: conversions, cost, actual CPA/ROAS
- Campaign-level breakdown

**Recommended:**
- Strategy status (Learning, Limited, Eligible)
- Before/after comparison if you recently switched
- Conversion lag time
- Monthly conversion volume

**Optional:**
- Auction insights (impression share)
- Historical performance on different strategies
- Recent changes made to account

## What You'll Get

1. **Data Sufficiency Check** - Do you have enough conversions for your strategy?
2. **Performance Analysis** - Is the strategy hitting targets?
3. **Diagnosis** - Why it's working or not working
4. **Recommendations** - Stay, adjust, or switch
5. **Transition Plan** - Step-by-step if switching strategies

## Pro Tips

- Run this audit after 4+ weeks on any strategy (learning period needs time)
- Include trend data (weekly breakdown) for better diagnosis
- Be honest about conversion quality—garbage conversions fool Smart Bidding
- If switching strategies, follow the transition plan exactly
