# How to Use This Skill

Hey Claude—I just added the "search-term-gold-miner" skill. Can you analyze my search term report and find wasted spend?

## Example Invocations

**Example 1: Full Analysis**
Hey Claude—I just added the "search-term-gold-miner" skill. Can you review my last 30 days of search terms and tell me what to negate and what to promote? My target CPA is $45.

**Example 2: Quick Waste Hunt**
Hey Claude—I just added the "search-term-gold-miner" skill. Here's my search term export - just find the obvious money wasters I should negate today.

**Example 3: Keyword Discovery**
Hey Claude—I just added the "search-term-gold-miner" skill. I want to find search terms that are converting well but don't have their own keywords yet. Here's my data.

**Example 4: Negative Keyword Audit**
Hey Claude—I just added the "search-term-gold-miner" skill. Can you analyze these search terms and give me a list of negatives I can copy-paste into Google Ads?

## What to Provide

**Required:**
- Search term report (export from Google Ads or paste data)
- Must include: search term, clicks, cost, conversions
- At least 14 days of data (30+ days preferred)

**Recommended:**
- Target CPA or ROAS
- Business context (B2B/B2C, industry)
- Any brand terms to exclude from analysis

**Optional:**
- Existing negative keyword lists
- Conversion values
- Campaign/ad group breakdown

## What You'll Get

1. **Immediate Negatives** - Copy-paste list of terms to block today
2. **Promotion Candidates** - Converting terms that deserve exact match keywords
3. **Watchlist** - Terms needing more data before judgment
4. **Spend Breakdown** - Where your money is actually going
5. **Dollar Impact** - Estimated savings from recommendations
6. **Strategic Insights** - Patterns in your search data

## Pro Tips

- Run this analysis monthly to catch waste early
- Export "All time" first, then filter to last 30-60 days
- Include conversion values if you have them (enables ROAS analysis)
- Save the negative keyword list output directly to a Google Ads shared list
