---
name: month-end-report-generator
description: Creates comprehensive monthly Google Ads performance reports for clients or stakeholders. Triggers when user needs a monthly report, performance summary, client presentation, or month-end review. Transforms raw data into professional narratives with executive summary, goal tracking, campaign analysis, insights, and strategic recommendations. Output ready for PDF, slides, or email.
---

# Month-End Report Generator

Turn a month of data into a story clients actually understand and act on.

## Core Philosophy

**Monthly reports are not data dumps—they're strategic conversations.**

**What Clients Actually Want to Know:**
1. Did we hit our goals? (Yes/No/Close)
2. What did we learn? (Insights that matter)
3. What's the plan? (Clear next steps)
4. Is this working? (ROI confidence)

**The Report Should:**
- Answer questions before they're asked
- Connect activity to outcomes
- Show you're thinking ahead
- Build confidence in the partnership

---

## Required Context

### Must Have

**1. Performance Data - This Month**
- Total spend
- Total conversions
- CPA or ROAS
- Clicks & CTR
- Impressions

**2. Performance Data - Comparison**
At minimum ONE of:
- Last month (MoM comparison)
- Same month last year (YoY comparison)
- Goal/target values

**3. Time Period**
- Month and year (e.g., January 2025)
- Number of days in period

### Strongly Recommended

**4. Goals & Targets**
- Monthly budget target
- Conversion goal
- CPA/ROAS target
- Any secondary KPIs

**5. Campaign Breakdown**
Top campaigns with:
- Spend
- Conversions
- CPA/ROAS
- MoM change

**6. Audience Context**
Who's reading this?
- C-Suite (high-level, ROI focused)
- Marketing Director (strategic + some tactical)
- Marketing Manager (more detail acceptable)
- Client (explain everything, no jargon)

### Nice to Have

- Top performing keywords/ads
- Device/geo/audience breakdowns
- Search term insights
- Competitor observations (auction insights)
- Actions taken during month
- External factors (seasonality, promos, market)

---

## Report Structure

### 1. Executive Summary (The First Thing They Read)

**Format:** 3-4 sentences maximum

**Must Answer:**
- How did we do vs. goals?
- What was the headline story?
- What's the outlook?

**Template:**
"[Month] delivered [X conversions] at [$X CPA / X.X ROAS], [hitting/missing/exceeding] our target of [goal]. [Key driver or headline insight]. [Outlook statement for next month]."

**Examples:**

✅ Good:
"January delivered 342 leads at $47 CPA, beating our $55 target by 15%. The new landing page drove a 23% improvement in conversion rate. February focus: scaling the winning campaigns while maintaining efficiency."

❌ Bad:
"This month we had 342 conversions and spent $16,074. CTR was 3.2% and we got 48,291 impressions. CPA was $47."

---

### 2. Scorecard (Visual Performance Snapshot)

**Primary Metrics Table:**

```
METRIC          THIS MONTH    LAST MONTH    CHANGE    VS GOAL
────────────────────────────────────────────────────────────────
Spend           $XX,XXX       $XX,XXX       +X%       ✓ On budget
Conversions     XXX           XXX           +X%       ✓ 115% of goal
CPA             $XX.XX        $XX.XX        -X%       ✓ Below target
ROAS            X.XX          X.XX          +X%       ✓ Above target
CTR             X.X%          X.X%          +X%       —
Conv Rate       X.X%          X.X%          +X%       —
```

**Traffic Light System:**
- 🟢 Beating goal by 10%+
- 🟡 Within 10% of goal
- 🔴 Missing goal by 10%+

**YoY Comparison (if available):**
```
VS SAME MONTH LAST YEAR:
Conversions: +XX% | CPA: -XX% | Spend: +XX%
```

---

### 3. Goal Performance (Did We Win?)

**For Each Major Goal:**

```
GOAL: [Conversion Target]
Target: XXX conversions
Actual: XXX conversions
Result: ✓ ACHIEVED (+X%) / ✗ MISSED (-X%)

[One sentence on why we hit/missed]
```

**Monthly Budget Utilization:**
```
Budget: $XX,XXX
Spent: $XX,XXX (XX%)
Assessment: [On track / Underspent / Overspent]
[Context if not 100%]
```

---

### 4. Campaign Performance (Where the Money Went)

**Top Performers:**

| Campaign | Spend | Conv | CPA | MoM | Assessment |
|----------|-------|------|-----|-----|------------|
| [Name] | $X,XXX | XX | $XX | +X% | ⭐ Star |
| [Name] | $X,XXX | XX | $XX | +X% | ✅ Solid |

**Needs Attention:**

| Campaign | Spend | Conv | CPA | MoM | Issue |
|----------|-------|------|-----|-----|-------|
| [Name] | $X,XXX | XX | $XX | +X% | [Problem] |

**Campaign Insights:**
- [Campaign]: [What's working and why]
- [Campaign]: [What's struggling and what we're doing]

---

### 5. Key Insights (What We Learned)

**Format:** 3-5 bullets, insight + implication

**Template:**
"[Observation with data] → [What this means] → [What we're doing about it]"

**Examples:**

✅ Good:
"Mobile conversion rate increased 34% after landing page optimization → Mobile now drives 45% of conversions vs 31% last month → Shifting 10% more budget to mobile campaigns"

❌ Bad:
"Mobile did well this month"

**Categories to Cover:**
- **What Worked:** Wins worth repeating
- **What We Learned:** New insights about audience/market
- **What Changed:** Significant shifts from last month
- **What to Watch:** Emerging trends (positive or concerning)

---

### 6. Actions & Optimizations (What We Did)

**Completed This Month:**

| Action | Date | Result |
|--------|------|--------|
| [Specific action] | [Date] | [Measurable outcome] |
| [Specific action] | [Date] | [Measurable outcome] |

**Example:**
| Launched new RSA variations | Jan 12 | +18% CTR, -12% CPA |
| Added 45 negative keywords | Jan 8 | Blocked ~$400 waste |

---

### 7. Next Month Plan (What's Coming)

**Strategic Priorities:**
1. [Priority] - [Why it matters] - [Expected impact]
2. [Priority] - [Why it matters] - [Expected impact]
3. [Priority] - [Why it matters] - [Expected impact]

**Planned Tests:**
- [Test description] - Hypothesis: [Expected outcome]

**Budget/Goal Recommendations:**
- [Any suggested changes with rationale]

**Key Dates:**
- [Any relevant dates: seasonality, promos, events]

---

### 8. Appendix (For Those Who Want More)

**Optional sections based on data available:**

- Device Performance Breakdown
- Geographic Performance
- Day/Hour Performance
- Top Keywords
- Search Term Highlights
- Audience Performance
- Competitor Observations

---

## Tone & Style by Audience

### C-Suite / Executive
- Lead with business outcomes (revenue, ROI)
- 1 page max for main report
- Skip tactical details entirely
- Focus: "Is our investment paying off?"

### Marketing Director
- Balance strategy and results
- Include campaign-level insights
- Show you're thinking ahead
- Focus: "Are we on track? What's the plan?"

### Marketing Manager
- More tactical detail acceptable
- Include test results and learnings
- Specific optimization notes
- Focus: "What happened? What's next?"

### Client (Non-Expert)
- Explain every metric in plain language
- Use analogies for complex concepts
- More context, less jargon
- Focus: "What does this mean for my business?"

---

## Writing Guidelines

### Numbers
- Always show direction AND magnitude
- Round appropriately ($47.23 → $47)
- Compare to something (last month, goal, benchmark)
- Percentages for changes, absolutes for totals

### Headlines
- Lead with the insight, not the data
- Active voice, strong verbs
- No weak language ("slightly," "somewhat")

### Recommendations
- Specific and actionable
- Include expected impact
- Prioritized (what's most important)
- Realistic timeline

### Honesty
- Don't hide bad news—contextualize it
- Own misses, explain the plan
- Avoid defensive language
- Show you're in control

---

## Handling Different Scenarios

### Strong Month (Beat Goals)
- Celebrate appropriately, not excessively
- Explain WHY it went well (not just luck)
- Set expectations for next month
- Identify scaling opportunities

### Weak Month (Missed Goals)
- Acknowledge clearly, don't bury
- Explain contributing factors
- Show the recovery plan
- Put in context (one month ≠ trend)

### Flat Month (Met Goals, No Growth)
- Stability is sometimes the win
- Identify optimization opportunities
- Look for early indicators of change
- Set growth targets for next month

### Incomplete Data
- Note what's missing
- Work with what you have
- Flag limitations in analysis
- Recommend how to get better data

---

## Output Formats

### Full Report (Default)
Complete sections 1-7, formatted for PDF/document

### Slide Deck Format
- 1 slide per section
- Visual-heavy
- Minimal text
- Speaker notes included

### Email Format
- Condensed to 3-4 paragraphs
- Scorecard as simple table
- Key insights as bullets
- Next steps clearly listed

### Executive One-Pager
- Executive summary
- Scorecard
- 3 key insights
- 3 priorities for next month
- Fits on one page

---

## Quality Checklist

Before delivering report:
- [ ] Executive summary answers "how did we do?"
- [ ] All metrics have comparison context
- [ ] Goals clearly shown as hit/miss
- [ ] Campaign insights are specific, not generic
- [ ] Actions taken are documented with results
- [ ] Next month plan is concrete and prioritized
- [ ] Tone matches audience
- [ ] No unexplained jargon
- [ ] Visually scannable (headers, bullets, tables)
- [ ] Would client feel confident sharing with their boss?

---

## Limitations

**I can provide:**
- Clear narrative from performance data
- Professional formatting for any audience
- Trend analysis and insights
- Strategic recommendations

**I cannot provide:**
- Conversion quality analysis (need backend data)
- Revenue/ROI calculations (need value data)
- Competitive analysis (need auction insights)
- Attribution insights (need cross-channel data)

**For richer reports, also provide:**
- Revenue/value data for ROI calculations
- Auction insights for competitive context
- Backend lead quality metrics
- Cross-channel performance data
