# How to Use This Skill

Hey Claude—I just added the "ab-test-designer" skill. Can you help me design a proper A/B test for my new ad headline?

## Example Invocations

**Example 1: Ad Copy Test**
Hey Claude—I just added the "ab-test-designer" skill. I want to test a new headline in my main campaign. Current CTR is 4.2%, I get about 500 clicks per day. Help me design a rigorous test.

**Example 2: Landing Page Test**
Hey Claude—I just added the "ab-test-designer" skill. I think a shorter form will improve conversions. Current CVR is 3.5% from about 200 daily visitors. Design a test plan.

**Example 3: Bid Strategy Test**
Hey Claude—I just added the "ab-test-designer" skill. I'm wondering if Target CPA would beat my manual bidding. Current CPA is $45 with 2-3 conversions per day. Is this test even viable?

**Example 4: Validate a Test Idea**
Hey Claude—I just added the "ab-test-designer" skill. My team wants to test 4 different headlines at once. Is that a good idea? Current CTR is 3.8%.

**Example 5: Calculate Sample Size**
Hey Claude—I just added the "ab-test-designer" skill. How long would I need to run a test to detect a 15% improvement in conversion rate? Current CVR is 2.5%, 150 daily clicks.

## What to Provide

**Required:**
- What you want to test (the change)
- Current performance (baseline metric)
- Traffic volume (daily clicks or visitors)

**Recommended:**
- Why you think this change will work
- Minimum improvement that would matter to you
- Any time or budget constraints

**Optional:**
- Previous test results
- Competitive context
- Seasonality concerns

## What You'll Get

1. **Hypothesis** - Properly formatted, testable hypothesis
2. **Test Design** - Control vs variation with variable isolation
3. **Statistical Requirements** - Sample size, duration, confidence levels
4. **Success Criteria** - Clear win/lose definitions
5. **Execution Plan** - Timeline with checkpoints
6. **Risk Assessment** - What could go wrong and how to mitigate
7. **Documentation Template** - Pre and post-test recording

## Pro Tips

- Always calculate sample size BEFORE starting—many tests fail due to insufficient traffic
- Test one thing at a time—seriously, just one thing
- Don't peek at results and stop early—this creates false positives
- Document everything—build your testing knowledge base
- "Inconclusive" is a valid result—it means you need more traffic or a bigger change
