---
name: facebook-ads-monthly-report
description: Generates professional monthly performance reports for Meta Ads with executive summaries, goal tracking, insights, and actionable recommendations. Creates narrative-driven reports that tell the story behind the numbers. Use for client reporting or internal reviews.
---

# Facebook Ads Monthly Report

Reports aren't data dumps. They're strategic conversations.

## Core Philosophy

**Nobody wants to read a spreadsheet. They want to understand what happened and what to do next.**

A great monthly report does three things:
1. **Answers the first question:** "Did we hit our goals?"
2. **Explains the why:** "What drove the results?"
3. **Guides the next steps:** "What should we do differently?"

**Data without context is noise.** CPA went up 15%—is that bad? Depends. Did you scale budget? Launch new audiences? Hit a holiday lull? The numbers tell you *what* happened. The narrative tells you *why* and *what to do about it*.

**Reports build trust.** When results are good, reports prove your value. When results are bad, reports show you understand the problem and have a plan. Either way, you're demonstrating strategic thinking.

---

## Required Context

### Must Have

1. **Performance Data - This Month**
   - Total spend
   - Total conversions (purchases, leads, etc.)
   - CPA or CPL
   - ROAS (if e-commerce)
   - CTR and CPM
   - Impressions and reach

2. **Performance Data - Last Month (for comparison)**
   - Same metrics as above
   - Or: MoM percentage changes

3. **Goals**
   - Target CPA or ROAS
   - Target conversion volume
   - Budget target/limit

### Strongly Recommended

4. **Campaign-Level Breakdown**
   - Performance by campaign
   - Performance by audience type
   - Top/bottom performers

5. **Key Events & Changes**
   - What changed this month?
   - New campaigns/creatives launched?
   - Budget changes?
   - External factors (holidays, events)?

### Nice to Have

6. **Creative Performance**
   - Top performing ads
   - Creative tests run
   - Learnings from tests

7. **Historical Context**
   - Year-over-year comparison
   - Quarterly trends
   - Seasonal benchmarks

---

## Report Framework

### Section 1: Executive Summary

**Purpose:** Answer the big questions in 30 seconds.

**Structure:**
1. **Headline Result** - One sentence: did we win or lose?
2. **Key Metrics vs Goals** - 3-4 numbers that matter
3. **Main Driver** - What caused the result?
4. **Outlook** - What to expect next month

**Tone Guidelines:**

| Result | Tone | Example |
|--------|------|---------|
| Beat goals | Confident, forward-looking | "Strong month—exceeded targets across the board. Scaling plan on track." |
| Met goals | Balanced, focus on improvements | "Solid performance hitting targets. Identified opportunities for next month." |
| Missed goals | Honest, solution-focused | "Challenging month due to [reason]. Here's the recovery plan." |

---

### Section 2: Goal Tracking

**Goal Status Framework:**

| Status | Definition | Visual |
|--------|------------|--------|
| Exceeded | >110% of target | 🟢 |
| On Target | 90-110% of target | 🟢 |
| Slightly Below | 75-90% of target | 🟡 |
| Missed | <75% of target | 🔴 |

**Goal Tracking Table:**

| Goal | Target | Actual | % of Target | Status |
|------|--------|--------|-------------|--------|
| CPA | $X | $X | X% | [🟢/🟡/🔴] |
| Conversions | X | X | X% | [🟢/🟡/🔴] |
| ROAS | X.Xx | X.Xx | X% | [🟢/🟡/🔴] |
| Spend | $X | $X | X% | [🟢/🟡/🔴] |

---

### Section 3: Performance Analysis

**Month-over-Month Comparison:**

| Metric | Last Month | This Month | Change | Assessment |
|--------|------------|------------|--------|------------|
| Spend | $X | $X | +/-X% | [Good/Neutral/Concern] |
| Conversions | X | X | +/-X% | [Good/Neutral/Concern] |
| CPA | $X | $X | +/-X% | [Good/Neutral/Concern] |
| CTR | X% | X% | +/-X% | [Good/Neutral/Concern] |
| CPM | $X | $X | +/-X% | [Good/Neutral/Concern] |

**Performance Narrative Questions:**
- What drove the biggest changes?
- Were changes expected or unexpected?
- What external factors influenced results?
- How did changes compound (e.g., higher CPM + lower CTR = much higher CPA)?

---

### Section 4: Campaign Performance

**Campaign Breakdown:**

| Campaign | Spend | Conv. | CPA | ROAS | vs Last Month | Status |
|----------|-------|-------|-----|------|---------------|--------|
| [Name] | $X | X | $X | X.Xx | +/-X% CPA | [🟢/🟡/🔴] |

**Campaign Insights:**
1. **Winners:** Which campaigns drove best results?
2. **Underperformers:** Which need attention?
3. **Changes:** What was added/removed/scaled?
4. **Learnings:** What did we learn about each?

---

### Section 5: Audience Insights

**Audience Performance:**

| Audience Type | Spend | Conv. | CPA | % of Total | Notes |
|---------------|-------|-------|-----|------------|-------|
| Prospecting - LAL | $X | X | $X | X% | [Notes] |
| Prospecting - Interest | $X | X | $X | X% | [Notes] |
| Retargeting | $X | X | $X | X% | [Notes] |

**Funnel Health Check:**
- Prospecting → Retargeting flow healthy?
- Any audience saturation?
- New audiences tested?

---

### Section 6: Creative Performance

**Top Performing Ads:**

| Rank | Ad Name | Spend | Conv. | CPA | CTR | What Made It Work |
|------|---------|-------|-------|-----|-----|-------------------|
| 1 | [Name] | $X | X | $X | X% | [Insight] |
| 2 | [Name] | $X | X | $X | X% | [Insight] |
| 3 | [Name] | $X | X | $X | X% | [Insight] |

**Creative Tests Run:**

| Test | Hypothesis | Result | Learning |
|------|------------|--------|----------|
| [Test name] | [Hypothesis] | [Winner/No winner] | [What we learned] |

**Creative Health:**
- Oldest active ad age
- New creative added this month
- Fatigue indicators (frequency, CTR trends)

---

### Section 7: What Worked & What Didn't

**What Worked:**
- Specific tactics, campaigns, or creatives that drove results
- Why they worked (hypothesis)
- How to capitalize going forward

**What Didn't Work:**
- Specific underperformers or failed tests
- Why they didn't work (diagnosis)
- What we're doing about it

**Unexpected Findings:**
- Surprises—good or bad
- What they might mean
- How we'll investigate further

---

### Section 8: Next Month Plan

**Priorities:**
1. [Priority 1 with specific action]
2. [Priority 2 with specific action]
3. [Priority 3 with specific action]

**Planned Changes:**
- Budget adjustments
- New campaigns or audiences
- Creative tests planned
- Optimizations to make

**Goals for Next Month:**

| Goal | Target | Rationale |
|------|--------|-----------|
| CPA | $X | [Why this target] |
| Conversions | X | [Why this target] |
| Spend | $X | [Why this target] |

---

## Output Format

```
═══════════════════════════════════════════════════════════════════
FACEBOOK ADS MONTHLY PERFORMANCE REPORT
[Client/Account Name]
[Month Year]
Prepared: [Date]
═══════════════════════════════════════════════════════════════════

📋 EXECUTIVE SUMMARY
────────────────────────────────────────────────────────────────────

**Headline:** [One sentence summary of the month]

**Key Results:**
| Metric | Target | Actual | Status |
|--------|--------|--------|--------|
| [Metric] | [Target] | [Actual] | [🟢/🟡/🔴] |

**What Drove Results:**
[2-3 sentence explanation of main factors]

**Outlook:**
[1-2 sentence forward-looking statement]

═══════════════════════════════════════════════════════════════════

🎯 GOAL TRACKING
────────────────────────────────────────────────────────────────────

| Goal | Target | Actual | % of Target | Status |
|------|--------|--------|-------------|--------|
| CPA | $[X] | $[X] | [X]% | [🟢/🟡/🔴] |
| Conversions | [X] | [X] | [X]% | [🟢/🟡/🔴] |
| ROAS | [X.Xx] | [X.Xx] | [X]% | [🟢/🟡/🔴] |
| Spend | $[X] | $[X] | [X]% | [🟢/🟡/🔴] |

**Goal Commentary:**
[Brief explanation of goal performance]

═══════════════════════════════════════════════════════════════════

📊 MONTH-OVER-MONTH PERFORMANCE
────────────────────────────────────────────────────────────────────

| Metric | [Last Month] | [This Month] | Change | Assessment |
|--------|--------------|--------------|--------|------------|
| Spend | $[X] | $[X] | [+/-X]% | [Assessment] |
| Conversions | [X] | [X] | [+/-X]% | [Assessment] |
| CPA | $[X] | $[X] | [+/-X]% | [Assessment] |
| ROAS | [X.Xx] | [X.Xx] | [+/-X]% | [Assessment] |
| CTR | [X]% | [X]% | [+/-X]% | [Assessment] |
| CPM | $[X] | $[X] | [+/-X]% | [Assessment] |
| Impressions | [X] | [X] | [+/-X]% | [Assessment] |

**Performance Narrative:**
[Paragraph explaining the story behind the numbers]

═══════════════════════════════════════════════════════════════════

📈 CAMPAIGN BREAKDOWN
────────────────────────────────────────────────────────────────────

| Campaign | Spend | Conv. | CPA | ROAS | MoM Change | Status |
|----------|-------|-------|-----|------|------------|--------|
| [Name] | $[X] | [X] | $[X] | [X.Xx] | [+/-X]% | [🟢/🟡/🔴] |

**Campaign Insights:**

**🏆 Top Performer: [Campaign Name]**
[Why it performed well, what we learned]

**⚠️ Needs Attention: [Campaign Name]**
[What went wrong, what we're doing about it]

═══════════════════════════════════════════════════════════════════

👥 AUDIENCE INSIGHTS
────────────────────────────────────────────────────────────────────

**Performance by Audience Type:**

| Audience | Spend | % of Total | Conv. | CPA | Performance |
|----------|-------|------------|-------|-----|-------------|
| Prospecting - LAL | $[X] | [X]% | [X] | $[X] | [Assessment] |
| Prospecting - Broad | $[X] | [X]% | [X] | $[X] | [Assessment] |
| Retargeting | $[X] | [X]% | [X] | $[X] | [Assessment] |

**Audience Notes:**
[Key observations about audience performance]

═══════════════════════════════════════════════════════════════════

🎨 CREATIVE PERFORMANCE
────────────────────────────────────────────────────────────────────

**Top 3 Ads This Month:**

| Rank | Ad | Spend | Conv. | CPA | CTR | Why It Worked |
|------|----|----|-------|-----|-----|---------------|
| 1 | [Name] | $[X] | [X] | $[X] | [X]% | [Insight] |
| 2 | [Name] | $[X] | [X] | $[X] | [X]% | [Insight] |
| 3 | [Name] | $[X] | [X] | $[X] | [X]% | [Insight] |

**Creative Tests:**

| Test | Result | Learning |
|------|--------|----------|
| [Test] | [Outcome] | [What we learned] |

**Creative Health:**
- New creative added: [X ads]
- Oldest active ad: [X days]
- Creative refresh needed: [Yes/No]

═══════════════════════════════════════════════════════════════════

✅ WHAT WORKED
────────────────────────────────────────────────────────────────────

1. **[Success 1]**
   - What: [Description]
   - Impact: [Quantified impact]
   - Next Step: [How to capitalize]

2. **[Success 2]**
   - What: [Description]
   - Impact: [Quantified impact]
   - Next Step: [How to capitalize]

═══════════════════════════════════════════════════════════════════

⚠️ WHAT DIDN'T WORK
────────────────────────────────────────────────────────────────────

1. **[Challenge 1]**
   - What: [Description]
   - Impact: [Quantified impact]
   - Fix: [What we're doing about it]

2. **[Challenge 2]**
   - What: [Description]
   - Impact: [Quantified impact]
   - Fix: [What we're doing about it]

═══════════════════════════════════════════════════════════════════

🔮 NEXT MONTH PLAN
────────────────────────────────────────────────────────────────────

**Top 3 Priorities:**
1. [Priority with specific action]
2. [Priority with specific action]
3. [Priority with specific action]

**Planned Changes:**
- [ ] [Change 1]
- [ ] [Change 2]
- [ ] [Change 3]

**Next Month Goals:**

| Goal | Target | Rationale |
|------|--------|-----------|
| CPA | $[X] | [Why] |
| Conversions | [X] | [Why] |
| Spend | $[X] | [Why] |

═══════════════════════════════════════════════════════════════════

📝 APPENDIX (Optional)
────────────────────────────────────────────────────────────────────

[Additional detailed data, charts, or breakdowns as needed]

═══════════════════════════════════════════════════════════════════
```

---

## Common Scenarios

### Scenario 1: "Great month, everything is up"
**Approach:**
- Lead with wins, but stay humble
- Explain what drove success (don't take credit for luck)
- Set realistic expectations for continuation
- Identify risks (can this be sustained?)

**Verdict:** Celebrate, but anchor in specifics. "CPA improved 20% because we scaled winning creative X" > "Great month overall!"

### Scenario 2: "Bad month, CPA way up"
**Approach:**
- Acknowledge the miss directly (don't hide it)
- Explain what happened (external factors, internal decisions)
- Present the recovery plan with specifics
- Set realistic expectations for turnaround time

**Verdict:** Honesty builds trust. "CPA increased 25% due to creative fatigue. Here's our 2-week refresh plan."

### Scenario 3: "Mixed results—some good, some bad"
**Approach:**
- Lead with the overall picture
- Highlight wins to establish competence
- Address misses with clear explanations
- Show how wins inform fixes for the misses

**Verdict:** Balance is key. Don't over-index on either wins or losses.

### Scenario 4: "Client only cares about ROAS"
**Approach:**
- Lead with ROAS in executive summary
- Connect all other metrics back to ROAS
- Explain trade-offs (e.g., "we could improve ROAS by cutting spend, but...")
- Frame recommendations in ROAS terms

**Verdict:** Speak their language. If ROAS is the goal, make it the protagonist.

### Scenario 5: "First month of running ads"
**Approach:**
- Set expectations: this is baseline establishment
- Focus on learnings over absolute performance
- Highlight what's working to scale
- Identify what to fix before scaling

**Verdict:** Frame as "learning month." The goal wasn't to crush it—it was to learn.

---

## Limitations

1. **Cannot access actual ad data** - Relies on user-provided metrics
2. **Cannot predict future performance** - Provides projections, not guarantees
3. **Cannot account for all external factors** - Market conditions, competitors unknown
4. **Report quality depends on input quality** - Garbage in, garbage out
5. **Cannot replace strategic judgment** - Framework, not autopilot
6. **One report format** - May need customization for specific clients

---

## Quality Checklist

Before delivering report:
- [ ] Executive summary answers "did we hit goals?"
- [ ] All goals tracked with clear status
- [ ] Month-over-month comparison included
- [ ] Campaign breakdown with insights
- [ ] What worked AND what didn't addressed
- [ ] Next month plan is specific and actionable
- [ ] Tone appropriate for results (not overly positive or negative)
- [ ] Data is accurate and consistent throughout
- [ ] Client's priority metrics are prominently featured
