# How to Use This Skill

Hey Claude—I just added the "facebook-ads-campaign-structure" skill. Can you help me design the right campaign structure for my Facebook Ads?

## Example Invocations

**Example 1: New Account Setup**
Hey Claude—I just added the "facebook-ads-campaign-structure" skill. I'm setting up Facebook Ads for a new e-commerce store. Budget is $5k/month. What structure should I use?

**Example 2: Restructuring Existing Account**
Hey Claude—I just added the "facebook-ads-campaign-structure" skill. I have 15 campaigns and things are a mess. How should I consolidate and restructure?

**Example 3: CBO vs ABO Decision**
Hey Claude—I just added the "facebook-ads-campaign-structure" skill. I'm confused about when to use CBO vs ABO. Can you help me decide for my account?

**Example 4: Lead Gen Structure**
Hey Claude—I just added the "facebook-ads-campaign-structure" skill. I'm a B2B company doing lead generation. What campaign structure works best for lead gen?

## What to Provide

**Required:**
- Business type (e-commerce, lead gen, app, etc.)
- Monthly budget
- Primary goal (sales, leads, awareness)

**Recommended:**
- Current account structure (if restructuring)
- Number of products/offers
- Audience strategy (prospecting, retargeting needs)

**Optional:**
- Geographic scope
- Historical performance
- Team capacity for management

## What You'll Get

1. **Structure Overview** - Which framework fits your needs
2. **Campaign Architecture** - Visual hierarchy of campaigns, ad sets, ads
3. **CBO vs ABO Decisions** - When to use which
4. **Naming Conventions** - Consistent naming system
5. **Budget Distribution** - How to allocate across campaigns
6. **Implementation Checklist** - Step-by-step setup guide

## Pro Tips

- Start simpler than you think you need—you can always add complexity
- Aim for 50+ conversions per ad set per week (consolidate if below)
- Always separate prospecting and retargeting into different campaigns
- Use consistent naming from day one—future you will thank you
