---
name: facebook-ads-audience-builder
description: Designs comprehensive Meta Ads audience strategies including custom audiences, lookalikes, and targeting configurations. Creates audience architecture with overlap prevention and funnel alignment. Use when planning targeting strategy or building new audiences.
---

# Facebook Ads Audience Builder

The right audience is 80% of the battle. Everything else is optimization.

## Core Philosophy

**You're not buying clicks. You're buying access to people.**

The most beautiful ad in the world will fail if shown to the wrong people. The ugliest ad will print money if shown to the right ones. Your audience strategy determines:
- Who sees your ads
- How much you pay to reach them
- Whether they'll ever convert

**Meta's algorithm is powerful, but it needs direction.** Feed it garbage signals (wrong audiences, bad pixel data) and it optimizes for garbage. Feed it gold (high-value customers, clean data) and it finds more gold.

**The goal isn't the biggest audience. It's the most valuable audience at the lowest cost.**

---

## Required Context

### Must Have

1. **Business Information**
   - What do you sell? (Product/service type)
   - Average order value or customer value
   - Who is your ideal customer? (Demographics, interests, behaviors)

2. **Current Assets**
   - Website traffic volume (monthly visitors)
   - Email list size
   - Existing customer count
   - Social media followers

3. **Goals**
   - Primary objective (Sales, Leads, App installs)
   - Target CPA or ROAS
   - Monthly budget range

### Strongly Recommended

4. **Performance Data (if running ads)**
   - Which audiences have worked?
   - Which have failed?
   - Current best-performing audience

5. **Customer Data**
   - Purchase history available?
   - Customer LTV segments?
   - Geographic concentration?

### Nice to Have

6. **Competitive Context**
   - Who are main competitors?
   - What makes your customers choose you?

---

## Audience Strategy Framework

### Phase 1: Audience Inventory Assessment

**What assets do you have to build from?**

| Asset | Minimum for Audience | Quality Rating | Use Case |
|-------|---------------------|----------------|----------|
| Website Visitors | 1,000+ | ⭐⭐⭐ | Retargeting, LAL source |
| Purchasers/Converters | 100+ (1,000+ ideal) | ⭐⭐⭐⭐⭐ | Best LAL source |
| Email List | 1,000+ | ⭐⭐⭐⭐ | Custom audience, LAL source |
| Video Viewers | 1,000+ | ⭐⭐⭐ | Engagement retargeting |
| IG/FB Engagers | 1,000+ | ⭐⭐ | Warm audience |
| App Users | 1,000+ | ⭐⭐⭐⭐ | High-intent source |

**Quality Hierarchy (Best to Worst LAL Sources):**
1. High-LTV Purchasers (top 25%)
2. All Purchasers
3. Add to Cart (didn't purchase)
4. Email Subscribers
5. Website Visitors (high engagement)
6. All Website Visitors
7. Social Engagers

---

### Phase 2: Funnel-Based Audience Architecture

**The Three Audience Tiers:**

```
┌─────────────────────────────────────────────────────────┐
│                    COLD (Prospecting)                   │
│  People who don't know you exist                        │
│  Goal: Introduce brand, generate awareness              │
│  Budget: 60-70% of total                                │
│  Audiences: Lookalikes, Interest, Broad/Advantage+      │
├─────────────────────────────────────────────────────────┤
│                    WARM (Consideration)                 │
│  People who've engaged but not converted                │
│  Goal: Move toward conversion                           │
│  Budget: 15-25% of total                                │
│  Audiences: Video viewers, Engagers, Site visitors      │
├─────────────────────────────────────────────────────────┤
│                    HOT (Conversion)                     │
│  People ready to buy                                    │
│  Goal: Close the sale                                   │
│  Budget: 10-20% of total                                │
│  Audiences: Cart abandoners, High-intent visitors       │
└─────────────────────────────────────────────────────────┘
```

---

### Phase 3: Custom Audience Recommendations

**Website Custom Audiences:**

| Audience Name | Definition | Window | Use Case | Priority |
|---------------|------------|--------|----------|----------|
| All Visitors | All website traffic | 180 days | LAL source, broad retargeting | High |
| Engaged Visitors | Top 25% by time on site | 180 days | Better LAL source | High |
| Product Viewers | Viewed product pages | 30 days | Warm retargeting | High |
| Cart Abandoners | Added to cart, no purchase | 14 days | Hot retargeting | Critical |
| Purchasers | Completed purchase | 180 days | LAL source, exclusion | Critical |
| Recent Purchasers | Completed purchase | 30 days | Exclude from prospecting | Critical |
| High-Value Purchasers | Multiple purchases or high AOV | 180 days | Best LAL source | Critical |

**Engagement Custom Audiences:**

| Audience Name | Definition | Window | Use Case |
|---------------|------------|--------|----------|
| Video Viewers 50%+ | Watched 50%+ of any video | 365 days | Warm audience, LAL source |
| Video Viewers 95%+ | Watched 95%+ of any video | 365 days | High-intent, LAL source |
| FB Page Engagers | Any engagement with Page | 365 days | Warm audience |
| IG Profile Engagers | Any engagement with Profile | 365 days | Warm audience |
| Ad Engagers | Engaged with any ad | 365 days | Warm audience |

**Customer List Audiences:**

| Audience Name | Definition | Use Case | Refresh Frequency |
|---------------|------------|----------|-------------------|
| All Customers | Full customer list | LAL source, exclusion | Monthly |
| High-LTV Customers | Top 25% by lifetime value | Best LAL source | Monthly |
| Recent Customers | Purchased last 90 days | Exclusion from acquisition | Weekly |
| Lapsed Customers | No purchase 180+ days | Win-back campaigns | Monthly |
| Email Subscribers | Non-customers on list | Warm audience | Monthly |

---

### Phase 4: Lookalike Audience Strategy

**Lookalike Percentage Guide:**

| Percentage | Audience Size (US) | Quality vs. Scale | Best For |
|------------|-------------------|-------------------|----------|
| 1% | ~2.1M | Highest quality, smallest | Limited budget, high CPA tolerance |
| 2% | ~4.2M | High quality | Most advertisers, best balance |
| 3% | ~6.3M | Good quality | Higher budgets, broader reach |
| 5% | ~10.5M | Moderate quality | Scale priority, lower CPAs |
| 10% | ~21M | Lower quality, largest | Maximum reach, brand awareness |

**Recommended LAL Structure:**

| LAL Source | Percentage | Expected Quality | Use Case |
|------------|------------|------------------|----------|
| High-LTV Purchasers | 1-2% | ⭐⭐⭐⭐⭐ | Primary prospecting |
| All Purchasers | 2-3% | ⭐⭐⭐⭐ | Secondary prospecting |
| Add to Cart | 2-3% | ⭐⭐⭐ | Scale when purchaser LAL saturates |
| Website Visitors | 3-5% | ⭐⭐ | Broader reach |
| Video Viewers 95% | 2-3% | ⭐⭐⭐ | Engagement-based prospecting |

**LAL Best Practices:**
- Source audience minimum: 1,000 people (ideal: 5,000+)
- Don't stack LALs (1-2% AND 2-3%) in same ad set—overlap
- Refresh LAL sources monthly for freshness
- Country-specific LALs outperform multi-country

---

### Phase 5: Advantage+ and Broad Targeting

**When to Use Advantage+ Audience:**

| Scenario | Recommendation |
|----------|----------------|
| New account, limited data | ✅ Start with Advantage+ |
| High-converting pixel (1000+ monthly conversions) | ✅ Advantage+ often wins |
| Niche product, small TAM | ❌ Too broad, use LAL |
| Proven LAL audiences working | 🔄 Test Advantage+ as additional |
| Retargeting campaign | ❌ Use defined custom audiences |

**Advantage+ Detailed Targeting:**

| Setting | When to Enable | When to Disable |
|---------|----------------|-----------------|
| Expand interests | Testing phase, scale priority | Niche targeting, limited budget |
| Expand lookalikes | High budget, proven creative | New LAL, unproven creative |

**Broad Targeting (No targeting):**
- Requires strong pixel signal (10,000+ conversions historically)
- Works best with high-volume conversion events
- Let the algorithm find your customers
- Monitor closely—can waste budget if pixel data is weak

---

### Phase 6: Audience Overlap Prevention

**Overlap Rules:**

| Scenario | Risk | Solution |
|----------|------|----------|
| LAL 1% and LAL 3% in different ad sets | 🔴 High—1% is subset of 3% | Use only one, or exclude 1% from 3% |
| Retargeting and Prospecting same campaign | 🔴 High—visitors in both | Exclude website visitors from prospecting |
| Multiple interest stacks | 🟡 Medium—likely overlap | Combine into single ad set |
| Same Custom Audience in multiple campaigns | 🔴 High—bidding against yourself | Use in one place only |

**Standard Exclusions:**

| Audience Type | Exclude From |
|---------------|--------------|
| Purchasers (30 days) | All prospecting campaigns |
| Cart Abandoners | General retargeting (separate campaign) |
| Converters | Lead gen campaigns |
| Existing Customers | Acquisition campaigns |

---

### Phase 7: Audience Sizing Guidelines

**Prospecting Audiences:**

| Budget/Day | Minimum Audience Size | Ideal Audience Size |
|------------|----------------------|---------------------|
| <$50 | 500,000 | 1-2 million |
| $50-200 | 1 million | 2-5 million |
| $200-500 | 2 million | 5-10 million |
| $500+ | 5 million+ | 10+ million |

**Retargeting Audiences:**

| Audience Type | Minimum Size | Below Minimum Action |
|---------------|--------------|---------------------|
| Cart Abandoners | 500 | Expand window (14→30 days) |
| Website Visitors | 1,000 | Expand window, add engagers |
| Purchasers (for retargeting) | 500 | Combine with other warm audiences |

**Too Small = High CPMs, Limited Delivery**
**Too Large = Diluted quality, wasted spend**

---

## Output Format

```
═══════════════════════════════════════════════════════════════════
FACEBOOK ADS AUDIENCE STRATEGY
Business: [Business Name]
Created: [Date]
Objective: [Sales/Leads/etc.]
Monthly Budget: $[X]
═══════════════════════════════════════════════════════════════════

📊 AUDIENCE INVENTORY
────────────────────────────────────────────────────────────────────

| Asset | Available | Size | Quality for LAL |
|-------|-----------|------|-----------------|
| Website Visitors | [Y/N] | [Size] | [⭐ rating] |
| Purchasers | [Y/N] | [Size] | [⭐ rating] |
| Email List | [Y/N] | [Size] | [⭐ rating] |
| Video Viewers | [Y/N] | [Size] | [⭐ rating] |
| Social Engagers | [Y/N] | [Size] | [⭐ rating] |

Best LAL Source Available: [Source name]

═══════════════════════════════════════════════════════════════════

🎯 RECOMMENDED AUDIENCE ARCHITECTURE
────────────────────────────────────────────────────────────────────

### TIER 1: HOT AUDIENCES (Conversion Focus)
Budget Allocation: [X]% (~$[X]/day)

| Audience Name | Type | Size | Window | Priority |
|---------------|------|------|--------|----------|
| [Name] | [Custom/LAL/etc.] | [Size] | [Window] | [P1/P2/P3] |

**Exclusions:** [List]

────────────────────────────────────────────────────────────────────

### TIER 2: WARM AUDIENCES (Consideration)
Budget Allocation: [X]% (~$[X]/day)

| Audience Name | Type | Size | Window | Priority |
|---------------|------|------|--------|----------|
| [Name] | [Custom/LAL/etc.] | [Size] | [Window] | [P1/P2/P3] |

**Exclusions:** [List]

────────────────────────────────────────────────────────────────────

### TIER 3: COLD AUDIENCES (Prospecting)
Budget Allocation: [X]% (~$[X]/day)

| Audience Name | Type | Size | Window | Priority |
|---------------|------|------|--------|----------|
| [Name] | [Custom/LAL/etc.] | [Size] | [Window] | [P1/P2/P3] |

**Exclusions:** [List]

═══════════════════════════════════════════════════════════════════

🔧 CUSTOM AUDIENCES TO CREATE
────────────────────────────────────────────────────────────────────

### Website Custom Audiences

| # | Audience Name | Source | Rules | Window |
|---|---------------|--------|-------|--------|
| 1 | [Name] | Website | [Rules] | [Days] |

### Engagement Custom Audiences

| # | Audience Name | Source | Rules | Window |
|---|---------------|--------|-------|--------|
| 1 | [Name] | [FB/IG/Video] | [Rules] | [Days] |

### Customer List Audiences

| # | Audience Name | Source | Segment | Refresh |
|---|---------------|--------|---------|---------|
| 1 | [Name] | [CRM/Email] | [Segment] | [Frequency] |

═══════════════════════════════════════════════════════════════════

📈 LOOKALIKE AUDIENCES TO CREATE
────────────────────────────────────────────────────────────────────

| # | LAL Name | Source Audience | % | Country | Est. Size |
|---|----------|-----------------|---|---------|-----------|
| 1 | [Name] | [Source] | [%] | [Country] | [Size] |

**LAL Testing Priority:**
1. [First to test]
2. [Second to test]
3. [Third to test]

═══════════════════════════════════════════════════════════════════

⚠️ OVERLAP PREVENTION RULES
────────────────────────────────────────────────────────────────────

| When Using | Exclude |
|------------|---------|
| [Audience] | [Exclusion list] |

═══════════════════════════════════════════════════════════════════

📋 IMPLEMENTATION CHECKLIST
────────────────────────────────────────────────────────────────────

**Week 1: Foundation**
- [ ] Create website custom audiences
- [ ] Upload customer lists
- [ ] Create engagement audiences

**Week 2: Lookalikes**
- [ ] Create LAL from best source
- [ ] Set up exclusions
- [ ] Launch prospecting test

**Ongoing:**
- [ ] Refresh customer lists monthly
- [ ] Check audience overlap quarterly
- [ ] Test new LAL sources as data grows

═══════════════════════════════════════════════════════════════════

💡 STRATEGIC NOTES
────────────────────────────────────────────────────────────────────

[Specific strategic recommendations based on the business]

═══════════════════════════════════════════════════════════════════
```

---

## Common Scenarios

### Scenario 1: "Brand new account, no pixel data"
**Approach:**
- Start with interest-based targeting or Advantage+
- Use customer email list for LAL if available
- Build website custom audiences immediately (they'll populate over time)
- Run traffic/engagement campaigns first to build retargeting pools

**Verdict:** Focus on data collection first. Audiences will improve with data.

### Scenario 2: "Small email list (500 people), no purchasers yet"
**Approach:**
- Upload list but don't expect strong LAL performance
- Use interest targeting as primary prospecting
- Create website visitor audiences immediately
- Once you hit 100+ conversions, create purchaser LAL

**Verdict:** Interest/Advantage+ until you have conversion data.

### Scenario 3: "High volume e-commerce (1000+ purchases/month)"
**Approach:**
- Segment purchasers by LTV (top 25% = best LAL source)
- Test broad targeting / Advantage+ (strong pixel signal)
- Create time-based segments (7d, 30d, 90d purchasers)
- Consider value-based LALs

**Verdict:** Leverage rich data for sophisticated segmentation.

### Scenario 4: "B2B lead generation"
**Approach:**
- Website visitors + LinkedIn for B2B intent
- Lead form engagers as warm audience
- SQL/qualified leads as LAL source (not all leads)
- Longer windows (60-90 days) for longer sales cycles

**Verdict:** Quality over quantity—LAL from qualified leads only.

### Scenario 5: "Local business (single city)"
**Approach:**
- Geo-restrict all audiences to service area
- Website visitors in area = gold
- Local customer list = best LAL source
- Don't use broad targeting (will waste on non-serviceable areas)

**Verdict:** Geo-targeting is critical. Smaller audiences are okay.

---

## Limitations

1. **Cannot create audiences for you** - Provides strategy, user must implement in Ads Manager
2. **Cannot access actual audience sizes** - Estimates based on typical ranges
3. **Cannot guarantee audience performance** - Strategy based on best practices
4. **Audience quality depends on source data** - Garbage in, garbage out
5. **Meta's algorithm changes** - Recommendations based on current best practices
6. **Cannot account for all industries** - Some verticals have unique considerations

---

## Quality Checklist

Before delivering audience strategy:
- [ ] All three funnel tiers addressed (Cold, Warm, Hot)
- [ ] Budget allocation percentages provided
- [ ] Specific audiences named and defined
- [ ] Lookalike strategy with percentages
- [ ] Overlap prevention rules specified
- [ ] Exclusions clearly defined
- [ ] Implementation checklist included
- [ ] Audience sizes appropriate for budget
