# How to Use This Skill

Hey Claude—I just added the "cross-platform-budget-allocator" skill. Can you help me figure out how to split my ad budget across Google, Meta, and TikTok?

## Example Invocations

**Example 1: Full Allocation Analysis**
Hey Claude—I just added the "cross-platform-budget-allocator" skill. I have $50K/month to spend across Google Ads, Meta Ads, and LinkedIn. Here's my performance by platform. How should I allocate?

**Example 2: Budget Increase**
Hey Claude—I just added the "cross-platform-budget-allocator" skill. My budget is increasing from $30K to $45K next month. I currently run Google and Meta. Should I add a new channel or scale existing ones?

**Example 3: Rebalancing**
Hey Claude—I just added the "cross-platform-budget-allocator" skill. Meta performance has dropped 30% in the last month while Google stayed flat. Should I shift budget? How much?

**Example 4: New Platform Decision**
Hey Claude—I just added the "cross-platform-budget-allocator" skill. I'm considering adding TikTok to my mix. How much should I test with, and where should that budget come from?

**Example 5: Efficiency vs. Volume**
Hey Claude—I just added the "cross-platform-budget-allocator" skill. I need to hit 500 conversions next month but also keep CPA under $50. Here's my platform data—how do I balance volume and efficiency?

## What to Provide

**Required:**
- Platforms you're currently running (or considering)
- Monthly spend per platform
- Conversions (or revenue) per platform
- CPA or ROAS per platform
- Total budget to allocate
- Primary goal (efficiency vs. volume)

**Recommended:**
- Target CPA or ROAS
- Trend direction per platform (improving/declining/stable)
- Any saturation signals (impression share, frequency)
- Constraints (minimums, maximums, brand carve-outs)

**Optional:**
- Historical performance at different spend levels
- Attribution setup/windows
- Customer journey insights
- Seasonality patterns
- Competitive context

## What You'll Get

1. **Current State Analysis** - Performance comparison across platforms
2. **Efficiency Ranking** - Which platforms deserve more budget
3. **Recommended Allocation** - Specific dollar amounts per platform
4. **Rationale** - Why each change is recommended
5. **Projected Outcomes** - Expected CPA/ROAS/volume at new allocation
6. **Scenario Comparison** - Conservative/Balanced/Aggressive options
7. **Implementation Plan** - How to make changes gradually
8. **Monitoring Framework** - When to rebalance

## Pro Tips

- Provide performance data for the same time period across all platforms
- Include impression share or frequency data—it reveals scaling headroom
- Be clear about constraints (can't reduce Platform X below $Y)
- If attribution differs by platform, mention it—affects comparisons
- Budget shifts should be gradual (25% max at a time)—algorithms need time to adjust
