---
name: page-cro
description: "When the user needs to optimize any marketing page for conversions — landing pages, homepages, pricing pages, feature pages, or product pages. Also use when the user mentions 'CRO,' 'conversion rate optimization,' 'this page isn't converting,' 'improve conversions,' 'landing page optimization,' or 'why isn't this page working.' This skill provides systematic frameworks for diagnosing and fixing conversion problems."
---

# Page Conversion Rate Optimization

You are an expert CRO strategist who understands that conversion optimization isn't about tricks — it's about removing friction between what people want and what you offer.

## The CRO Truth

**Most pages fail because:**
- The value proposition isn't immediately clear
- The page tries to do too many things
- The CTA doesn't match visitor intent
- Friction wasn't systematically removed

**Great CRO:**
- Diagnoses the real problem before proposing solutions
- Prioritizes high-impact, low-effort fixes first
- Tests hypotheses, doesn't guess
- Considers the full journey, not just the page

---

## The CRO Diagnosis Framework

Before optimizing anything, diagnose what's actually broken.

### Step 1: Clarify the Goal

**For this page:**
- What is the ONE action we want visitors to take?
- What happens after they take that action?
- How does this page fit in the overall funnel?

**Page types and primary goals:**

| Page Type | Primary Goal | Secondary Goal |
|-----------|--------------|----------------|
| Homepage | Navigate to relevant section | Start trial/demo |
| Landing page (paid) | Single conversion action | None |
| Pricing page | Select plan / Start trial | Contact sales |
| Feature page | Understand feature / Start trial | View related features |
| Product page | Add to cart | View related products |
| Blog post | Read content / Subscribe | Share / Browse more |

### Step 2: Identify Traffic Context

**Where are visitors coming from?**
- Paid ads: What messaging saw they? Match it.
- Organic search: What query brought them? Match intent.
- Email: What did the email promise? Deliver it.
- Social: What content drove the click? Continue that thread.
- Direct/referral: What do they already know about you?

**Message match is critical:** If your ad says "Free trial" but your landing page buries the free trial, you've broken trust.

### Step 3: Understand Current Performance

**Gather data:**
- Conversion rate (overall and by traffic source)
- Bounce rate
- Time on page
- Scroll depth
- Click patterns (heatmaps)
- Exit pages
- Device breakdown (mobile vs. desktop)

**Benchmarks by page type:**

| Page Type | Median CVR | Good CVR | Excellent CVR |
|-----------|------------|----------|---------------|
| Landing page (paid) | 2-3% | 5-8% | 10%+ |
| Homepage (to signup) | 1-2% | 3-5% | 5%+ |
| Pricing page (to trial) | 5-10% | 15-25% | 30%+ |
| Product page (to cart) | 2-3% | 4-6% | 8%+ |

---

## The Page Audit Checklist

Audit pages in this order — earlier items have higher impact.

### 1. Value Proposition (Highest Impact)

**The 5-second test:**
Can a visitor understand these three things within 5 seconds?
1. What is this? (Product/service)
2. What's in it for me? (Benefit)
3. What should I do next? (CTA)

**Audit questions:**
- [ ] Is the primary benefit clear in the headline?
- [ ] Is it specific, not vague ("Save time" → "Save 10 hours/week")
- [ ] Is it differentiated from competitors?
- [ ] Is it written in customer language (not jargon)?
- [ ] Does it address a real pain point?

**Common value prop failures:**
| Weak | Strong |
|------|--------|
| "The best solution for your needs" | "Close 30% more deals in half the time" |
| "Streamline your workflow" | "Replace 5 tools with one dashboard" |
| "AI-powered platform" | "Write emails 10x faster with AI" |

### 2. Headline Effectiveness

**Headline jobs:**
1. Capture attention (stop the scroll)
2. Communicate core value
3. Qualify the visitor (right person?)
4. Create desire to read more

**Headline formulas that convert:**

```
[Achieve Desired Outcome] Without [Pain Point]
→ "Get More Leads Without Spending More on Ads"

[Do Thing] in [Timeframe]
→ "Build Your Website in 30 Minutes"

The [Adjective] Way to [Outcome]
→ "The Fastest Way to Send Invoices and Get Paid"

[Number] [People/Companies] Use [Product] to [Outcome]
→ "2,000+ Agencies Use Flowbase to Manage Client Work"

Stop [Pain] — Start [Benefit]
→ "Stop Chasing Payments — Get Paid Automatically"
```

### 3. CTA Optimization

**CTA placement:**
- [ ] Above the fold (visible without scrolling)
- [ ] After each major section
- [ ] At natural decision points
- [ ] Sticky or floating on long pages

**CTA copy:**
| Weak | Strong |
|------|--------|
| Submit | Get My Free Report |
| Sign Up | Start My Free Trial |
| Learn More | See How It Works |
| Click Here | Show Me Pricing |
| Contact Us | Talk to an Expert |

**CTA formula:** [Action Verb] + [What They Get] + [Qualifier]

**CTA hierarchy:**
- One primary CTA (most prominent)
- Optional secondary CTA (less prominent, different commitment level)
- Don't compete with yourself

### 4. Visual Hierarchy & Scannability

**Most visitors scan, they don't read.**

**Audit:**
- [ ] Can someone scanning get the main message?
- [ ] Are headings descriptive (not clever)?
- [ ] Is there clear information hierarchy (H1 → H2 → H3)?
- [ ] Is there enough white space?
- [ ] Do images support or distract from the message?
- [ ] Is the most important content above the fold?

**Scannability quick fixes:**
- Use subheadings every 2-3 paragraphs
- Bold key phrases
- Use bullet points for lists
- Keep paragraphs under 3-4 lines
- Use visual breaks between sections

### 5. Trust & Social Proof

**Types of social proof (in order of strength):**
1. **Results-based testimonials** — "We increased revenue by 47%"
2. **Named customer quotes** — Photo, name, title, company
3. **Logos** — Recognizable companies
4. **Numbers** — "10,000+ customers"
5. **Ratings/reviews** — G2, Capterra, TrustPilot
6. **Media mentions** — "As seen in..."
7. **Certifications** — Security badges, awards

**Social proof placement:**
- Near CTAs (reduces friction at decision point)
- After benefit claims (validates them)
- Throughout page at natural breaks
- In hero section (immediate trust)

**Trust element audit:**
- [ ] Customer logos visible
- [ ] Testimonials with specific results
- [ ] Security badges (if collecting sensitive info)
- [ ] Guarantee/refund policy mentioned
- [ ] Contact information accessible
- [ ] Privacy statement near forms

### 6. Objection Handling

**Identify likely objections:**
- Too expensive / not worth it
- Too complicated / takes too long
- Won't work for my situation
- Don't trust this company
- Not the right time
- Need approval from others

**Handle objections through:**
- FAQ sections
- Guarantee/risk reversal
- Comparison tables
- Process/timeline transparency
- Case studies matching their situation
- Free trial/demo offers

### 7. Friction Audit

**Find and remove friction:**
- [ ] Page loads fast (<3 seconds)
- [ ] Forms have minimal fields
- [ ] Mobile experience is smooth
- [ ] Navigation doesn't distract from goal
- [ ] No broken elements or errors
- [ ] No confusing jargon
- [ ] Clear next steps at every point

---

## Page-Type Specific Frameworks

### Landing Page (Paid Traffic)

**Structure:**
```
1. Hero: Headline + Subhead + CTA + Hero Image
2. Social proof bar (logos or key metric)
3. Problem agitation
4. Solution introduction
5. Benefits (3-5 key benefits)
6. How it works (3-4 steps)
7. Detailed features (if needed)
8. Social proof (testimonials)
9. Objection handling (FAQ)
10. Final CTA with value recap
```

**Key principles:**
- Single goal, single CTA
- Message match with ad creative
- Remove navigation (or minimize)
- Complete argument on one page
- Mobile-first design

### Homepage

**Different from landing page — serves multiple audiences:**

**Structure:**
```
1. Hero: Clear positioning + Primary CTA + Secondary option
2. Trust bar (logos)
3. Who it's for / Use cases
4. Key benefits or features
5. How it works
6. Social proof
7. Secondary sections (resources, about, etc.)
8. Final CTA
```

**Key principles:**
- Help visitors self-select their path
- Clear navigation for different needs
- Primary CTA visible but not exclusive
- Balance multiple audience needs

### Pricing Page

**High-intent visitors — optimize for decision:**

**Structure:**
```
1. Pricing table (clear comparison)
2. Recommended plan highlighted
3. Feature comparison matrix
4. FAQ (especially pricing objections)
5. Trust signals
6. Final CTA / Contact sales
```

**Key principles:**
- Make recommendation obvious ("Most Popular")
- Show all tiers at once
- Monthly/annual toggle
- Feature clarity (what's included/excluded)
- Address "which plan for me?" anxiety
- Clear path to checkout

### Feature Page

**Visitors researching specifics:**

**Structure:**
```
1. Feature headline (benefit-focused)
2. Feature explanation
3. Use cases / examples
4. How it compares (to alternatives or manual process)
5. Related features
6. CTA to try/demo
```

**Key principles:**
- Connect feature to outcome
- Show it in action (screenshots, GIFs, video)
- Make it tangible, not abstract
- Clear path to try it

---

## Optimization Prioritization

### The ICE Framework

Score each optimization idea:

**Impact (1-10):** How much will this move the needle?
**Confidence (1-10):** How sure are you it will work?
**Ease (1-10):** How easy is it to implement?

**ICE Score = Impact × Confidence × Ease**

Prioritize highest scores first.

### Quick Wins vs. Big Bets

**Quick wins (do first):**
- Headline copy changes
- CTA text improvements
- Adding social proof
- Removing distracting elements
- Fixing mobile issues
- Adding trust badges

**Big bets (test carefully):**
- Complete page redesign
- Major structural changes
- New page sections
- Different offer/positioning
- Navigation changes

---

## Testing Framework

### What to Test

**High-impact test areas (in order):**
1. Headlines and value propositions
2. CTA copy and placement
3. Social proof type and placement
4. Hero section layout
5. Form length/fields
6. Page length
7. Pricing presentation

### Test Hypothesis Format

```
IF we [change this element]
THEN [expected metric] will [increase/decrease]
BECAUSE [customer insight or principle]
```

**Example:**
```
IF we change the headline from feature-focused to outcome-focused
THEN signup rate will increase
BECAUSE visitors care more about results than technology
```

### Statistical Significance

**Don't call tests early:**
- Need sufficient sample size (typically 100+ conversions per variant)
- Run for full business cycles (at least 1-2 weeks)
- Account for traffic fluctuations
- Use proper statistical tools

---

## Mobile Optimization

**Mobile audit checklist:**
- [ ] Page loads in <3 seconds on 4G
- [ ] Text readable without zooming (16px+ base)
- [ ] Tap targets large enough (44px+)
- [ ] Forms easy to complete
- [ ] CTA visible without scrolling (or sticky)
- [ ] Images optimized for mobile
- [ ] No horizontal scrolling
- [ ] Phone number clickable

**Mobile-specific issues:**
- Forms too long for thumb typing
- Popups that cover content
- Images pushing CTA below fold
- Text too small
- Buttons too close together

---

## CRO + Paid Media Integration

### Landing Page Quality Score Impact

Google and Meta score landing page quality. Poor experience = higher CPCs.

**Optimization for ad platforms:**
- Fast load time (especially mobile)
- Message match with ad copy
- Clear relevance to keywords/targeting
- Mobile-friendly experience
- Easy navigation to conversion

### Using Ad Data to Inform CRO

**From ads to page:**
- Which ad copy performs best? → Test as headlines
- Which audiences convert best? → Tailor pages to them
- What objections appear in comments? → Address on page
- Which benefits resonate? → Lead with them

### Post-Click Optimization

**The conversion continues after the click:**
- Landing page → Form → Thank you page → Email
- Optimize the entire sequence, not just the landing page
- Thank you page is an opportunity (upsell, referral, next step)

---

## Output Format

### Page Audit Report

```
PAGE AUDITED: [URL]
PAGE TYPE: [Landing/Homepage/Pricing/etc.]
CURRENT CVR: [X%]
DATE: [Date]

EXECUTIVE SUMMARY:
[2-3 sentences on biggest issues and opportunities]

CRITICAL ISSUES (Fix Immediately):
1. [Issue] — [Impact] — [Recommendation]
2. [Issue] — [Impact] — [Recommendation]

HIGH-IMPACT OPPORTUNITIES:
1. [Opportunity] — [Expected Impact] — [Implementation]
2. [Opportunity] — [Expected Impact] — [Implementation]

TEST HYPOTHESES:
1. [Hypothesis with expected outcome]
2. [Hypothesis with expected outcome]

DETAILED FINDINGS BY SECTION:
[Section-by-section analysis]
```

### Optimization Roadmap

```
IMMEDIATE (This Week):
- [ ] [Quick win 1]
- [ ] [Quick win 2]

SHORT-TERM (This Month):
- [ ] [Medium effort improvement 1]
- [ ] [A/B test 1]

MEDIUM-TERM (This Quarter):
- [ ] [Larger initiative]
- [ ] [A/B test 2]
```

---

## Questions to Ask

If you need more context:
1. What's the primary conversion goal for this page?
2. What's the current conversion rate?
3. Where does traffic come from (paid, organic, email)?
4. Do you have heatmaps or session recordings?
5. What have you already tested?
6. What does the post-conversion flow look like?
7. Who is the target audience for this page?

---

## Related Skills

- **copywriting**: For rewriting page copy
- **form-cro**: For optimizing forms on the page
- **ab-test-designer**: For testing page changes
- **marketing-psychology**: For conversion psychology principles
- **landing-page-auditor**: For existing landing page analysis
- **facebook-ads-creative-tester**: For ad-to-page alignment
