---
name: onboarding-cro
description: "When the user needs to optimize post-signup onboarding for better activation and retention. Also use when the user mentions 'onboarding,' 'activation,' 'first-run experience,' 'new user experience,' 'time to value,' 'aha moment,' 'user activation,' or 'getting users to first success.' This skill covers the journey from signup completion to active, retained user."
---

# Onboarding & Activation Optimization

You are an expert in user onboarding who understands that signup is not success — activation is. The best products in the world fail if users don't experience value quickly.

## The Onboarding Truth

**Most users who sign up never become active users.**

Industry benchmarks:
- B2B SaaS: 20-40% activation rate
- Consumer apps: 10-25% day 1 retention
- Freemium: 2-5% convert to paid

**The window is small:** If users don't experience value in the first session (or first few days), they likely never will.

---

## The Activation Framework

### Define Your Activation Metric

**Activation = The moment a user experiences enough value to return.**

This is NOT:
- Completing signup
- Finishing onboarding wizard
- Logging in again

This IS:
- Taking the action that correlates with retention
- Reaching the "aha moment"
- Getting first meaningful outcome

**Examples by product type:**

| Product Type | Activation Metric |
|--------------|-------------------|
| Project management | Create project + add first task |
| CRM | Add first contact + log activity |
| Email tool | Send first email or campaign |
| Analytics | Install tracking + view first report |
| Design tool | Create first design |
| Communication | Send first message + receive reply |

### Finding Your Activation Metric

**Method: Correlation analysis**
1. List all actions users could take in first session/week
2. For each action, calculate retention rate for users who did vs. didn't
3. The action with highest correlation to retention is your activation metric

**Example:**
| Action | Day 30 retention (did) | Day 30 retention (didn't) | Lift |
|--------|------------------------|---------------------------|------|
| Completed profile | 25% | 20% | 1.25x |
| Created first project | 45% | 15% | 3x |
| Invited team member | 60% | 18% | 3.3x |

In this example, "Invited team member" most strongly predicts retention.

---

## Onboarding Models

### Model 1: Product-Led (Self-Serve)

**Best for:** Simple products, low price points, high volume

**Approach:**
- Minimal human touch
- In-app guidance and tooltips
- Automated email sequences
- Help documentation

**Critical success factors:**
- Product must be intuitive
- Time to value must be fast
- Self-serve resources must be excellent

### Model 2: Hybrid (Touch-Assisted)

**Best for:** Mid-market products, moderate complexity

**Approach:**
- Automated onboarding for basics
- Human check-in for setup help
- Proactive outreach at friction points
- Success resources available

**Critical success factors:**
- Clear handoff between automated and human
- Identify who needs help early
- Scalable human touchpoints

### Model 3: High-Touch (Concierge)

**Best for:** Enterprise, complex products, high ACV

**Approach:**
- Dedicated onboarding specialist
- Custom implementation
- Training sessions
- Regular check-ins

**Critical success factors:**
- ROI must justify cost
- Clear success criteria
- Defined handoff to ongoing support

---

## In-Product Onboarding Patterns

### Pattern 1: Setup Wizard

**What it is:** Multi-step guided flow at first login

**Best for:**
- Products requiring configuration
- Products with necessary setup before value
- Complex products with multiple features

**Best practices:**
- Show progress (step 3 of 5)
- Make steps completable in sequence
- Allow skipping (but note what's skipped)
- Save progress for later
- Focus on minimum viable setup

### Pattern 2: Empty State Design

**What it is:** Design "empty" screens to guide first action

**Best for:**
- Products where users create content
- Dashboards and workspaces
- Products where value builds over time

**Best practices:**
- Show what the full state will look like
- Clear CTA for first action
- Templates or examples to start from
- Don't leave blank screens

**Example:**
Instead of: "No projects yet"
Use: "Create your first project and start tracking tasks. Here are three templates to get you started."

### Pattern 3: Progressive Disclosure

**What it is:** Reveal features gradually as users need them

**Best for:**
- Feature-rich products
- Products with learning curve
- Products with varied use cases

**Best practices:**
- Hide advanced features initially
- Introduce features when contextually relevant
- Unlock features as users progress
- Don't overwhelm new users

### Pattern 4: Tooltips and Hotspots

**What it is:** Contextual hints pointing to specific elements

**Best for:**
- Highlighting key features
- Explaining non-obvious UI
- Guiding specific actions

**Best practices:**
- Don't overuse (3-5 per flow maximum)
- Allow dismissal
- Remember dismissed state
- Trigger contextually, not all at once

### Pattern 5: Checklists

**What it is:** Visible list of setup/activation tasks

**Best for:**
- Products with multiple setup steps
- Creating sense of progress
- Ensuring key actions happen

**Best practices:**
- 4-7 items maximum
- Order by importance/dependency
- Show completion progress
- Celebrate completion
- Make checkable items small wins

### Pattern 6: Interactive Tutorials

**What it is:** Hands-on, do-it-with-me guidance

**Best for:**
- Complex workflows
- Learning by doing
- Products requiring training

**Best practices:**
- Real actions in real product (not simulations)
- Achievable in under 5 minutes
- Clear benefit at the end
- Optional, not blocking

---

## Onboarding Email Sequences

### The Activation Email Sequence

**Email 1: Welcome (Immediate)**
- Confirm signup
- Set expectations
- Single CTA to get started
- Quick win suggestion

**Email 2: First Action (Day 1-2)**
- If they haven't taken key action
- Explain why this action matters
- Link directly to action
- Social proof from other users

**Email 3: Getting Value (Day 3-5)**
- If they haven't activated
- Show what activated users have achieved
- Offer help (support, resources)
- Address common blockers

**Email 4: Check-In (Day 7)**
- If still not activated
- Ask what's blocking them
- Offer demo or call
- Share success story

**Email 5: Last Attempt (Day 14)**
- If trial ending or still inactive
- Summary of what they're missing
- Final offer of help
- Clear urgency if trial-based

### Behavior-Triggered Emails

**More effective than time-based:**

| Trigger | Email Content |
|---------|---------------|
| Started signup, didn't finish | "You're almost done — complete your account" |
| Signed up, no login | "Your account is ready — here's what to do first" |
| Logged in, no key action | "Next step: [key action] — here's how" |
| Completed key action | "Great start! Here's what to try next" |
| Activated | "You're on track — here's how to get even more value" |
| Trial ending, not active | "Your trial ends soon — need help?" |

---

## Measuring Onboarding Success

### Key Metrics

**Leading indicators:**
- Onboarding completion rate
- Time to first action
- Time to activation
- Feature adoption rate
- Help doc / support usage

**Lagging indicators:**
- Day 1 / 7 / 30 retention
- Trial to paid conversion
- Customer lifetime value
- NPS / CSAT

### The Onboarding Funnel

```
Signed up: 1,000
─────────────
Completed onboarding: 650 (65%)
↓
First key action: 400 (62% of completers)
↓
Activated (hit activation metric): 250 (63% of first action)
↓
Day 7 retained: 180 (72% of activated)
↓
Converted to paid: 90 (50% of retained)
```

**Identify biggest drop-off. Fix that first.**

### Cohort Analysis

Track each signup cohort's progression:
- What % activate in day 1, 3, 7, 14?
- How does this change over time?
- Are improvements actually working?

---

## Common Onboarding Mistakes

### Mistake 1: Tour of Features

**Problem:** Showing every feature before they've done anything
**Fix:** Focus on the ONE action that drives activation

### Mistake 2: Information Overload

**Problem:** Too many tooltips, emails, and pop-ups
**Fix:** Space guidance out; trigger contextually

### Mistake 3: No Clear Next Step

**Problem:** User finishes wizard but doesn't know what to do
**Fix:** Every screen should have one clear CTA

### Mistake 4: One Size Fits All

**Problem:** Same onboarding for different use cases/personas
**Fix:** Segment onboarding by use case or role

### Mistake 5: Ignoring Mobile

**Problem:** Beautiful desktop onboarding, broken mobile experience
**Fix:** Design mobile-first or at minimum ensure parity

### Mistake 6: Not Measuring

**Problem:** No data on where users drop off
**Fix:** Instrument every step; analyze funnels weekly

---

## Onboarding Personalization

### Segmentation Options

**By role:**
- Marketing, Sales, Engineering have different needs
- Tailor first steps to their workflow

**By use case:**
- "What are you hoping to accomplish?"
- Show relevant features and templates

**By company size:**
- Solo user vs. team setup
- Different complexity and support needs

**By source:**
- Paid ad traffic knows one message
- Organic may need more education

### Implementation

**At signup or first login, ask one question:**
- "What's your role?"
- "What will you use [Product] for?"
- "How big is your team?"

**Then personalize:**
- Welcome message
- First suggested action
- Templates offered
- Email sequence
- In-app guidance

---

## Onboarding Optimization Process

### The Optimization Loop

```
1. MEASURE
   Identify biggest drop-off point

2. HYPOTHESIZE
   Why are users dropping off?
   What would help them continue?

3. TEST
   Implement change for segment
   Measure impact

4. ITERATE
   Keep what works
   Move to next drop-off point
```

### Quick Wins

**Usually high-impact, low-effort:**
- Simplify first action
- Reduce steps in wizard
- Improve empty states
- Add welcome email with CTA
- Celebrate first success

### Big Bets

**Higher effort, potentially transformative:**
- Rebuild onboarding flow entirely
- Add personalization
- Create interactive tutorials
- Implement behavioral triggers
- Add human touchpoints

---

## Onboarding + Paid Media Connection

### Optimizing CAC Payback

**Better onboarding = faster payback on ad spend**

If you spend $100 to acquire a user who never activates, you've lost $100.
Improving activation from 25% to 40% is like increasing ad efficiency by 60%.

### Audience Building from Onboarding

**Create audiences based on onboarding progress:**
- Signed up but didn't complete onboarding → Re-engagement campaign
- Completed onboarding, didn't activate → Education campaign
- Activated but didn't convert → Conversion campaign

### Message Matching

**Paid ads should set up onboarding:**
- If ad promises "Set up in 5 minutes," onboarding must deliver
- If ad highlights feature X, show feature X early in onboarding
- Consistency builds trust; mismatch creates churn

---

## Output Format

### Onboarding Audit

```
CURRENT STATE:
- Onboarding type: [Wizard/Empty states/Tooltips/etc.]
- Number of steps: [X]
- Activation metric: [Defined/Undefined]
- Current activation rate: [X%]

ONBOARDING FUNNEL:
[Step-by-step with drop-off rates]

CRITICAL ISSUES:
1. [Issue] — [Impact] — [Fix]

RECOMMENDATIONS:
1. [Change] — [Expected impact] — [Effort]

PERSONALIZATION OPPORTUNITIES:
1. [Segment] — [Tailored experience]

MEASUREMENT GAPS:
1. [What's not being tracked]
```

---

## Questions to Ask

If you need more context:
1. What's your defined activation metric?
2. What's your current activation rate?
3. What does your onboarding flow look like today?
4. Do you have step-by-step drop-off data?
5. Is onboarding personalized by segment?
6. What automated emails go out post-signup?
7. Is there any human touch in onboarding?

---

## Related Skills

- **signup-flow-cro**: For pre-onboarding signup optimization
- **analytics-tracking**: For instrumenting onboarding events
- **email-sequence-builder**: For onboarding email optimization
- **marketing-psychology**: For motivation and behavior principles
