---
name: video-ad-script-writer
description: Creates high-converting video ad scripts for YouTube, TikTok, Meta, and other platforms with proven hook formulas, structure templates, and platform-specific best practices. Triggers when user asks about video scripts, ad copy for video, "video ad structure," "hook ideas," "TikTok script," "YouTube ad script," or wants help writing video creative. Delivers ready-to-shoot scripts with timing and visual direction.
---

# Video Ad Script Writer

The script is the blueprint. A great script makes production easy. A bad script makes production pointless.

## Core Philosophy

**Video ads are not mini commercials.** They're interruptions in someone's feed. You have to earn every second of attention.

**The Hook Is Everything.** 65% of video ad performance is determined in the first 3 seconds. On TikTok, it's the first 1 second. Spend 80% of your creative energy on the hook.

**Structure Creates Clarity.** Great video ads follow a formula:
- Hook (0-3s): Stop the scroll
- Problem/Setup (3-10s): Establish relevance
- Solution/Demo (10-25s): Show the value
- CTA (last 3-5s): Tell them what to do

**Platform Context Matters:**
- YouTube: Viewers are watching content, more patient
- TikTok: Fastest scroll, most native content wins
- Meta (Feed): Mid-attention, 15-30s sweet spot
- Meta (Reels): TikTok-like behavior, native preferred
- LinkedIn: Professional context, credibility matters

**Write for Sound-Off First.** 85% of social video is watched without sound. Text overlays aren't optional—they're essential.

---

## Required Context

### Must Have

**1. Product/Service Details**
- What you're selling
- Key benefits (top 3)
- Target price point
- Unique selling proposition

**2. Target Audience**
- Who they are
- What problem they have
- What they've tried before
- What objections they might have

**3. Platform & Placement**
- Where this will run (YouTube, TikTok, Meta, etc.)
- Specific placement (Feed, Stories, Reels, Pre-roll)

**4. Desired Length**
- Target duration
- Any platform constraints

### Strongly Recommended

**5. Video Style**
- Format (UGC, talking head, product demo, testimonial, etc.)
- Talent (founder, customer, actor, influencer)
- Production level (lo-fi UGC vs. polished)

**6. Creative Direction**
- Tone (serious, playful, urgent, educational)
- Brand guidelines (if any)
- Things to avoid

**7. Previous Winners**
- What scripts/angles have worked before?
- What hooks performed well?
- Any learnings from past tests?

### Nice to Have

- Competitor examples to differentiate from
- Specific offers or promotions to include
- Customer testimonials or quotes to incorporate
- Trending sounds or formats to leverage

---

## Script Framework

### The Universal Video Ad Structure

```
┌─────────────────────────────────────────────────────────────┐
│  HOOK (0-3 seconds)                                         │
│  → Stop the scroll                                          │
│  → Pattern interrupt OR curiosity OR bold claim             │
├─────────────────────────────────────────────────────────────┤
│  PROBLEM/SETUP (3-10 seconds)                               │
│  → Establish relevance                                      │
│  → "This is about YOU"                                      │
│  → Agitate the pain OR spark desire                         │
├─────────────────────────────────────────────────────────────┤
│  SOLUTION/DEMO (10-25 seconds)                              │
│  → Introduce your product                                   │
│  → Show it working                                          │
│  → Stack benefits (not features)                            │
├─────────────────────────────────────────────────────────────┤
│  PROOF (optional, 5-10 seconds)                             │
│  → Social proof / testimonials                              │
│  → Results / transformation                                 │
│  → Credibility signals                                      │
├─────────────────────────────────────────────────────────────┤
│  CTA (last 3-5 seconds)                                     │
│  → Clear next step                                          │
│  → Urgency if authentic                                     │
│  → Repeat key benefit                                       │
└─────────────────────────────────────────────────────────────┘
```

---

### Hook Formulas (The Most Important Part)

**Category 1: Pattern Interrupt**
- "Wait, don't scroll" + [surprising statement]
- [Unusual visual/action] + [context reveal]
- "POV: [relatable situation]"
- "This is going to sound crazy but..."

**Category 2: Question Hooks**
- "Did you know [surprising fact]?"
- "Why is nobody talking about [topic]?"
- "What if I told you [benefit] was possible?"
- "[Audience], can we talk about [pain point]?"

**Category 3: Bold Claims**
- "I [achieved result] in [timeframe]. Here's how."
- "This [product] changed my [relevant thing]"
- "The #1 mistake [audience] make with [topic]"
- "After testing 100 [things], this is the best"

**Category 4: Story Openers**
- "6 months ago, I was [problem state]..."
- "My [person] asked me why [observation]..."
- "I spent $[amount] learning this so you don't have to"
- "I was skeptical too, until..."

**Category 5: Direct Call-Out**
- "[Specific audience], this is for you"
- "If you're struggling with [problem], watch this"
- "Stop doing [common mistake]"
- "The [product type] they don't want you to know about"

**Category 6: Curiosity Gap**
- "I found out why [unexpected thing]"
- "The secret [industry/experts] don't tell you"
- "Here's what happened when I tried [product]"
- "This one thing 10x'd my [result]"

---

### Platform-Specific Structures

**YouTube Pre-Roll (15-30 seconds):**
```
[0-5s]   HOOK - Must hook before skip button
[5-15s]  PROBLEM + SOLUTION - Fast-paced, benefit-focused
[15-25s] DEMO/PROOF - Show it working
[25-30s] CTA - Clear action, sense of urgency
```

**TikTok/Reels (15-30 seconds):**
```
[0-1s]   HOOK - Pattern interrupt, visual first
[1-5s]   SETUP - Establish relevance fast
[5-20s]  DEMO/STORY - Native, entertaining, valuable
[20-25s] RESULT - Transformation/benefit
[25-30s] CTA - Natural, not salesy
```

**Meta Feed (15-45 seconds):**
```
[0-3s]   HOOK - Stop the scroll
[3-10s]  PROBLEM - Establish pain/desire
[10-30s] SOLUTION - Product intro + demo
[30-40s] PROOF - Testimonial/results
[40-45s] CTA - Action + offer
```

**LinkedIn (30-90 seconds):**
```
[0-5s]   HOOK - Professional, credibility-based
[5-20s]  PROBLEM - Business pain/opportunity
[20-50s] SOLUTION - How it works, case study
[50-80s] PROOF - Results, logos, testimonials
[80-90s] CTA - Clear next step, professional
```

---

## Output Format

### Script Deliverable

```
═══════════════════════════════════════════════════════════════════
VIDEO AD SCRIPT
Product: [Product Name]
Platform: [Platform]
Length: [XX seconds]
Style: [UGC/Testimonial/Demo/etc.]
═══════════════════════════════════════════════════════════════════

📋 SCRIPT OVERVIEW
────────────────────────────────────────────────────────────────────

Target Audience: [Who this is for]
Primary Message: [Key takeaway]
Hook Strategy: [Which hook formula used]
Tone: [Tone description]

═══════════════════════════════════════════════════════════════════

🎬 FULL SCRIPT
────────────────────────────────────────────────────────────────────

[0:00-0:03] HOOK
─────────────────
🎤 AUDIO:
"[Spoken words exactly as talent should say them]"

📱 VISUAL:
[Description of what's on screen - framing, action, product placement]

📝 TEXT OVERLAY:
"[Any text that should appear on screen]"

💡 DIRECTION:
[Notes for talent/production - energy level, pace, emphasis]

────────────────────────────────────────────────────────────────────

[0:03-0:10] PROBLEM/SETUP
─────────────────────────
🎤 AUDIO:
"[Spoken words]"

📱 VISUAL:
[Visual description]

📝 TEXT OVERLAY:
"[Text on screen]"

💡 DIRECTION:
[Production notes]

────────────────────────────────────────────────────────────────────

[0:10-0:25] SOLUTION/DEMO
─────────────────────────
🎤 AUDIO:
"[Spoken words]"

📱 VISUAL:
[Visual description]

📝 TEXT OVERLAY:
"[Text on screen]"

💡 DIRECTION:
[Production notes]

────────────────────────────────────────────────────────────────────

[0:25-0:30] CTA
───────────────
🎤 AUDIO:
"[Spoken words]"

📱 VISUAL:
[Visual description]

📝 TEXT OVERLAY:
"[Text on screen - including any offer]"

💡 DIRECTION:
[Production notes]

═══════════════════════════════════════════════════════════════════

📊 SCRIPT SPECIFICATIONS
────────────────────────────────────────────────────────────────────

Total Duration: [XX seconds]
Word Count: [XXX words] (~[X] words per second)
Text Overlays: [X] total
Product Mentions: [X] times
CTA Appears: [When and how often]

KEY MESSAGES INCLUDED:
✅ [Key message 1]
✅ [Key message 2]
✅ [Key message 3]

═══════════════════════════════════════════════════════════════════

🔄 HOOK VARIATIONS (A/B Test Options)
────────────────────────────────────────────────────────────────────

VARIATION A (Primary - included above):
"[Hook text]"
Strategy: [Hook formula used]

VARIATION B:
"[Alternative hook]"
Strategy: [Hook formula used]

VARIATION C:
"[Third hook option]"
Strategy: [Hook formula used]

═══════════════════════════════════════════════════════════════════

📝 PRODUCTION NOTES
────────────────────────────────────────────────────────────────────

FILMING REQUIREMENTS:
- Location: [Setting description]
- Talent: [Who should be in the video]
- Props: [Products, items needed]
- Lighting: [Lighting suggestions]
- Framing: [Shot types - close-up, medium, wide]

EDITING NOTES:
- Pace: [Fast cuts / Slow / Variable]
- Music: [Upbeat / Calm / Trending sound / None]
- Captions: [Style - bold, animated, minimal]
- B-roll: [Additional footage needed]

SOUND CONSIDERATIONS:
- Record clean audio (80% watch with sound off but sound improves performance)
- Text overlays must convey full message without audio
- [Platform-specific sound notes]

═══════════════════════════════════════════════════════════════════
```

---

## Common Scenarios

### Scenario 1: "I need a script but don't know what angle to use"

**Solution Process:**
1. Start with the customer's biggest pain point
2. Check what competitors are doing (then do something different)
3. Look at your best-performing ads/content for patterns
4. Test multiple angles:
   - Pain-focused (problem agitation)
   - Benefit-focused (transformation)
   - Social proof-focused (testimonials)
   - Demo-focused (show don't tell)

**Recommendation:** Write 3 scripts with different angles, test them.

### Scenario 2: "My videos get views but no conversions"

**Diagnosis Checklist:**
- [ ] Hook is engaging but not relevant to product?
- [ ] Entertainment value high but no clear CTA?
- [ ] Product introduction too late in video?
- [ ] Benefits unclear or not compelling?
- [ ] CTA weak or missing?

**Solution:** Add earlier product mention, clearer benefit statement, stronger CTA.

### Scenario 3: "How long should my video be?"

**Platform Guidelines:**

| Platform | Optimal Length | Max Recommended |
|----------|----------------|-----------------|
| TikTok | 15-30 seconds | 60 seconds |
| Instagram Reels | 15-30 seconds | 60 seconds |
| Meta Feed | 15-30 seconds | 60 seconds |
| Meta Stories | 15 seconds | 15 seconds |
| YouTube Pre-Roll | 15-30 seconds | 30 seconds |
| YouTube Discovery | 2-5 minutes | 10 minutes |
| LinkedIn | 30-60 seconds | 90 seconds |

**Rule of Thumb:** Shorter is better until you have data proving otherwise.

### Scenario 4: "I'm adapting a Meta ad for TikTok"

**Don't just repost.** Adapt:

| Meta Element | TikTok Adaptation |
|--------------|-------------------|
| Polished production | Make it lo-fi, authentic |
| Brand intro first | Hook first, brand later |
| 3-second hook | 1-second hook |
| Clear CTA button | More subtle, native CTA |
| Professional voiceover | Creator-style narration |
| Music bed | Consider trending sounds |

### Scenario 5: "Writing for UGC creator to film"

**Include in brief:**
1. Exact words for hook (don't let them improvise this)
2. Key points to hit (bullet points, not script)
3. What to show (product, actions, results)
4. CTA (exact words preferred)
5. What NOT to say (competitors, unapproved claims)
6. Technical specs (orientation, length, lighting)

**Allow flexibility:** Middle section can be more conversational—don't over-script.

---

## Script Quality Indicators

### Signs of a Strong Script

| Indicator | What to Look For |
|-----------|------------------|
| Hook clarity | Immediately clear what's happening and why to care |
| Single message | One main benefit, not five |
| Show don't tell | Demo > description |
| Conversational | Sounds like talking, not reading |
| Clear CTA | Specific action, not "learn more" |
| Platform fit | Matches native content style |
| Benefit focus | Why it matters to viewer, not product features |

### Common Script Mistakes

| Mistake | Problem | Fix |
|---------|---------|-----|
| Logo first | Signals "this is an ad" | Hook first, brand later |
| Feature dump | Nobody cares about features | Benefits + demo |
| Slow start | Lose viewers before message | Hook in first second |
| Weak CTA | Views but no action | Clear, specific, urgent |
| Too long | Attention drops off | Cut 30%, then cut more |
| Written not spoken | Sounds unnatural | Read aloud, revise |
| No text overlays | Sound-off viewers lost | Key points on screen |

---

## Limitations

**I can provide:**
- Platform-optimized script structures
- Hook formulas and variations
- Timing and pacing guidance
- Text overlay suggestions
- Production direction notes
- A/B test variations

**I cannot provide:**
- Guaranteed performance predictions
- Trending sounds/music selection
- Visual design or storyboards
- Compliance review (platform policies, legal claims)
- Competitor-specific intelligence
- Voice/tone that perfectly matches your brand without examples

**For best results, also provide:**
- Examples of past winners
- Specific brand voice guidelines
- Customer testimonials to incorporate
- Offer details and restrictions

---

## Quality Checklist

Before delivering script:
- [ ] Hook stops the scroll in <3 seconds (or <1s for TikTok)
- [ ] Single clear message throughout
- [ ] Benefits stated, not just features
- [ ] Product appears within first 10 seconds
- [ ] Text overlays convey message without sound
- [ ] CTA is specific and clear
- [ ] Word count appropriate for timing (~2-3 words/second)
- [ ] Tone matches platform (native, not ad-like)
- [ ] Production notes are actionable
- [ ] Hook variations provided for testing
- [ ] Read aloud to check natural flow
