---
name: creative-testing-roadmap
description: Designs systematic creative testing plans including hooks, formats, CTAs, and messaging angles. Triggers when user asks "what creatives should I test?", "how do I build a testing calendar?", or wants to improve creative performance systematically. Provides prioritized testing framework with hypothesis-driven experiments.
---

# Creative Testing Roadmap

Stop guessing. Start testing with a system.

## Core Philosophy

**Random testing is expensive learning.** Without a framework, you're just throwing creative at the wall to see what sticks.

**The Testing Paradox:** You need to test everything, but you can't afford to test everything. Prioritization is the skill.

**The Three Laws of Creative Testing:**
1. **Test one variable at a time:** Multi-variable tests teach nothing
2. **Winners decay, testing never stops:** Today's winner is next month's loser
3. **Hooks beat everything:** The first 3 seconds determine 80% of performance

---

## Required Context

### Must Have

**1. Current Creative Portfolio**
- What creatives are currently running
- Performance data (CTR, CPA, hook rate)
- Formats in use (video, image, carousel)
- Age of each creative

**2. Business Context**
- Product/service being advertised
- Target audience
- Primary conversion goal
- Key value propositions

### Strongly Recommended

**3. Historical Winners**
- What has worked in the past
- Why it worked (hypothesis)
- How long it lasted before fatiguing

**4. Constraints**
- Creative production capacity (ads/week)
- Budget for testing
- Platform(s) running on
- Brand guidelines

### Nice to Have

- Competitor creative examples
- Customer research/testimonials
- Seasonal considerations
- Previous test results

---

## Creative Testing Framework

### The Testing Hierarchy

Test in this order—higher levels have more impact:

```
LEVEL 1: CONCEPT/ANGLE (Biggest Impact)
   ↓
LEVEL 2: HOOK/OPENING
   ↓
LEVEL 3: FORMAT
   ↓
LEVEL 4: BODY/MIDDLE CONTENT
   ↓
LEVEL 5: CTA/CLOSING
   ↓
LEVEL 6: VISUAL ELEMENTS
   ↓
LEVEL 7: COPY VARIATIONS (Smallest Impact)
```

**Impact vs. Effort Matrix:**

| Element | Impact | Production Effort | Test First? |
|---------|--------|-------------------|-------------|
| Concept/Angle | Very High | High | Yes |
| Hook (0-3 sec) | Very High | Low-Medium | Yes |
| Format | High | High | Depends |
| Body content | Medium | Medium | No |
| CTA | Medium | Low | Maybe |
| Visual style | Low-Medium | Medium | No |
| Copy tweaks | Low | Low | No |

---

### Level 1: Concept/Angle Testing

**What is a Concept?**
The core idea or approach of the creative. Examples:
- Problem → Solution
- Before → After
- Social Proof / Testimonial
- Product Demo
- Lifestyle / Aspiration
- Educational / How-To
- UGC / Authenticity
- Urgency / Scarcity
- Comparison / vs. Competitor

**Concept Testing Approach:**
1. Identify 3-5 distinct concepts
2. Create one creative per concept (same format)
3. Test with equal budget
4. Winner becomes the concept to iterate on

**Concept Prioritization:**

| Concept Type | Best For | When to Test |
|--------------|----------|--------------|
| Problem-Solution | Pain-aware audiences | Always start here |
| Before-After | Transformation products | High visual impact |
| Testimonial/UGC | Trust-dependent purchases | Mid-funnel |
| Product Demo | Complex products | Solution-aware audiences |
| Lifestyle | Aspiration products | Brand building |

---

### Level 2: Hook Testing

**The 3-Second Rule:**
Users decide to watch or scroll in <3 seconds. The hook is everything.

**Hook Types:**

| Hook Type | Example | Best For |
|-----------|---------|----------|
| Question | "Struggling with X?" | Problem-aware |
| Bold Statement | "This changed everything" | Attention grab |
| Pattern Interrupt | Unusual visual/sound | Scroll stop |
| Transformation | "30 days ago vs today" | Before/after |
| Social Proof | "500K people use this" | Trust building |
| Controversy | "Unpopular opinion..." | Engagement |
| Curiosity | "Nobody talks about this" | Intrigue |
| Direct Address | "Hey [audience]!" | Specificity |

**Hook Testing Approach:**
1. Take your best-performing concept
2. Create 5-10 different hooks for it
3. Keep body and CTA the same
4. Test hooks against each other
5. Winning hook becomes template for future

---

### Level 3: Format Testing

**Format Performance by Platform:**

| Format | Meta | TikTok | YouTube | LinkedIn |
|--------|------|--------|---------|----------|
| Video (15-30s) | High | Very High | High | Medium |
| Video (60s+) | Medium | Medium | Very High | High |
| Static Image | Medium | Low | N/A | High |
| Carousel | High | N/A | N/A | High |
| UGC Video | Very High | Very High | Medium | Low |
| Motion Graphics | Medium | Medium | High | Medium |

**Format Testing Approach:**
1. Take winning concept + hook
2. Adapt to different formats
3. Test format performance
4. Double down on winning format

---

### Level 4-7: Iteration Testing

**Once you have winning Concept + Hook + Format:**

Test these elements in order:
1. **Body variations:** Different proof points, features
2. **CTA variations:** "Shop Now" vs "Learn More" vs "Get Started"
3. **Visual style:** Colors, fonts, pacing
4. **Copy tweaks:** Headlines, descriptions

---

## Testing Calendar Framework

### Minimum Viable Testing Velocity

| Budget Level | Tests/Week | New Creatives/Week |
|--------------|------------|-------------------|
| <$10K/month | 2-3 | 1-2 |
| $10K-30K/month | 4-6 | 2-3 |
| $30K-100K/month | 6-10 | 3-5 |
| >$100K/month | 10-20 | 5-10 |

### Testing Calendar Structure

**Week 1-2: Concept Sprint**
- Test 3-5 different concepts
- Same format, same hook style
- Goal: Find winning concept

**Week 3-4: Hook Sprint**
- Take winning concept
- Test 5-10 different hooks
- Goal: Find winning hook formula

**Week 5-6: Format/Iteration Sprint**
- Winning concept + hook
- Test formats and body variations
- Goal: Maximize winning combination

**Week 7+: Continuous Iteration**
- New hooks weekly on winning concept
- New concepts monthly
- Replace fatigued creatives

---

## Output Format

### Creative Testing Roadmap

```
═══════════════════════════════════════════════════════════════
CREATIVE TESTING ROADMAP
Business: [Business Type]
Platform(s): [Platforms]
Testing Velocity: [X] new creatives/week
Timeline: [X] weeks
═══════════════════════════════════════════════════════════════
```

---

### Current Creative Assessment

**Portfolio Health:**

| Category | Count | Top Performer | Status |
|----------|-------|---------------|--------|
| Video | [X] | [Name] | [Fresh/Fatiguing/Fatigued] |
| Static | [X] | [Name] | [Fresh/Fatiguing/Fatigued] |
| Carousel | [X] | [Name] | [Fresh/Fatiguing/Fatigued] |
| UGC | [X] | [Name] | [Fresh/Fatiguing/Fatigued] |

**Concepts Currently Running:**
| Concept | Creatives | Best CPA | Status |
|---------|-----------|----------|--------|
| [Concept] | [X] | $[X] | [Tested/Untested] |

**Gap Analysis:**
- Concepts not yet tested: [List]
- Hooks not yet tested: [List]
- Formats underrepresented: [List]

---

### Testing Priorities

**Phase 1: [Name] (Weeks 1-2)**

| Priority | Test Type | Hypothesis | Creatives Needed |
|----------|-----------|------------|------------------|
| 1 | [Type] | [Hypothesis] | [X] |
| 2 | [Type] | [Hypothesis] | [X] |
| 3 | [Type] | [Hypothesis] | [X] |

**Phase 2: [Name] (Weeks 3-4)**

| Priority | Test Type | Hypothesis | Creatives Needed |
|----------|-----------|------------|------------------|
| 1 | [Type] | [Hypothesis] | [X] |
| 2 | [Type] | [Hypothesis] | [X] |

**Phase 3: [Name] (Weeks 5-6)**

[Continue pattern...]

---

### Detailed Test Briefs

**Test 1: [Test Name]**

```
Test Type: [Concept/Hook/Format/Iteration]
Hypothesis: [Specific hypothesis]
Current Baseline: [Metric to beat]
Success Criteria: [What "winning" looks like]

Creative Specs:
- Format: [Format]
- Length: [Duration if video]
- Hook: [Hook approach]
- Body: [Key content]
- CTA: [Call to action]

Variations to Test:
1. [Variation A description]
2. [Variation B description]
3. [Variation C description]

Budget: $[X]
Duration: [X] days
Decision Date: [Date]
```

---

### Hook Ideas Bank

**For [Winning Concept]:**

| Hook Type | Script/Idea | Priority |
|-----------|-------------|----------|
| Question | "[Specific question]" | High |
| Bold Statement | "[Statement]" | High |
| Pattern Interrupt | [Description] | Medium |
| Social Proof | "[Proof point]" | Medium |
| Curiosity | "[Curiosity hook]" | Low |

---

### Creative Production Schedule

**Week [X]:**

| Day | Task | Deliverable |
|-----|------|-------------|
| Mon | Brief [X] creatives | Briefs complete |
| Tue | [Production task] | [Deliverable] |
| Wed | [Production task] | [Deliverable] |
| Thu | Review/revisions | Final creatives |
| Fri | Launch tests | Ads live |

---

### Testing Budget Allocation

**Monthly Testing Budget: $[X]**

| Test Type | % Allocation | Budget |
|-----------|--------------|--------|
| Concept tests | [X]% | $[X] |
| Hook tests | [X]% | $[X] |
| Format tests | [X]% | $[X] |
| Iteration tests | [X]% | $[X] |

**Per-Test Budget:**
- Minimum: $[X]/creative
- Recommended: $[X]/creative
- Statistical significance: [X] conversions per variant

---

### Success Metrics & Decision Framework

**When to Call a Winner:**
- Minimum [X] conversions per variant
- Minimum [X] days running
- [X]% confidence interval

**What Constitutes a Win:**
| Metric | Threshold | Action |
|--------|-----------|--------|
| CPA improvement | >15% | Scale winner, iterate |
| CTR improvement | >20% | Investigate hook |
| No clear winner | <10% diff | Test bolder variations |

**Post-Test Actions:**
- Winner found: Create [X] iterations
- Loser identified: Document learning, test opposite
- Inconclusive: Increase budget or test more dramatic difference

---

### Iteration Pipeline

**From Each Winner, Create:**
1. Same hook, different body content
2. Same concept, different hook
3. Same creative, different format
4. Same creative, different CTA

**Template:**
```
WINNER: [Creative name]
└── Iteration 1: [Hook variation]
└── Iteration 2: [Body variation]
└── Iteration 3: [Format adaptation]
└── Iteration 4: [CTA test]
```

---

## Platform-Specific Testing Guidance

### Meta Ads
- Test hooks aggressively (3-second views = key metric)
- UGC outperforms polished 70% of the time
- Carousel works better than you think
- Video: 15-30 seconds optimal
- Use Advantage+ Creative for auto-testing elements

### TikTok
- Native content beats produced content
- First 1 second matters more than Meta
- Trends can work but fatigue fast
- 15-second videos often outperform longer
- Sound on—music/voice critical

### LinkedIn
- Professional tone, but personality works
- Carousel performs well for B2B
- Video under 90 seconds
- Text-heavy images can work
- Thought leadership angle strong

### Google (YouTube/Display)
- YouTube: First 5 seconds critical (skip button)
- Display: Bold, simple, high contrast
- Responsive ads: Provide variety for algorithm
- Video: Consider sound-off experience

---

## Limitations

**I can provide:**
- Testing framework and prioritization
- Hypothesis generation
- Test structure and briefs
- Decision criteria

**I cannot provide:**
- Actual creative production
- Copywriting (beyond frameworks)
- Design or video editing
- Competitor creative analysis (without data)

**For better roadmaps, provide:**
- Current creative performance data
- Historical test results
- Brand guidelines
- Production capacity constraints

---

## Quality Checklist

Before delivering roadmap:
- [ ] Priorities based on testing hierarchy
- [ ] Hypotheses are specific and testable
- [ ] Test briefs include success criteria
- [ ] Calendar matches production capacity
- [ ] Budget allocation is realistic
- [ ] Decision framework is clear
- [ ] Iteration pipeline defined
- [ ] Platform considerations addressed
