# How to Use This Skill

Hey Claude—I just added the "ad-creative-fatigue-detector" skill. Can you analyze my ads and tell me which ones are fatigued?

## Example Invocations

**Example 1: Full Creative Audit**
Hey Claude—I just added the "ad-creative-fatigue-detector" skill. Here's performance data for all my Meta Ads creatives over the last 30 days. Which ones are fatigued and need rotation?

**Example 2: Performance Drop Diagnosis**
Hey Claude—I just added the "ad-creative-fatigue-detector" skill. My Meta Ads CPA jumped 40% in the last 2 weeks. Is this creative fatigue? How do I know which ads to rotate?

**Example 3: Video Ad Analysis**
Hey Claude—I just added the "ad-creative-fatigue-detector" skill. I have 5 video ads running. Here are the hook rates and CTRs by week. Which videos are losing effectiveness?

**Example 4: Rotation Schedule**
Hey Claude—I just added the "ad-creative-fatigue-detector" skill. I need to create a creative rotation schedule for my campaigns. Here's my current performance data—when should I rotate each ad?

**Example 5: Multi-Platform Check**
Hey Claude—I just added the "ad-creative-fatigue-detector" skill. I'm running ads on Meta, TikTok, and LinkedIn. Here's the data—which platform has the most fatigue issues?

## What to Provide

**Required:**
- Ad/creative names or identifiers
- Days each ad has been running
- CTR (click-through rate) for each ad
- Ideally: CTR from first week vs. current week

**Highly Recommended:**
- Frequency (at ad or ad set level)
- CPA or conversion rate
- Impressions
- Platform (Meta, Google, TikTok, LinkedIn)

**For Video Ads:**
- Hook rate / thumb-stop rate (3-second views)
- Average watch time or completion rate

**Optional:**
- Audience size
- Campaign type (prospecting vs. retargeting)
- Historical creative performance
- Week-by-week breakdown

## What You'll Get

1. **Fatigue Score** - 0-100 score for each creative
2. **Status Classification** - Critical/Warning/Monitor/Healthy
3. **Decay Analysis** - How much CTR, CPA, etc. have changed
4. **Root Cause** - Why each creative is fatiguing
5. **Rotation Schedule** - What to rotate and when
6. **Pipeline Recommendations** - How many new creatives you need
7. **Prevention Strategies** - How to slow fatigue in the future

## Pro Tips

- Export ad-level data from Ads Manager including date breakdowns
- Compare Week 1 performance to current week—the delta matters most
- Frequency data is often the earliest warning sign
- Hook rate decay for video is more predictive than CTR
- Don't wait for CPA to spike—that's already too late
- High-performing ads fatigue faster because they get more impressions
