---
name: ad-creative-brief-generator
description: Creates comprehensive creative briefs for ad production—static images, videos, UGC, and agency handoffs. Includes target audience, messaging hierarchy, visual direction, platform specs, and success criteria. Triggers when user asks about "creative brief," "ad brief," "UGC brief," "agency brief," or needs to commission ad creative from designers, creators, or agencies.
---

# Ad Creative Brief Generator

A great brief leads to great creative. A vague brief leads to revisions, frustration, and wasted money.

## Core Philosophy

**The brief is a contract.** It should be so clear that there's no ambiguity about what "good" looks like. If the creative doesn't match the brief, it's the creative's problem. If the brief didn't specify something important, it's your problem.

**Be specific, not restrictive.** A good brief gives clear direction while leaving room for creative interpretation. "Make it pop" = bad. "Use bold contrast with our brand orange to draw attention to the CTA" = good.

**Constraints enable creativity.** Telling someone "make anything you want" is paralyzing. Telling them "30-second video, problem-solution structure, must include product demo by second 10" gives them a framework to be creative within.

**One brief per creative concept.** Don't try to jam multiple ideas into one brief. If you want to test three angles, write three briefs.

**Include the "why."** Creators do better work when they understand the purpose. Don't just say what you want—explain why it matters.

---

## Required Context

### Must Have

**1. Product/Service Information**
- What you're selling
- Key benefits (top 3)
- Unique selling proposition
- Price point / offer

**2. Target Audience**
- Who they are (demographics, psychographics)
- Their problem or desire
- What they've tried before
- Why they should care

**3. Creative Requirements**
- Format (static, video, carousel, UGC)
- Platform(s) (Meta, TikTok, YouTube, etc.)
- Dimensions/specs
- Length (for video)

**4. Deliverables**
- Number of assets needed
- Variations required
- File format requirements

### Strongly Recommended

**5. Messaging Direction**
- Key messages to convey
- Tone of voice
- Things to avoid
- Compliance requirements

**6. Visual Direction**
- Brand guidelines (colors, fonts, logo usage)
- Reference examples (like this / not like this)
- Required elements

**7. Context**
- Where in the funnel (awareness, consideration, conversion)
- Campaign objective
- What's been tested/working

### Nice to Have

- Competitor examples to differentiate from
- Past winning creative examples
- Customer testimonials or quotes to use
- Raw footage or assets available

---

## Brief Framework

### Brief Structure

```
1. PROJECT OVERVIEW
   - What this is for
   - Why we're making it
   - Where it will run

2. AUDIENCE
   - Who they are
   - What they care about
   - What will resonate

3. MESSAGING
   - Key message (one sentence)
   - Supporting points
   - Proof points / claims

4. CREATIVE DIRECTION
   - Format and specs
   - Visual style
   - Tone and mood

5. REQUIREMENTS
   - Must-haves
   - Nice-to-haves
   - Things to avoid

6. DELIVERABLES
   - What we need
   - When we need it
   - File specifications

7. SUCCESS CRITERIA
   - How we'll judge success
   - KPIs to optimize for
```

---

### Messaging Hierarchy Framework

**For every brief, define:**

| Level | What It Is | Example |
|-------|------------|---------|
| Headline/Hook | Single most important message | "Write emails in 30 seconds" |
| Value Proposition | Why this matters to them | "Save 10 hours per week on email" |
| Key Benefits | Top 3 supporting benefits | "AI-powered, integrates with Gmail, learns your style" |
| Proof Points | Evidence/credibility | "Used by 50,000 professionals" |
| CTA | What to do next | "Try free for 14 days" |

**Message Priority:**
1. Hook first (must include)
2. Value proposition (must include)
3. Benefits (include 1-2)
4. Proof (if space allows)
5. CTA (must include)

---

### Visual Direction Options

**Mood/Tone Spectrums:**

| Dimension | Scale |
|-----------|-------|
| Polished ←→ Raw/UGC | Where on this spectrum? |
| Serious ←→ Playful | What energy? |
| Minimal ←→ Busy | How much visual information? |
| Dark ←→ Bright | Color intensity? |
| Corporate ←→ Casual | Formality level? |

**Visual Style Options:**

| Style | Best For | Platform Fit |
|-------|----------|--------------|
| UGC/Authentic | Trust, relatability | TikTok, Meta Reels |
| Lifestyle | Aspiration, emotion | Meta Feed, Pinterest |
| Product-Focused | Features, clarity | Google Shopping, Search |
| Polished/Cinematic | Premium, brand | YouTube, CTV |
| Meme/Native | Engagement, virality | TikTok, Twitter |
| Testimonial | Trust, social proof | All platforms |

---

### Platform-Specific Specs Reference

**Static Image Specs:**

| Platform | Placement | Dimensions | Max File |
|----------|-----------|------------|----------|
| Meta | Feed | 1080x1080 or 1080x1350 | 30MB |
| Meta | Stories | 1080x1920 | 30MB |
| Google | Display | Various (300x250, 728x90, etc.) | 150KB |
| LinkedIn | Feed | 1200x627 or 1080x1080 | 5MB |
| TikTok | Feed | 1080x1920 | 500MB |

**Video Specs:**

| Platform | Placement | Dimensions | Length | Max File |
|----------|-----------|------------|--------|----------|
| Meta | Feed | 1080x1080 or 1080x1350 | :15-:60 | 4GB |
| Meta | Stories/Reels | 1080x1920 | :15-:90 | 4GB |
| TikTok | Feed | 1080x1920 | :15-:60 | 500MB |
| YouTube | In-stream | 1920x1080 | :15-:30 | 1GB |
| YouTube | Shorts | 1080x1920 | :60 max | 1GB |
| LinkedIn | Feed | 1920x1080 or 1080x1080 | :15-:30 | 200MB |

---

## Output Format

### Creative Brief Document

```
═══════════════════════════════════════════════════════════════════
CREATIVE BRIEF
═══════════════════════════════════════════════════════════════════
Project: [Brief Title]
Brand: [Brand Name]
Date: [Date]
Version: [v1.0]
Brief Owner: [Name/Role]
═══════════════════════════════════════════════════════════════════

📋 PROJECT OVERVIEW
────────────────────────────────────────────────────────────────────

PURPOSE:
[Why we're creating this creative. What problem it solves or goal it achieves.]

CAMPAIGN CONTEXT:
- Campaign name: [Name]
- Funnel stage: [Awareness / Consideration / Conversion]
- Platform(s): [Where this will run]
- Flight dates: [When this will run]
- Budget context: [If relevant]

SUCCESS LOOKS LIKE:
[What will this creative achieve if it works?]

═══════════════════════════════════════════════════════════════════

👥 TARGET AUDIENCE
────────────────────────────────────────────────────────────────────

WHO THEY ARE:
- Demographics: [Age, gender, location, income if relevant]
- Psychographics: [Values, interests, lifestyle]
- Role/Title: [If B2B]

THEIR SITUATION:
- Problem they have: [What pain point?]
- Desire they have: [What do they want?]
- Current behavior: [What are they doing now?]
- Barriers: [What stops them from buying?]

WHAT RESONATES:
- Motivations: [What drives them?]
- Language they use: [How do they talk about this problem?]
- What they respond to: [Emotional vs logical, etc.]

AUDIENCE INSIGHT:
"[One sentence that captures a key insight about this audience]"

═══════════════════════════════════════════════════════════════════

💬 MESSAGING
────────────────────────────────────────────────────────────────────

KEY MESSAGE (ONE SENTENCE):
"[The single most important takeaway]"

MESSAGING HIERARCHY:

| Priority | Element | Content |
|----------|---------|---------|
| 1 | Hook/Headline | [Exact text or direction] |
| 2 | Value Proposition | [Why they should care] |
| 3 | Key Benefit #1 | [Supporting benefit] |
| 4 | Key Benefit #2 | [Supporting benefit] |
| 5 | Proof Point | [Evidence/credibility] |
| 6 | CTA | [Exact CTA text] |

CLAIMS WE CAN MAKE:
- [Approved claim #1]
- [Approved claim #2]
- [Approved claim #3]

CLAIMS TO AVOID:
- [Restricted claim #1]
- [Restricted claim #2]

TONE OF VOICE:
[Describe the voice - e.g., "Confident but not arrogant. Conversational, like talking to a smart friend. Uses simple language, avoids jargon."]

═══════════════════════════════════════════════════════════════════

🎨 CREATIVE DIRECTION
────────────────────────────────────────────────────────────────────

FORMAT:
- Type: [Static / Video / Carousel / UGC / etc.]
- Platform: [Meta / TikTok / YouTube / etc.]
- Placement: [Feed / Stories / Reels / etc.]
- Dimensions: [Specs]
- Duration: [For video: X seconds]

VISUAL STYLE:

| Dimension | Direction |
|-----------|-----------|
| Polish level | [Raw/UGC / Semi-polished / Highly produced] |
| Mood | [Serious / Playful / Urgent / Calm / etc.] |
| Energy | [High / Medium / Low] |
| Color palette | [Brand colors / Specific direction] |

REFERENCE EXAMPLES:

✅ LIKE THIS:
- [Example 1 - link or description + why]
- [Example 2 - link or description + why]

❌ NOT LIKE THIS:
- [Example 1 - link or description + why to avoid]
- [Example 2 - link or description + why to avoid]

VISUAL MUST-HAVES:
- [ ] [Required visual element #1]
- [ ] [Required visual element #2]
- [ ] [Required visual element #3]

═══════════════════════════════════════════════════════════════════

[FOR VIDEO CREATIVE]

🎬 VIDEO STRUCTURE
────────────────────────────────────────────────────────────────────

STRUCTURE:

| Section | Timing | Content | Notes |
|---------|--------|---------|-------|
| Hook | 0-3s | [What happens] | [Direction] |
| Problem/Setup | 3-10s | [What happens] | [Direction] |
| Solution/Demo | 10-20s | [What happens] | [Direction] |
| Proof/Benefits | 20-25s | [What happens] | [Direction] |
| CTA | 25-30s | [What happens] | [Direction] |

HOOK OPTIONS (pick one or test multiple):
1. [Hook idea #1]
2. [Hook idea #2]
3. [Hook idea #3]

SCRIPTED ELEMENTS:
- Must say: "[Exact phrase if required]"
- Must show: [Product/feature that must appear]
- CTA: "[Exact CTA if specified]"

AUDIO DIRECTION:
- Music: [Upbeat / Calm / Trending sound / No music]
- Voiceover: [Yes/No - if yes, who?]
- Captions: [Required - style notes]

═══════════════════════════════════════════════════════════════════

[FOR UGC CREATIVE]

🎤 UGC CREATOR BRIEF
────────────────────────────────────────────────────────────────────

CREATOR PROFILE:
- Type: [Customer / Influencer / Actor / etc.]
- Demographics: [Who should they be?]
- Vibe: [How should they come across?]
- Setting: [Where should they film?]

CONTENT TYPE:
- [ ] Testimonial (sharing experience)
- [ ] Tutorial/How-to
- [ ] Unboxing/First impression
- [ ] Problem-solution
- [ ] Day-in-the-life
- [ ] Review/Comparison

SCRIPT/TALKING POINTS:

**Opening (MUST SAY):**
"[Exact hook or direction for opening]"

**Middle (KEY POINTS TO HIT):**
- [Point 1 - can be paraphrased]
- [Point 2 - can be paraphrased]
- [Point 3 - can be paraphrased]

**Closing (MUST SAY):**
"[Exact CTA or direction for closing]"

WHAT NOT TO SAY:
- [Restricted phrase #1]
- [Restricted phrase #2]

PRODUCT SHOTS NEEDED:
- [ ] [Shot type #1]
- [ ] [Shot type #2]

═══════════════════════════════════════════════════════════════════

📦 DELIVERABLES
────────────────────────────────────────────────────────────────────

WHAT WE NEED:

| Deliverable | Specs | Quantity |
|-------------|-------|----------|
| [Asset type] | [Dimensions, format] | [Number] |
| [Asset type] | [Dimensions, format] | [Number] |
| [Asset type] | [Dimensions, format] | [Number] |

FILE SPECIFICATIONS:
- Format: [MP4, MOV, JPG, PNG, etc.]
- Resolution: [Minimum resolution]
- File naming: [Convention if any]

TIMELINE:

| Milestone | Date |
|-----------|------|
| Brief finalized | [Date] |
| First draft due | [Date] |
| Feedback provided | [Date] |
| Final assets due | [Date] |
| Go-live date | [Date] |

REVISION POLICY:
[X rounds of revisions included]

═══════════════════════════════════════════════════════════════════

✅ REQUIREMENTS CHECKLIST
────────────────────────────────────────────────────────────────────

MUST-HAVES (Non-negotiable):
- [ ] [Requirement #1]
- [ ] [Requirement #2]
- [ ] [Requirement #3]
- [ ] [Requirement #4]

NICE-TO-HAVES (If possible):
- [ ] [Nice-to-have #1]
- [ ] [Nice-to-have #2]

THINGS TO AVOID:
- ❌ [Avoid this #1]
- ❌ [Avoid this #2]
- ❌ [Avoid this #3]

BRAND GUIDELINES:
- Logo usage: [Rules]
- Colors: [Primary: X, Secondary: Y]
- Fonts: [Font name(s)]
- [Link to full brand guidelines if available]

COMPLIANCE/LEGAL:
- [Any legal requirements]
- [Platform policy considerations]
- [Disclaimer requirements]

═══════════════════════════════════════════════════════════════════

📊 SUCCESS CRITERIA
────────────────────────────────────────────────────────────────────

PRIMARY KPI:
[What metric are we optimizing for?]

SUCCESS BENCHMARKS:

| Metric | Target | Current Benchmark |
|--------|--------|-------------------|
| [KPI 1] | [Target] | [Current average] |
| [KPI 2] | [Target] | [Current average] |

HOW WE'LL EVALUATE:
[How will we judge if this creative is successful?]

═══════════════════════════════════════════════════════════════════

📎 APPENDIX
────────────────────────────────────────────────────────────────────

ASSETS PROVIDED:
- [ ] Logo files: [Link]
- [ ] Brand guidelines: [Link]
- [ ] Product images: [Link]
- [ ] B-roll footage: [Link]
- [ ] Reference examples: [Link]

CONTACTS:

| Role | Name | Contact |
|------|------|---------|
| Brief owner | [Name] | [Email] |
| Approver | [Name] | [Email] |
| Designer/Creator | [Name] | [Email] |

NOTES:
[Any additional context or information]

═══════════════════════════════════════════════════════════════════
```

---

## Brief Types

### Static Image Brief (Simplified)

Focus on:
- Single clear message
- Visual composition direction
- Text overlay specifications
- Platform-specific sizing

### Video Brief (Expanded)

Include:
- Scene-by-scene structure
- Timing requirements
- Audio direction
- Hook variations to test
- Scripted vs. ad-lib sections

### UGC Creator Brief

Emphasize:
- Creator profile and selection criteria
- Talking points (not full scripts)
- What they must say vs. can paraphrase
- Authenticity guidelines
- Product handling instructions

### Agency/Production Brief

Add:
- Budget parameters
- Production requirements
- Approval workflow
- Rights and usage
- Revision process

---

## Common Scenarios

### Scenario 1: "I need creative but don't know what angle"
**Before writing brief:**
1. Review past performance data - what's worked?
2. Look at competitor creative
3. Survey customers about their pain points
4. Identify 2-3 angles to test

**Brief approach:** Write separate briefs for each angle, keep consistent format for comparison.

### Scenario 2: "My UGC creator content doesn't convert"
**Common brief issues:**
- Too scripted (sounds fake)
- Not scripted enough (misses key messages)
- Wrong creator profile for audience
- No clear CTA direction

**Better brief:** Provide exact hook and CTA, let middle be natural talking points.

### Scenario 3: "Agency keeps missing the mark"
**Brief improvements:**
- Add more reference examples (like this / not like this)
- Be explicit about what "good" looks like
- Include approval criteria in brief
- Have kickoff call to walk through brief

### Scenario 4: "I need to test multiple hooks"
**Brief structure:**
- One master brief for all production elements
- Separate hook section with 3-5 hook concepts
- Same everything else (body, CTA, visual style)
- Clear instructions to produce hook variations

### Scenario 5: "Fast turnaround needed"
**Streamlined brief:**
- Focus on must-haves only
- Skip nice-to-haves
- Use proven formulas, not experiments
- Provide all assets upfront
- Single round of revisions

---

## Limitations

**I can provide:**
- Comprehensive brief structure
- Messaging and direction framework
- Platform specifications
- Process and timeline recommendations
- Checklist for completeness

**I cannot provide:**
- Actual visual designs or mockups
- Video scripts (use video-ad-script-writer skill)
- Creator sourcing or management
- Legal/compliance approval
- Budget recommendations

**For production, you'll need:**
- Designers, videographers, or creators
- Brand assets (logos, guidelines)
- Product images/footage
- Approval from stakeholders

---

## Quality Checklist

Before sending brief:
- [ ] Single clear message defined
- [ ] Target audience described in detail
- [ ] Visual direction specific (not vague)
- [ ] Platform specs included and accurate
- [ ] Must-haves vs nice-to-haves separated
- [ ] Reference examples provided
- [ ] Timeline realistic
- [ ] Approval process clear
- [ ] All assets provided or linked
- [ ] Success criteria defined
- [ ] No conflicting requirements
- [ ] Brief reviewed by someone who will approve final creative
