# How to Use This Skill

Hey Claude—I just added the "audience-overlap-analyzer" skill. Can you check if my audiences are overlapping and competing against each other?

## Example Invocations

**Example 1: Full Overlap Audit**
Hey Claude—I just added the "audience-overlap-analyzer" skill. Here are all my Meta Ads audiences with their targeting criteria and performance. Find the overlaps and tell me what to consolidate.

**Example 2: Rising CPM Investigation**
Hey Claude—I just added the "audience-overlap-analyzer" skill. My CPMs have increased 30% in the last month across multiple campaigns. Could audience overlap be the cause? Here's my audience data.

**Example 3: Lookalike Strategy**
Hey Claude—I just added the "audience-overlap-analyzer" skill. I'm running 1%, 2%, and 3% lookalikes. How much are they overlapping and should I structure this differently?

**Example 4: Retargeting Audit**
Hey Claude—I just added the "audience-overlap-analyzer" skill. I have 5 different retargeting audiences. Help me figure out which ones overlap and how to set up proper exclusions.

**Example 5: Cross-Campaign Check**
Hey Claude—I just added the "audience-overlap-analyzer" skill. I'm running 3 prospecting campaigns to different audiences but I suspect they're hitting the same people. Here's the data.

## What to Provide

**Required:**
- Audience names
- Targeting criteria (interests, behaviors, lookalike %, custom audience source)
- Audience sizes
- Which campaigns use which audiences

**Highly Recommended:**
- Spend per audience
- CPM per audience
- Frequency per audience
- Any existing exclusions

**Optional:**
- Meta Audience Overlap tool results (screenshots)
- Historical CPM trends
- Conversion data per audience
- Cross-platform audience usage

## What You'll Get

1. **Overlap Matrix** - Visual map of which audiences overlap
2. **Severity Scoring** - Priority ranking of overlap issues
3. **Impact Estimate** - How much overlap is costing you
4. **Consolidation Plan** - Which audiences to merge
5. **Exclusion Strategy** - Proper exclusion hierarchy
6. **Structure Recommendation** - Optimized audience architecture
7. **Action Plan** - Step-by-step implementation

## Pro Tips

- Use Meta's Audience Overlap tool (Audiences → Select 2+ → Compare)
- Lookalikes always overlap—1% is contained within 2%, 2% within 3%
- Exclude retargeting audiences from prospecting to prevent collision
- Rising CPMs across campaigns is a strong signal of overlap
- Consider Advantage+ targeting—it manages overlap automatically
- Frequency >3 combined across campaigns usually indicates overlap
